/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.api.entity;

import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.ForeignKey;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Table;
import java.util.Objects;
import net.ideahut.springboot.annotation.ApiExclude;
import net.ideahut.springboot.annotation.Audit;
import net.ideahut.springboot.api.entity.ApiProvider;
import net.ideahut.springboot.entity.EntityAudit;
import org.hibernate.annotations.JdbcTypeCode;
import org.hibernate.annotations.OnDelete;
import org.hibernate.annotations.OnDeleteAction;

@ApiExclude
@Audit
@Entity
@Table(name="api_provider_config")
public class ApiProviderConfig
extends EntityAudit {
    @Id
    @Column(name="api_name", nullable=false, length=128)
    private String apiName;
    @Id
    @Column(name="config_name", nullable=false, length=128)
    private String configName;
    @JdbcTypeCode(value=-1)
    @Column(name="config_value")
    private String configValue;
    @OnDelete(action=OnDeleteAction.CASCADE)
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="api_name", nullable=false, insertable=false, updatable=false, foreignKey=@ForeignKey(name="fk_api_provider_config__api_provider"))
    private ApiProvider apiProvider;

    public int hashCode() {
        return Objects.hash(this.apiName, this.configName);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ApiProviderConfig other = (ApiProviderConfig)obj;
        return Objects.equals(this.apiName, other.apiName) && Objects.equals(this.configName, other.configName);
    }

    public void setApiName(String apiName) {
        this.apiName = apiName;
    }

    public void setConfigName(String configName) {
        this.configName = configName;
    }

    public void setConfigValue(String configValue) {
        this.configValue = configValue;
    }

    public void setApiProvider(ApiProvider apiProvider) {
        this.apiProvider = apiProvider;
    }

    public String getApiName() {
        return this.apiName;
    }

    public String getConfigName() {
        return this.configName;
    }

    public String getConfigValue() {
        return this.configValue;
    }

    public ApiProvider getApiProvider() {
        return this.apiProvider;
    }
}

