/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.api.entity;

import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.ForeignKey;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Table;
import java.util.Objects;
import net.ideahut.springboot.annotation.ApiExclude;
import net.ideahut.springboot.annotation.Audit;
import net.ideahut.springboot.api.entity.ApiCrud;
import net.ideahut.springboot.api.entity.ApiProvider;
import net.ideahut.springboot.entity.EntityAudit;
import org.hibernate.annotations.OnDelete;
import org.hibernate.annotations.OnDeleteAction;

@ApiExclude
@Audit
@Entity
@Table(name="api_provider_crud")
public class ApiProviderCrud
extends EntityAudit {
    @Id
    @Column(name="api_name", nullable=false, length=128)
    private String apiName;
    @Id
    @Column(name="api_crud_code", nullable=false, length=128)
    private String apiCrudCode;
    @OnDelete(action=OnDeleteAction.CASCADE)
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="api_name", nullable=false, insertable=false, updatable=false, foreignKey=@ForeignKey(name="fk_api_provider_crud__api_provider"))
    private ApiProvider apiProvider;
    @OnDelete(action=OnDeleteAction.CASCADE)
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="api_crud_code", nullable=false, insertable=false, updatable=false, foreignKey=@ForeignKey(name="fk_api_provider_crud__api_crud"))
    private ApiCrud apiCrud;

    public int hashCode() {
        return Objects.hash(this.apiCrudCode, this.apiName);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ApiProviderCrud other = (ApiProviderCrud)obj;
        return Objects.equals(this.apiCrudCode, other.apiCrudCode) && Objects.equals(this.apiName, other.apiName);
    }

    public void setApiName(String apiName) {
        this.apiName = apiName;
    }

    public void setApiCrudCode(String apiCrudCode) {
        this.apiCrudCode = apiCrudCode;
    }

    public void setApiProvider(ApiProvider apiProvider) {
        this.apiProvider = apiProvider;
    }

    public void setApiCrud(ApiCrud apiCrud) {
        this.apiCrud = apiCrud;
    }

    public String getApiName() {
        return this.apiName;
    }

    public String getApiCrudCode() {
        return this.apiCrudCode;
    }

    public ApiProvider getApiProvider() {
        return this.apiProvider;
    }

    public ApiCrud getApiCrud() {
        return this.apiCrud;
    }
}

