/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.api.entity;

import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.ForeignKey;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Table;
import java.util.Objects;
import net.ideahut.springboot.annotation.ApiExclude;
import net.ideahut.springboot.annotation.Audit;
import net.ideahut.springboot.api.entity.ApiProvider;
import net.ideahut.springboot.entity.EntityAudit;
import org.hibernate.annotations.OnDelete;
import org.hibernate.annotations.OnDeleteAction;

@ApiExclude
@Audit
@Entity
@Table(name="api_provider_host")
public class ApiProviderHost
extends EntityAudit {
    @Id
    @Column(name="api_name", nullable=false, length=128)
    private String apiName;
    @Id
    @Column(name="host", nullable=false, length=64)
    private String host;
    @OnDelete(action=OnDeleteAction.CASCADE)
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="api_name", nullable=false, insertable=false, updatable=false, foreignKey=@ForeignKey(name="fk_api_provider_host__api_provider"))
    private ApiProvider apiProvider;

    public int hashCode() {
        return Objects.hash(this.apiName, this.host);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ApiProviderHost other = (ApiProviderHost)obj;
        return Objects.equals(this.apiName, other.apiName) && Objects.equals(this.host, other.host);
    }

    public void setApiName(String apiName) {
        this.apiName = apiName;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setApiProvider(ApiProvider apiProvider) {
        this.apiProvider = apiProvider;
    }

    public String getApiName() {
        return this.apiName;
    }

    public String getHost() {
        return this.host;
    }

    public ApiProvider getApiProvider() {
        return this.apiProvider;
    }
}

