/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.api.entity;

import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.ForeignKey;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Table;
import java.util.Objects;
import net.ideahut.springboot.annotation.ApiExclude;
import net.ideahut.springboot.annotation.Audit;
import net.ideahut.springboot.api.entity.ApiProvider;
import net.ideahut.springboot.entity.EntityAudit;
import org.hibernate.annotations.OnDelete;
import org.hibernate.annotations.OnDeleteAction;

@ApiExclude
@Audit
@Entity
@Table(name="api_provider_request")
public class ApiProviderRequest
extends EntityAudit {
    @Id
    @Column(name="api_name", nullable=false, length=128)
    private String apiName;
    @Id
    @Column(name="package_name", nullable=false)
    private String packageName;
    @Id
    @Column(name="class_name", nullable=false, length=128)
    private String className;
    @Id
    @Column(name="function_name", nullable=false, length=128)
    private String functionName;
    @Id
    @Column(name="parameter_count", nullable=false)
    private Integer parameterCount;
    @Column(name="patterns", length=1024)
    private String patterns;
    @Column(name="methods")
    private String methods;
    @Column(name="consumes")
    private String consumes;
    @Column(name="produces")
    private String produces;
    @OnDelete(action=OnDeleteAction.CASCADE)
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="api_name", nullable=false, insertable=false, updatable=false, foreignKey=@ForeignKey(name="fk_api_provider_request__api_provider"))
    private ApiProvider apiProvider;

    public int hashCode() {
        return Objects.hash(this.apiName, this.className, this.functionName, this.packageName, this.parameterCount);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ApiProviderRequest other = (ApiProviderRequest)obj;
        return Objects.equals(this.apiName, other.apiName) && Objects.equals(this.className, other.className) && Objects.equals(this.functionName, other.functionName) && Objects.equals(this.packageName, other.packageName) && Objects.equals(this.parameterCount, other.parameterCount);
    }

    public void setApiName(String apiName) {
        this.apiName = apiName;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public void setFunctionName(String functionName) {
        this.functionName = functionName;
    }

    public void setParameterCount(Integer parameterCount) {
        this.parameterCount = parameterCount;
    }

    public void setPatterns(String patterns) {
        this.patterns = patterns;
    }

    public void setMethods(String methods) {
        this.methods = methods;
    }

    public void setConsumes(String consumes) {
        this.consumes = consumes;
    }

    public void setProduces(String produces) {
        this.produces = produces;
    }

    public void setApiProvider(ApiProvider apiProvider) {
        this.apiProvider = apiProvider;
    }

    public String getApiName() {
        return this.apiName;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getClassName() {
        return this.className;
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public Integer getParameterCount() {
        return this.parameterCount;
    }

    public String getPatterns() {
        return this.patterns;
    }

    public String getMethods() {
        return this.methods;
    }

    public String getConsumes() {
        return this.consumes;
    }

    public String getProduces() {
        return this.produces;
    }

    public ApiProvider getApiProvider() {
        return this.apiProvider;
    }
}

