/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.api.entity;

import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.ForeignKey;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Table;
import java.util.Objects;
import net.ideahut.springboot.annotation.ApiExclude;
import net.ideahut.springboot.annotation.Audit;
import net.ideahut.springboot.api.entity.ApiProvider;
import net.ideahut.springboot.entity.EntityAudit;
import org.hibernate.annotations.OnDelete;
import org.hibernate.annotations.OnDeleteAction;

@ApiExclude
@Audit
@Entity
@Table(name="api_provider_role")
public class ApiProviderRole
extends EntityAudit {
    @Id
    @Column(name="role_code", nullable=false, length=64)
    private String roleCode;
    @Id
    @Column(name="api_name", nullable=false, length=128)
    private String apiName;
    @Column(name="api_role_code", nullable=false, length=64)
    private String apiRoleCode;
    @Column(name="is_active", nullable=false, length=1)
    private Character isActive;
    @OnDelete(action=OnDeleteAction.CASCADE)
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="api_name", nullable=false, insertable=false, updatable=false, foreignKey=@ForeignKey(name="fk_api_provider_role__api_provider"))
    private ApiProvider apiProvider;

    public int hashCode() {
        return Objects.hash(this.apiName, this.roleCode);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ApiProviderRole other = (ApiProviderRole)obj;
        return Objects.equals(this.apiName, other.apiName) && Objects.equals(this.roleCode, other.roleCode);
    }

    public void setRoleCode(String roleCode) {
        this.roleCode = roleCode;
    }

    public void setApiName(String apiName) {
        this.apiName = apiName;
    }

    public void setApiRoleCode(String apiRoleCode) {
        this.apiRoleCode = apiRoleCode;
    }

    public void setIsActive(Character isActive) {
        this.isActive = isActive;
    }

    public void setApiProvider(ApiProvider apiProvider) {
        this.apiProvider = apiProvider;
    }

    public String getRoleCode() {
        return this.roleCode;
    }

    public String getApiName() {
        return this.apiName;
    }

    public String getApiRoleCode() {
        return this.apiRoleCode;
    }

    public Character getIsActive() {
        return this.isActive;
    }

    public ApiProvider getApiProvider() {
        return this.apiProvider;
    }
}

