/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.api.entity;

import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.ForeignKey;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Table;
import java.util.Objects;
import net.ideahut.springboot.annotation.ApiExclude;
import net.ideahut.springboot.annotation.Audit;
import net.ideahut.springboot.api.entity.ApiCrud;
import net.ideahut.springboot.api.entity.ApiRole;
import net.ideahut.springboot.entity.EntityAudit;
import org.hibernate.annotations.OnDelete;
import org.hibernate.annotations.OnDeleteAction;

@ApiExclude
@Audit
@Entity
@Table(name="api_role_crud")
public class ApiRoleCrud
extends EntityAudit {
    @Id
    @Column(name="api_role_code", nullable=false, length=64)
    private String apiRoleCode;
    @Id
    @Column(name="api_crud_code", nullable=false, length=128)
    private String apiCrudCode;
    @OnDelete(action=OnDeleteAction.CASCADE)
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="api_role_code", nullable=false, insertable=false, updatable=false, foreignKey=@ForeignKey(name="fk_api_role_crud__api_role"))
    private ApiRole apiRole;
    @OnDelete(action=OnDeleteAction.CASCADE)
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="api_crud_code", nullable=false, insertable=false, updatable=false, foreignKey=@ForeignKey(name="fk_api_role_crud__api_crud"))
    private ApiCrud apiCrud;

    public int hashCode() {
        return Objects.hash(this.apiCrudCode, this.apiRoleCode);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ApiRoleCrud other = (ApiRoleCrud)obj;
        return Objects.equals(this.apiCrudCode, other.apiCrudCode) && Objects.equals(this.apiRoleCode, other.apiRoleCode);
    }

    public void setApiRoleCode(String apiRoleCode) {
        this.apiRoleCode = apiRoleCode;
    }

    public void setApiCrudCode(String apiCrudCode) {
        this.apiCrudCode = apiCrudCode;
    }

    public void setApiRole(ApiRole apiRole) {
        this.apiRole = apiRole;
    }

    public void setApiCrud(ApiCrud apiCrud) {
        this.apiCrud = apiCrud;
    }

    public String getApiRoleCode() {
        return this.apiRoleCode;
    }

    public String getApiCrudCode() {
        return this.apiCrudCode;
    }

    public ApiRole getApiRole() {
        return this.apiRole;
    }

    public ApiCrud getApiCrud() {
        return this.apiCrud;
    }
}

