/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.api.entity;

import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.ForeignKey;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.JoinColumns;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Table;
import java.util.Objects;
import net.ideahut.springboot.annotation.ApiExclude;
import net.ideahut.springboot.annotation.Audit;
import net.ideahut.springboot.api.entity.ApiCrud;
import net.ideahut.springboot.api.entity.ApiRole;
import net.ideahut.springboot.api.entity.ApiRoleCrud;
import net.ideahut.springboot.entity.EntityAudit;
import org.hibernate.annotations.OnDelete;
import org.hibernate.annotations.OnDeleteAction;

@ApiExclude
@Audit
@Entity
@Table(name="api_role_crud_action")
public class ApiRoleCrudAction
extends EntityAudit {
    @Id
    @Column(name="api_role_code", nullable=false, length=64)
    private String apiRoleCode;
    @Id
    @Column(name="api_crud_code", nullable=false, length=128)
    private String apiCrudCode;
    @Id
    @Column(name="action", nullable=false, length=32)
    private String action;
    @OnDelete(action=OnDeleteAction.CASCADE)
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumns(value={@JoinColumn(name="api_role_code", referencedColumnName="api_role_code", nullable=false, insertable=false, updatable=false), @JoinColumn(name="api_crud_code", referencedColumnName="api_crud_code", nullable=false, insertable=false, updatable=false)}, foreignKey=@ForeignKey(name="fk_api_role_crud_action__api_crud_role"))
    private ApiRoleCrud apiCrudRole;
    @OnDelete(action=OnDeleteAction.CASCADE)
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="api_role_code", nullable=false, insertable=false, updatable=false, foreignKey=@ForeignKey(name="fk_api_role_crud_action__api_role"))
    private ApiRole apiRole;
    @OnDelete(action=OnDeleteAction.CASCADE)
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="api_crud_code", nullable=false, insertable=false, updatable=false, foreignKey=@ForeignKey(name="fk_api_role_crud_action__api_crud"))
    private ApiCrud apiCrud;

    public int hashCode() {
        return Objects.hash(this.action, this.apiCrudCode, this.apiRoleCode);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ApiRoleCrudAction other = (ApiRoleCrudAction)obj;
        return Objects.equals(this.action, other.action) && Objects.equals(this.apiCrudCode, other.apiCrudCode) && Objects.equals(this.apiRoleCode, other.apiRoleCode);
    }

    public void setApiRoleCode(String apiRoleCode) {
        this.apiRoleCode = apiRoleCode;
    }

    public void setApiCrudCode(String apiCrudCode) {
        this.apiCrudCode = apiCrudCode;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public void setApiCrudRole(ApiRoleCrud apiCrudRole) {
        this.apiCrudRole = apiCrudRole;
    }

    public void setApiRole(ApiRole apiRole) {
        this.apiRole = apiRole;
    }

    public void setApiCrud(ApiCrud apiCrud) {
        this.apiCrud = apiCrud;
    }

    public String getApiRoleCode() {
        return this.apiRoleCode;
    }

    public String getApiCrudCode() {
        return this.apiCrudCode;
    }

    public String getAction() {
        return this.action;
    }

    public ApiRoleCrud getApiCrudRole() {
        return this.apiCrudRole;
    }

    public ApiRole getApiRole() {
        return this.apiRole;
    }

    public ApiCrud getApiCrud() {
        return this.apiCrud;
    }
}

