/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.api.entity;

import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.ForeignKey;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.JoinColumns;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Table;
import net.ideahut.springboot.annotation.ApiExclude;
import net.ideahut.springboot.annotation.Audit;
import net.ideahut.springboot.api.entity.ApiCrud;
import net.ideahut.springboot.api.entity.ApiRole;
import net.ideahut.springboot.api.entity.ApiRoleCrud;
import net.ideahut.springboot.entity.EntityAudit;
import net.ideahut.springboot.generator.UUIDGenerator;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.OnDelete;
import org.hibernate.annotations.OnDeleteAction;

@ApiExclude
@Audit
@Entity
@Table(name="api_role_crud_filter")
public class ApiRoleCrudFilter
extends EntityAudit {
    @Id
    @GeneratedValue(generator="UUIDGenerator")
    @GenericGenerator(name="UUIDGenerator", type=UUIDGenerator.class)
    @Column(name="filter_id", unique=true, nullable=false, length=64)
    private String filterId;
    @Column(name="field_name", nullable=false, length=128)
    private String fieldName;
    @Column(name="is_plain_value", nullable=false)
    private Character isPlainValue;
    @Column(name="filter_value", nullable=false, length=1024)
    private String filterValue;
    @OnDelete(action=OnDeleteAction.CASCADE)
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumns(value={@JoinColumn(name="api_role_code", referencedColumnName="api_role_code", nullable=false, insertable=true, updatable=true), @JoinColumn(name="api_crud_code", referencedColumnName="api_crud_code", nullable=false, insertable=true, updatable=true)}, foreignKey=@ForeignKey(name="fk_api_role_crud_filter__api_crud_role"))
    private ApiRoleCrud apiCrudRole;
    @OnDelete(action=OnDeleteAction.CASCADE)
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="api_role_code", nullable=false, insertable=false, updatable=false, foreignKey=@ForeignKey(name="fk_api_role_crud_filter__api_role"))
    private ApiRole apiRole;
    @OnDelete(action=OnDeleteAction.CASCADE)
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="api_crud_code", nullable=false, insertable=false, updatable=false, foreignKey=@ForeignKey(name="fk_api_role_crud_filter__api_crud"))
    private ApiCrud apiCrud;

    public void setFilterId(String filterId) {
        this.filterId = filterId;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    public void setIsPlainValue(Character isPlainValue) {
        this.isPlainValue = isPlainValue;
    }

    public void setFilterValue(String filterValue) {
        this.filterValue = filterValue;
    }

    public void setApiCrudRole(ApiRoleCrud apiCrudRole) {
        this.apiCrudRole = apiCrudRole;
    }

    public void setApiRole(ApiRole apiRole) {
        this.apiRole = apiRole;
    }

    public void setApiCrud(ApiCrud apiCrud) {
        this.apiCrud = apiCrud;
    }

    public String getFilterId() {
        return this.filterId;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public Character getIsPlainValue() {
        return this.isPlainValue;
    }

    public String getFilterValue() {
        return this.filterValue;
    }

    public ApiRoleCrud getApiCrudRole() {
        return this.apiCrudRole;
    }

    public ApiRole getApiRole() {
        return this.apiRole;
    }

    public ApiCrud getApiCrud() {
        return this.apiCrud;
    }
}

