/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.api.processor;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import net.ideahut.springboot.api.ApiAccess;
import net.ideahut.springboot.api.ApiHeader;
import net.ideahut.springboot.api.ApiParameter;
import net.ideahut.springboot.api.ApiProcessor;
import net.ideahut.springboot.api.ApiRequest;
import net.ideahut.springboot.api.ApiService;
import net.ideahut.springboot.api.ApiSource;
import net.ideahut.springboot.exception.ResultException;
import net.ideahut.springboot.mapper.DataMapper;
import net.ideahut.springboot.object.Message;
import net.ideahut.springboot.object.Result;
import net.ideahut.springboot.object.StringMap;
import net.ideahut.springboot.util.FrameworkUtil;
import net.ideahut.springboot.util.TimeUtil;
import okhttp3.Call;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.util.Assert;

final class ProcessorHelper {
    private static final Logger log = LoggerFactory.getLogger(ProcessorHelper.class);

    private ProcessorHelper() {
    }

    private static void close(Response response) {
        if (response != null) {
            try {
                response.body().close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                response.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static ApiAccess getApiAccess(DataMapper dataMapper, Response response) throws Exception {
        int status = response.code();
        ResponseBody body = response.body();
        if (HttpStatus.OK.value() == status) {
            JsonNode data = dataMapper.read(body.byteStream(), JsonNode.class);
            int rstat = data.get("status").asInt();
            if (1 == rstat) {
                Object errmsg = "REQ-00";
                List<Message> errors = dataMapper.copy((Object)data.get("error"), TypeRef.ERROR_LIST);
                if (errors != null && !errors.isEmpty()) {
                    Message ssem = errors.get(errors.size() - 1);
                    errmsg = ssem.getCode() + ": " + ssem.getText();
                }
                throw new Exception((String)errmsg);
            }
            return dataMapper.copy((Object)data.get("data"), ApiAccess.class);
        }
        throw new Exception("HTTP-" + status);
    }

    static <T> T throwIfTrue(ApiProcessor processor, String errorCode, boolean condition) throws Exception {
        if (condition) {
            throw new ResultException(Result.error((String)(processor.getApiType() + "-" + errorCode)));
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ApiAccess getRemoteApiAccess(ApiProcessor apiProcessor, ApiService apiService, ApiSource apiSource, ApiParameter apiParameter) throws Exception {
        String apiName = apiSource != null && apiSource.getApiName() != null ? apiSource.getApiName().trim() : "";
        ProcessorHelper.throwIfTrue(apiProcessor, "80", apiName.isEmpty());
        ApiHeader apiHeader = apiService.getApiHeader();
        StringMap config = FrameworkUtil.getOrDefault(apiSource.getConfig(), new StringMap());
        String url = FrameworkUtil.getOrDefault(apiSource.getAccessUrl(), "").trim();
        ProcessorHelper.throwIfTrue(apiProcessor, "81", url == null || url.isEmpty());
        String method = ((String)config.getOrDefault((Object)"ACCESS_METHOD", (Object)"")).trim().toUpperCase();
        if (method.isEmpty()) {
            method = "GET";
        }
        String secret = FrameworkUtil.getOrDefault(apiSource.getSecret(), "");
        Integer connectTimeout = (Integer)config.getValue(Integer.class, "ACCESS_TIMEOUT_CONNECT", (Object)10);
        Integer callTimeout = (Integer)config.getValue(Integer.class, "ACCESS_TIMEOUT_CALL", (Object)30);
        Response response = null;
        try {
            OkHttpClient client = new OkHttpClient().newBuilder().connectTimeout((long)connectTimeout.intValue(), TimeUnit.SECONDS).callTimeout((long)callTimeout.intValue(), TimeUnit.SECONDS).build();
            Request.Builder builder = new Request.Builder().url(url).method(method, null);
            ApiRequest apiRequest = FrameworkUtil.getOrDefault(apiParameter.getApiRequest(), new ApiRequest());
            Map headers = apiRequest.getHeaders();
            if (headers != null) {
                for (Map.Entry entry : headers.entrySet()) {
                    if (entry.getValue() == null || ((List)entry.getValue()).isEmpty()) continue;
                    builder.header((String)entry.getKey(), (String)((List)entry.getValue()).get(0));
                }
            }
            builder.header(apiHeader.getFromHeader(), apiParameter.getInternalId());
            if (!secret.isEmpty()) {
                String digest = FrameworkUtil.getOrDefault(apiSource.getDigest(), "").trim().toUpperCase();
                if (digest.isEmpty()) {
                    digest = apiService.getDefaultDigest();
                }
                String timestamp = "" + TimeUtil.currentEpochMillis();
                String signature = FrameworkUtil.digest(digest, secret + timestamp);
                builder.header(apiHeader.getSignatureHeader(), signature).header(apiHeader.getTimestampHeader(), timestamp);
            }
            Request request = builder.build();
            Call call = client.newCall(request);
            response = call.execute();
            ApiAccess apiAccess = ProcessorHelper.getApiAccess(apiService.getDataMapper(), response);
            ProcessorHelper.close(response);
            return apiAccess;
        }
        catch (Exception e) {
            log.error("ProcessorHelper", (Throwable)e);
            ApiAccess apiAccess = (ApiAccess)ProcessorHelper.throwIfTrue(apiProcessor, "89", true);
            return apiAccess;
        }
        finally {
            ProcessorHelper.close(response);
        }
    }

    static boolean isAgentValid(ApiParameter apiParameter, ApiAccess apiAccess) {
        ApiRequest apiRequest = FrameworkUtil.getOrDefault(apiParameter.getApiRequest(), new ApiRequest());
        String userAgent = (String)apiAccess.getAttribute(String.class, "agent", (Object)"");
        return !userAgent.isEmpty() && userAgent.equals(apiRequest.getUserAgent());
    }

    static boolean isHostValid(ApiParameter apiParameter, ApiAccess apiAccess) {
        ApiRequest apiRequest = FrameworkUtil.getOrDefault(apiParameter.getApiRequest(), new ApiRequest());
        String remoteHost = (String)apiAccess.getAttribute(String.class, "host", (Object)"");
        return !remoteHost.isEmpty() && remoteHost.equals(apiRequest.getRemoteHost());
    }

    static ApiAccess setUserAgent(ApiParameter apiParameter, ApiAccess apiAccess) {
        ApiRequest apiRequest = FrameworkUtil.getOrDefault(apiParameter.getApiRequest(), new ApiRequest());
        String userAgent = apiRequest.getUserAgent() != null ? apiRequest.getUserAgent() : "";
        Assert.hasLength((String)userAgent, (String)"UserAgent is required");
        apiAccess.setAttribute("agent", userAgent);
        return apiAccess;
    }

    static ApiAccess setRemoteHost(ApiParameter apiParameter, ApiAccess apiAccess) {
        ApiRequest apiRequest = FrameworkUtil.getOrDefault(apiParameter.getApiRequest(), new ApiRequest());
        String remoteHost = apiRequest.getRemoteHost() != null ? apiRequest.getRemoteHost() : "";
        Assert.hasLength((String)remoteHost, (String)"RemoteHost is required");
        apiAccess.setAttribute("host", remoteHost);
        return apiAccess;
    }

    static final class TypeRef {
        static final TypeReference<List<Message>> ERROR_LIST = new TypeReference<List<Message>>(){};

        private TypeRef() {
        }
    }
}

