/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.api.processor;

import java.util.UUID;
import net.ideahut.springboot.api.ApiAccess;
import net.ideahut.springboot.api.ApiAuth;
import net.ideahut.springboot.api.ApiParameter;
import net.ideahut.springboot.api.ApiProcessor;
import net.ideahut.springboot.api.ApiRequest;
import net.ideahut.springboot.api.ApiService;
import net.ideahut.springboot.api.ApiSource;
import net.ideahut.springboot.api.processor.ProcessorHelper;

public class StandardAuthApiProcessor
extends ApiProcessor {
    public static final String API_TYPE = "A00";

    public StandardAuthApiProcessor(ApiService apiService) {
        super(apiService);
    }

    @Override
    public String getApiType() {
        return API_TYPE;
    }

    @Override
    public ApiParameter getApiParameter(ApiRequest apiRequest) throws Exception {
        ApiParameter apiParameter = super.getApiParameterFromAuthorization(apiRequest);
        super.throwIfTrue(this, "00", apiParameter != null && !this.getApiType().equals(apiParameter.getApiType()));
        return apiParameter;
    }

    @Override
    public ApiAccess getApiAccess(ApiSource apiSource, ApiParameter apiParameter) throws Exception {
        return ProcessorHelper.getRemoteApiAccess(this, this.apiService, apiSource, apiParameter);
    }

    @Override
    public boolean isValidAccess(ApiSource apiSource, ApiParameter apiParameter, ApiAccess apiAccess) {
        return true;
    }

    @Override
    public ApiAuth createApiAuth(ApiSource apiSource, ApiParameter apiParameter, ApiAccess apiAccess) throws Exception {
        String digest = apiSource != null ? apiSource.getDigest() : null;
        String scheme = apiParameter.getScheme() != null ? apiParameter.getScheme().trim() : "";
        apiParameter.setContent(UUID.randomUUID().toString());
        String apiKey = super.createApiKey(apiParameter, digest);
        apiParameter.setApiKey(apiKey);
        apiAccess.setApiKey(apiKey);
        String token = super.createToken(apiParameter);
        Object authorization = "";
        if (!scheme.isEmpty()) {
            authorization = (String)authorization + scheme + " ";
        }
        authorization = (String)authorization + token;
        return new ApiAuth().setApiKey(apiKey).setToken(token).setScheme(scheme).setApiAccess(apiAccess).setHeader("Authorization", (String)authorization);
    }
}

