/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.api.processor;

import java.util.UUID;
import net.ideahut.springboot.api.ApiAccess;
import net.ideahut.springboot.api.ApiAuth;
import net.ideahut.springboot.api.ApiHeader;
import net.ideahut.springboot.api.ApiParameter;
import net.ideahut.springboot.api.ApiProcessor;
import net.ideahut.springboot.api.ApiRequest;
import net.ideahut.springboot.api.ApiService;
import net.ideahut.springboot.api.ApiSource;
import net.ideahut.springboot.api.processor.ProcessorHelper;

public class StandardHeaderApiProcessor
extends ApiProcessor {
    public static final String API_TYPE = "A01";

    public StandardHeaderApiProcessor(ApiService apiService) {
        super(apiService);
    }

    @Override
    public String getApiType() {
        return API_TYPE;
    }

    @Override
    public ApiParameter getApiParameter(ApiRequest apiRequest) throws Exception {
        ApiParameter apiParameter = super.getApiParameterFromTokenHeader(apiRequest);
        super.throwIfTrue(this, "00", apiParameter != null && !this.getApiType().equals(apiParameter.getApiType()));
        return apiParameter;
    }

    @Override
    public ApiAccess getApiAccess(ApiSource apiSource, ApiParameter apiParameter) throws Exception {
        return ProcessorHelper.getRemoteApiAccess(this, this.apiService, apiSource, apiParameter);
    }

    @Override
    public boolean isValidAccess(ApiSource apiSource, ApiParameter apiParameter, ApiAccess apiAccess) {
        return true;
    }

    @Override
    public ApiAuth createApiAuth(ApiSource apiSource, ApiParameter apiParameter, ApiAccess apiAccess) throws Exception {
        ApiHeader apiHeader = this.apiService.getApiHeader();
        String tokenHeader = apiHeader.getTokenHeader() != null ? apiHeader.getTokenHeader() : "";
        String digest = apiSource != null ? apiSource.getDigest() : null;
        apiParameter.setContent(UUID.randomUUID().toString());
        String apiKey = super.createApiKey(apiParameter, digest);
        apiParameter.setApiKey(apiKey);
        apiAccess.setApiKey(apiKey);
        String token = super.createToken(apiParameter);
        return new ApiAuth().setApiKey(apiKey).setToken(token).setScheme(null).setApiAccess(apiAccess).setHeader(tokenHeader, token);
    }
}

