/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.api.processor;

import java.util.UUID;
import javax.crypto.SecretKey;
import net.ideahut.springboot.api.ApiAccess;
import net.ideahut.springboot.api.ApiAuth;
import net.ideahut.springboot.api.ApiParameter;
import net.ideahut.springboot.api.ApiProcessor;
import net.ideahut.springboot.api.ApiRequest;
import net.ideahut.springboot.api.ApiService;
import net.ideahut.springboot.api.ApiSource;
import net.ideahut.springboot.api.ApiTokenService;
import net.ideahut.springboot.api.processor.ProcessorHelper;
import net.ideahut.springboot.object.StringMap;
import net.ideahut.springboot.util.FrameworkUtil;

public class StandardJwtApiProcessor
extends ApiProcessor {
    public static final String API_TYPE = "A02";
    private static final String SCHEME = "Bearer";

    public StandardJwtApiProcessor(ApiService apiService) {
        super(apiService);
    }

    @Override
    public String getApiType() {
        return API_TYPE;
    }

    @Override
    public ApiParameter getApiParameter(ApiRequest apiRequest) throws Exception {
        ApiParameter apiParameter = super.getApiParameterFromAuthorization(apiRequest);
        if (apiParameter != null) {
            super.throwIfTrue(this, "00", !this.getApiType().equals(apiParameter.getApiType()));
            String scheme = apiParameter.getScheme() != null ? apiParameter.getScheme() : "";
            super.throwIfTrue(this, "01", !SCHEME.equals(scheme));
        }
        return apiParameter;
    }

    @Override
    public ApiAccess getApiAccess(ApiSource apiSource, ApiParameter apiParameter) throws Exception {
        ApiAccess caccess;
        String content = apiParameter.getContent() != null ? apiParameter.getContent() : "";
        super.throwIfTrue(this, "02", content.isEmpty());
        StringMap config = FrameworkUtil.getOrDefault(apiSource.getConfig(), new StringMap());
        String jwtSecret = (String)config.getOrDefault((Object)"PROCESSOR_JWT_SECRET", (Object)"");
        super.throwIfTrue(this, "03", jwtSecret.isEmpty());
        String jwtDigest = ((String)config.getOrDefault((Object)"PROCESSOR_JWT_DIGEST", (Object)"")).trim();
        ApiTokenService apiTokenService = this.apiService.getApiTokenService();
        SecretKey secretKey = apiTokenService.getJwtSecretKey(jwtSecret, jwtDigest);
        ApiAccess apiAccess = apiTokenService.getJwtPayload(ApiAccess.class, secretKey, content);
        StringMap serviceRole = apiAccess.getServiceRole();
        String apiRole = (String)serviceRole.get((Object)apiParameter.getInternalId());
        apiAccess.setApiRole(apiRole);
        apiAccess.setServiceRole(null);
        boolean isCheck = (Boolean)apiAccess.getAttribute(Boolean.TYPE, "check", (Object)false);
        if (isCheck && ((caccess = ProcessorHelper.getRemoteApiAccess(this, this.apiService, apiSource, apiParameter)) == null || !caccess.getApiKey().equals(apiAccess.getApiKey()))) {
            apiAccess.setValidUntil(Long.valueOf(0L));
        }
        return apiAccess;
    }

    @Override
    public boolean isValidAccess(ApiSource apiSource, ApiParameter apiParameter, ApiAccess apiAccess) {
        return true;
    }

    @Override
    public ApiAuth createApiAuth(ApiSource apiSource, ApiParameter apiParameter, ApiAccess apiAccess) throws Exception {
        apiSource = FrameworkUtil.getOrDefault(apiSource, new ApiSource());
        String apiRole = apiAccess.getApiRole() != null ? apiAccess.getApiRole() : "";
        StringMap serviceRole = FrameworkUtil.getOrDefault(apiAccess.getServiceRole(), new StringMap());
        super.throwIfTrue(this, "04", apiRole.isEmpty() && serviceRole.isEmpty());
        apiParameter.setContent(UUID.randomUUID().toString());
        String apiKey = super.createApiKey(apiParameter, apiSource.getDigest());
        apiParameter.setApiKey(apiKey);
        apiAccess.setApiKey(apiKey);
        ApiTokenService apiTokenService = this.apiService.getApiTokenService();
        String jwtToken = apiTokenService.createJwtProcessorToken(apiSource, apiAccess);
        apiParameter.setContent(jwtToken);
        String token = super.createToken(apiParameter);
        String authorization = "Bearer " + token;
        return new ApiAuth().setApiKey(apiKey).setToken(token).setScheme(SCHEME).setApiAccess(apiAccess).setHeader("Authorization", authorization);
    }
}

