/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.audit;

import com.fasterxml.jackson.databind.JsonNode;
import jakarta.persistence.EnumType;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.ideahut.springboot.audit.AuditAccessible;
import net.ideahut.springboot.audit.AuditObject;
import net.ideahut.springboot.audit.AuditRequest;
import net.ideahut.springboot.audit.DatabaseAuditProperties;
import net.ideahut.springboot.converter.Converter;
import net.ideahut.springboot.crud.Condition;
import net.ideahut.springboot.crud.Filter;
import net.ideahut.springboot.crud.Logical;
import net.ideahut.springboot.entity.EntityAudit;
import net.ideahut.springboot.entity.EntityIdType;
import net.ideahut.springboot.entity.EntityInfo;
import net.ideahut.springboot.entity.EntityIntegrator;
import net.ideahut.springboot.entity.EntityNative;
import net.ideahut.springboot.entity.EntitySoftDelete;
import net.ideahut.springboot.entity.FieldInfo;
import net.ideahut.springboot.entity.IdInfo;
import net.ideahut.springboot.entity.TrxManagerInfo;
import net.ideahut.springboot.init.InitMapper;
import net.ideahut.springboot.mapper.DataMapper;
import net.ideahut.springboot.mapper.DataMapperImpl;
import net.ideahut.springboot.object.Page;
import org.hibernate.MappingException;
import org.hibernate.boot.model.naming.Identifier;
import org.hibernate.boot.model.relational.Database;
import org.hibernate.boot.model.relational.Namespace;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.SimpleValue;
import org.hibernate.mapping.Table;
import org.hibernate.mapping.Value;
import org.hibernate.type.BasicType;
import org.hibernate.type.Type;
import org.hibernate.type.descriptor.java.IntegerJavaType;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.java.LongJavaType;
import org.hibernate.type.descriptor.java.PrimitiveByteArrayJavaType;
import org.hibernate.type.descriptor.java.StringJavaType;
import org.hibernate.type.descriptor.jdbc.BigIntJdbcType;
import org.hibernate.type.descriptor.jdbc.BinaryJdbcType;
import org.hibernate.type.descriptor.jdbc.IntegerJdbcType;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.LongVarcharJdbcType;
import org.hibernate.type.descriptor.jdbc.VarcharJdbcType;
import org.hibernate.type.internal.BasicTypeImpl;
import org.springframework.util.Assert;

final class AuditHelper {
    private static final Field typeField;
    static final String CONTENT = "content";
    static final BasicType<String> STRING_TYPE;
    static final BasicType<Integer> INTEGER_TYPE;
    static final BasicType<Long> LONG_TYPE;
    static final BasicType<String> TEXT_TYPE;
    static final BasicType<byte[]> BYTES_TYPE;

    private AuditHelper() {
    }

    static Column createColumn(MetadataBuildingContext metadataBuildingContext, Table table, Class<? extends Serializable> otype, BasicType<?> htype, String name, Integer length, boolean nullable, Integer scale, boolean unique, Integer precision) throws Exception {
        AuditSimpleValue value = new AuditSimpleValue(metadataBuildingContext, table);
        value.setTypeName(otype.getName());
        typeField.set((Object)value, htype);
        Column column = new Column();
        column.setName(name);
        if (length != null && length > 0) {
            column.setLength(length);
        }
        if (scale != null && scale > 0) {
            column.setScale(scale);
        }
        if (precision != null && precision > 0) {
            column.setPrecision(precision);
        }
        column.setValue((Value)value);
        column.setTypeIndex(0);
        column.setNullable(nullable);
        column.setUnique(unique);
        return column;
    }

    static Column createColumn(MetadataBuildingContext metadataBuildingContext, Table table, Class<? extends Serializable> otype, BasicType<?> htype, String name) throws Exception {
        return AuditHelper.createColumn(metadataBuildingContext, table, otype, htype, name, 255, false, 2, false, 19);
    }

    static Column createColumn(MetadataBuildingContext metadataBuildingContext, Table table, Class<? extends Serializable> otype, BasicType<?> htype, String name, Integer length, boolean nullable, boolean unique) throws Exception {
        return AuditHelper.createColumn(metadataBuildingContext, table, otype, htype, name, length, nullable, 2, unique, 19);
    }

    static Column createColumn(MetadataBuildingContext metadataBuildingContext, Table table, Class<? extends Serializable> otype, BasicType<?> htype, String name, Integer length, boolean nullable) throws Exception {
        return AuditHelper.createColumn(metadataBuildingContext, table, otype, htype, name, length, nullable, 2, false, 19);
    }

    static Column createColumn(MetadataBuildingContext metadataBuildingContext, Table table, Class<? extends Serializable> otype, BasicType<?> htype, String name, boolean nullable) throws Exception {
        return AuditHelper.createColumn(metadataBuildingContext, table, otype, htype, name, 255, nullable, 2, false, 19);
    }

    static Table copyTable(EntityIntegrator integrator, Table table, ATable ttable, AEnable ttenable) {
        Database database = integrator.getMetadata().getDatabase();
        Namespace namespace = database.getDefaultNamespace();
        Namespace.Name name = namespace.getName();
        Identifier schema = name != null ? name.getSchema() : null;
        Identifier catalog = name != null ? name.getCatalog() : null;
        Table newTable = new Table("orm");
        newTable.setName(ttable.getPrefix() + table.getName() + ttable.getSuffix());
        if (schema != null) {
            newTable.setSchema(schema.render());
        }
        if (catalog != null) {
            newTable.setCatalog(catalog.render());
        }
        newTable.setComment(table.getComment());
        newTable.setAbstract(table.isAbstract());
        newTable.setQuoted(table.isQuoted());
        if (ttenable.isRowid()) {
            newTable.setRowId(table.getRowId());
        } else {
            newTable.setRowId(null);
        }
        return newTable;
    }

    static AuditRequest getAuditRequest(byte[] data) {
        try {
            JsonNode jorders;
            JsonNode filters;
            AuditRequest request = new AuditRequest();
            JsonNode node = Mapper.nuller.read(data, JsonNode.class);
            String manager = AuditHelper.getStringValue(node, "manager", "");
            request.setManager(manager);
            String entity = AuditHelper.getStringValue(node, "entity", "");
            request.setEntity(entity);
            String type = AuditHelper.getStringValue(node, "type", "");
            request.setType(type);
            JsonNode jpage = AuditHelper.getNodeValue(node, "page");
            if (jpage != null && jpage.isObject()) {
                Page page = Mapper.nuller.convert((Object)jpage, Page.class);
                request.setPage(page);
            }
            if ((filters = AuditHelper.getNodeValue(node, "filters")) != null && filters.isArray()) {
                request.setFilters(AuditHelper.nodeToFilter(filters));
            }
            if ((jorders = AuditHelper.getNodeValue(node, "orders")) != null && jorders.isArray()) {
                ArrayList<String> orders = new ArrayList<String>();
                for (JsonNode jorder : jorders) {
                    orders.add(jorder.asText());
                }
                request.setOrders(orders);
            }
            return request;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static String getStringValue(JsonNode node, String key, String defaultValue) {
        if (!node.has(key)) {
            return defaultValue;
        }
        JsonNode value = node.get(key);
        return !value.isNull() ? value.asText() : defaultValue;
    }

    static JsonNode getNodeValue(JsonNode node, String key) {
        if (!node.has(key)) {
            return null;
        }
        JsonNode value = node.get(key);
        return !value.isNull() ? value : null;
    }

    static List<Filter> nodeToFilter(JsonNode node) {
        Assert.isTrue((boolean)node.isArray(), (String)("Invalid filters: " + Mapper.nonull.writeAsString(node, 1)));
        ArrayList<Filter> filters = new ArrayList<Filter>();
        for (JsonNode item : node) {
            Filter filter = new Filter();
            JsonNode children = AuditHelper.getNodeValue(node, "filters");
            if (children != null) {
                Assert.isTrue((boolean)children.isArray(), (String)("Invalid filter child: " + Mapper.nonull.writeAsString(children, 1)));
                List<Filter> list = AuditHelper.nodeToFilter(children);
                filter.setFilters(list);
            }
            String field = AuditHelper.getStringValue(item, "field", "");
            Assert.hasLength((String)field, (String)"Filter field is required");
            filter.setField(field);
            String str = AuditHelper.getStringValue(item, "condition", "");
            Condition condition = Condition.of((String)str, (Condition)Condition.EQUAL);
            filter.setCondition(condition);
            str = AuditHelper.getStringValue(item, "logical", "");
            Logical logical = Logical.of((String)str, (Logical)Logical.AND);
            filter.setLogical(logical);
            String value = AuditHelper.getStringValue(item, "value", null);
            if (value != null) {
                filter.setValues(Arrays.asList(value));
            } else {
                JsonNode values = AuditHelper.getNodeValue(item, "values");
                if (values != null && values.isArray()) {
                    filter.setValues(new ArrayList());
                    for (JsonNode jval : values) {
                        filter.getValues().add(jval.asText());
                    }
                }
            }
            filters.add(filter);
        }
        return filters;
    }

    static Map<String, AuditAccessible> getAccessibles(Map<String, TrxManagerAccessible> trxManagerAccessibles) {
        TreeMap<String, AuditAccessible> accessibles = new TreeMap<String, AuditAccessible>();
        for (Map.Entry<String, TrxManagerAccessible> entryTrxManager : trxManagerAccessibles.entrySet()) {
            TrxManagerAccessible trxManagerAccessible = entryTrxManager.getValue();
            AuditAccessible accessible = new AuditAccessible();
            accessible.setIdentifier(trxManagerAccessible.getAuditIdentifier());
            accessible.setTrxManagerName(trxManagerAccessible.getTrxManagerInfo().getName());
            accessible.setMembers(new LinkedHashMap());
            Map<Class<?>, TableAccessible> tableAccessibles = trxManagerAccessible.getTableAccessibles();
            for (Map.Entry<Class<?>, TableAccessible> entryTable : tableAccessibles.entrySet()) {
                AuditAccessible.AuditMember member = new AuditAccessible.AuditMember();
                member.setType(entryTable.getKey());
                EntityInfo entityInfo = entryTable.getValue().getEntityInfo();
                if (entityInfo != null) {
                    AuditAccessible.AuditField field;
                    AuditAccessible.AuditField field2;
                    member.setFields(new ArrayList());
                    IdInfo idInfo = entityInfo.getIdInfo();
                    HashSet<String> fnames = new HashSet<String>(entityInfo.getFieldInfoNames());
                    fnames.removeAll(idInfo.getFields());
                    if (EntitySoftDelete.class.isAssignableFrom(entityInfo.getEntityClass())) {
                        fnames.remove("deletedOn");
                        member.setIsSoftDelete(Boolean.valueOf(true));
                    }
                    if (EntityAudit.class.isAssignableFrom(entityInfo.getEntityClass())) {
                        fnames.removeAll(EntityAudit.Name.Field.list());
                        member.setIsAudit(Boolean.valueOf(true));
                    }
                    if (EntityIdType.EMBEDDED == idInfo.getIdType()) {
                        String fid = idInfo.getFields().iterator().next();
                        EntityInfo embedded = idInfo.getEmbeddedEntityInfo();
                        for (String fname : embedded.getFieldInfoNames()) {
                            AuditAccessible.AuditField field3 = AuditHelper.getAuditField(embedded, fname);
                            field3.setName((String)fid + "." + field3.getName());
                            member.getFields().add(field3);
                        }
                    } else if (EntityIdType.COMPOSITE == idInfo.getIdType()) {
                        for (String fname : idInfo.getFields()) {
                            field2 = AuditHelper.getAuditField(entityInfo, fname);
                            member.getFields().add(field2);
                        }
                    } else if (EntityIdType.STANDARD == idInfo.getIdType()) {
                        field = AuditHelper.getAuditField(entityInfo, idInfo.getFields().iterator().next());
                        member.getFields().add(field);
                    }
                    for (String fname : fnames) {
                        field2 = AuditHelper.getAuditField(entityInfo, fname);
                        member.getFields().add(field2);
                    }
                    if (EntitySoftDelete.class.isAssignableFrom(entityInfo.getEntityClass())) {
                        field = AuditHelper.getAuditField(entityInfo, "deletedOn");
                        member.getFields().add(field);
                    }
                    if (EntityAudit.class.isAssignableFrom(entityInfo.getEntityClass())) {
                        for (String fname : EntityAudit.Name.Field.list()) {
                            field2 = AuditHelper.getAuditField(entityInfo, fname);
                            member.getFields().add(field2);
                        }
                    }
                }
                accessible.getMembers().put(member.getType(), member);
            }
            accessibles.put(accessible.getTrxManagerName(), accessible);
        }
        return accessibles;
    }

    private static AuditAccessible.AuditField getAuditField(EntityInfo einfo, String name) {
        FieldInfo finfo = einfo.getFieldInfo(name);
        AuditAccessible.AuditField field = new AuditAccessible.AuditField();
        field.setFormat(finfo.getFormat());
        field.setLength(finfo.getLength());
        field.setLabel(finfo.getName().substring(0, 1).toUpperCase() + finfo.getName().substring(1));
        field.setLob(Boolean.valueOf(finfo.isLob()));
        field.setName(finfo.getName());
        field.setNullable(finfo.getNullable());
        field.setPrecision(finfo.getPrecision());
        field.setScale(finfo.getScale());
        field.setType(finfo.getType());
        return field;
    }

    static {
        Field typeField0 = null;
        try {
            typeField0 = SimpleValue.class.getDeclaredField("type");
            typeField0.setAccessible(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        typeField = typeField0;
        STRING_TYPE = new BasicTypeImpl((JavaType)StringJavaType.INSTANCE, (JdbcType)VarcharJdbcType.INSTANCE);
        INTEGER_TYPE = new BasicTypeImpl((JavaType)IntegerJavaType.INSTANCE, (JdbcType)IntegerJdbcType.INSTANCE);
        LONG_TYPE = new BasicTypeImpl((JavaType)LongJavaType.INSTANCE, (JdbcType)BigIntJdbcType.INSTANCE);
        TEXT_TYPE = new BasicTypeImpl((JavaType)StringJavaType.INSTANCE, (JdbcType)LongVarcharJdbcType.INSTANCE);
        BYTES_TYPE = new BasicTypeImpl((JavaType)PrimitiveByteArrayJavaType.INSTANCE, (JdbcType)BinaryJdbcType.INSTANCE);
    }

    private static final class AuditSimpleValue
    extends SimpleValue {
        private MetadataBuildingContext buildingContext;
        private Table table;
        private SimpleValue original;

        public AuditSimpleValue(MetadataBuildingContext buildingContext) {
            super(buildingContext);
            this.buildingContext = buildingContext;
        }

        public AuditSimpleValue(MetadataBuildingContext buildingContext, Table table) {
            super(buildingContext, table);
            this.buildingContext = buildingContext;
            this.table = table;
        }

        public AuditSimpleValue(SimpleValue original) {
            super(original);
            this.original = original;
        }

        public Type getType() throws MappingException {
            try {
                return (Type)typeField.get((Object)this);
            }
            catch (Exception e) {
                throw new MappingException((Throwable)e);
            }
        }

        public Value copy() {
            AuditSimpleValue asv = null;
            asv = this.buildingContext != null ? (this.table != null ? new AuditSimpleValue(this.buildingContext, this.table) : new AuditSimpleValue(this.buildingContext)) : new AuditSimpleValue(this.original);
            return asv;
        }
    }

    static class ATable {
        private final String prefix;
        private final String suffix;

        ATable(DatabaseAuditProperties properties) {
            String suffix0;
            DatabaseAuditProperties.Table table = properties.getTable() != null ? properties.getTable() : new DatabaseAuditProperties.Table();
            String prefix0 = table.getPrefix();
            String string = prefix0 = prefix0 != null ? prefix0.trim() : "";
            if (prefix0.isEmpty()) {
                prefix0 = "audit_";
            }
            suffix0 = (suffix0 = table.getSuffix()) != null ? suffix0.trim() : "";
            this.prefix = prefix0;
            this.suffix = suffix0;
        }

        public String getPrefix() {
            return this.prefix;
        }

        public String getSuffix() {
            return this.suffix;
        }
    }

    static class AEnable {
        private final boolean audit;
        private final boolean rowid;
        private final boolean index;
        private final boolean any;

        AEnable(DatabaseAuditProperties properties) {
            DatabaseAuditProperties.Enable enable = properties.getEnable() != null ? properties.getEnable() : new DatabaseAuditProperties.Enable();
            this.audit = !Boolean.FALSE.equals(enable.getAudit());
            this.rowid = !Boolean.FALSE.equals(enable.getRowid());
            this.index = !Boolean.FALSE.equals(enable.getIndex());
            this.any = Boolean.TRUE.equals(enable.getAny());
        }

        public boolean isAudit() {
            return this.audit;
        }

        public boolean isRowid() {
            return this.rowid;
        }

        public boolean isIndex() {
            return this.index;
        }

        public boolean isAny() {
            return this.any;
        }
    }

    static class Mapper {
        static final DataMapper nuller = new DataMapperImpl(true);
        static final DataMapper nonull = new DataMapperImpl(false);

        Mapper() {
        }

        static void initialize(Map<String, TrxManagerAccessible> trxManagerAccessibles) throws Exception {
            Mapper.loadDefault();
            Mapper.loadObject(new AuditObject());
            Mapper.loadObject(new AuditRequest());
            Mapper.loadObject(new Where());
            Mapper.loadObject(new Sql());
            if (trxManagerAccessibles != null) {
                for (TrxManagerAccessible trxManagerAccessible : trxManagerAccessibles.values()) {
                    Map<Class<?>, TableAccessible> tableAccessibles = trxManagerAccessible.getTableAccessibles();
                    if (tableAccessibles == null) continue;
                    for (TableAccessible tableAccessible : tableAccessibles.values()) {
                        EntityInfo entityInfo = tableAccessible.getEntityInfo();
                        if (entityInfo == null) continue;
                        Object object = entityInfo.createEntity();
                        Mapper.loadObject(object);
                    }
                }
            }
        }

        private static void loadDefault() throws Exception {
            InitMapper.loadDefault(nonull);
            InitMapper.loadDefault(nuller);
        }

        private static void loadObject(Object object) throws Exception {
            InitMapper.loadObject(nonull, object);
            InitMapper.loadObject(nuller, object);
        }
    }

    static final class Key {
        public static final String MANAGER = "manager";
        public static final String ENTITY = "entity";
        public static final String TYPE = "type";
        public static final String PAGE = "page";
        public static final String FILTERS = "filters";
        public static final String ORDERS = "orders";
        public static final String FIELD = "field";
        public static final String CONDITION = "condition";
        public static final String LOGICAL = "logical";
        public static final String VALUE = "value";
        public static final String VALUES = "values";

        private Key() {
        }
    }

    static class TrxManagerAccessible {
        private String auditIdentifier;
        private TrxManagerInfo trxManagerInfo;
        private EntityIntegrator auditIntegrator;
        private Map<Class<?>, TableAccessible> tableAccessibles;

        TrxManagerAccessible() {
        }

        public void setAuditIdentifier(String auditIdentifier) {
            this.auditIdentifier = auditIdentifier;
        }

        public void setTrxManagerInfo(TrxManagerInfo trxManagerInfo) {
            this.trxManagerInfo = trxManagerInfo;
        }

        public void setAuditIntegrator(EntityIntegrator auditIntegrator) {
            this.auditIntegrator = auditIntegrator;
        }

        public void setTableAccessibles(Map<Class<?>, TableAccessible> tableAccessibles) {
            this.tableAccessibles = tableAccessibles;
        }

        public String getAuditIdentifier() {
            return this.auditIdentifier;
        }

        public TrxManagerInfo getTrxManagerInfo() {
            return this.trxManagerInfo;
        }

        public EntityIntegrator getAuditIntegrator() {
            return this.auditIntegrator;
        }

        public Map<Class<?>, TableAccessible> getTableAccessibles() {
            return this.tableAccessibles;
        }
    }

    static class TableAccessible {
        private EntityIntegrator auditIntegrator;
        private Table table;
        private EntityInfo entityInfo;
        private Map<String, ColumnAccessible> columnAccessibles;
        private EntityNative.Select select;
        private String sqlInsert;
        private String sqlSelect;

        TableAccessible() {
        }

        public void setAuditIntegrator(EntityIntegrator auditIntegrator) {
            this.auditIntegrator = auditIntegrator;
        }

        public void setTable(Table table) {
            this.table = table;
        }

        public void setEntityInfo(EntityInfo entityInfo) {
            this.entityInfo = entityInfo;
        }

        public void setColumnAccessibles(Map<String, ColumnAccessible> columnAccessibles) {
            this.columnAccessibles = columnAccessibles;
        }

        public void setSelect(EntityNative.Select select) {
            this.select = select;
        }

        public void setSqlInsert(String sqlInsert) {
            this.sqlInsert = sqlInsert;
        }

        public void setSqlSelect(String sqlSelect) {
            this.sqlSelect = sqlSelect;
        }

        public EntityIntegrator getAuditIntegrator() {
            return this.auditIntegrator;
        }

        public Table getTable() {
            return this.table;
        }

        public EntityInfo getEntityInfo() {
            return this.entityInfo;
        }

        public Map<String, ColumnAccessible> getColumnAccessibles() {
            return this.columnAccessibles;
        }

        public EntityNative.Select getSelect() {
            return this.select;
        }

        public String getSqlInsert() {
            return this.sqlInsert;
        }

        public String getSqlSelect() {
            return this.sqlSelect;
        }
    }

    static class Where {
        private String query = "";
        private List<EntityNative.Parameter> parameters = new ArrayList<EntityNative.Parameter>();

        Where() {
        }

        public void setQuery(String query) {
            this.query = query;
        }

        public void setParameters(List<EntityNative.Parameter> parameters) {
            this.parameters = parameters;
        }

        public String getQuery() {
            return this.query;
        }

        public List<EntityNative.Parameter> getParameters() {
            return this.parameters;
        }
    }

    static class Sql {
        private String insert;
        private String select;

        Sql() {
        }

        public void setInsert(String insert) {
            this.insert = insert;
        }

        public void setSelect(String select) {
            this.select = select;
        }

        public String getInsert() {
            return this.insert;
        }

        public String getSelect() {
            return this.select;
        }
    }

    static class ColumnAccessible {
        private final Column column;
        private final Converter converter;

        private ColumnAccessible(Column column, Converter converter) {
            this.column = column;
            this.converter = converter;
        }

        static ColumnAccessible of(Column column, Converter converter) {
            return new ColumnAccessible(column, converter);
        }

        static ColumnAccessible of(Column column, Class<?> type, String format, EnumType enumType) {
            return new ColumnAccessible(column, Converter.of(type, format, enumType));
        }

        public Column getColumn() {
            return this.column;
        }

        public Converter getConverter() {
            return this.converter;
        }
    }

    static class ALength {
        private final Integer id;
        private final Integer type;
        private final Integer action;
        private final Integer auditor;
        private final Integer info;

        ALength(DatabaseAuditProperties properties) {
            DatabaseAuditProperties.Length length = properties.getLength() != null ? properties.getLength() : new DatabaseAuditProperties.Length();
            this.id = length.getId() != null && length.getId() > 0 ? length.getId() : 128;
            this.type = length.getType() != null && length.getType() > 0 ? length.getType() : 512;
            this.action = length.getAction() != null && length.getAction() > 0 ? length.getAction() : 32;
            this.auditor = length.getAuditor() != null && length.getAuditor() > 0 ? length.getAuditor() : 512;
            this.info = length.getInfo() != null && length.getInfo() > 0 ? length.getInfo() : 2048;
        }

        public Integer getId() {
            return this.id;
        }

        public Integer getType() {
            return this.type;
        }

        public Integer getAction() {
            return this.action;
        }

        public Integer getAuditor() {
            return this.auditor;
        }

        public Integer getInfo() {
            return this.info;
        }
    }

    static class AColumn {
        private final String replica;
        private final String auditor;
        private final String action;
        private final String info;
        private final String entry;

        AColumn(DatabaseAuditProperties properties) {
            DatabaseAuditProperties.Column column = properties.getColumn() != null ? properties.getColumn() : new DatabaseAuditProperties.Column();
            String replica0 = column.getReplica();
            String string = replica0 = replica0 != null ? replica0.trim() : "";
            if (replica0.isEmpty()) {
                replica0 = "replica_";
            }
            this.replica = replica0;
            String auditor0 = column.getActor();
            String string2 = auditor0 = auditor0 != null ? auditor0.trim() : "";
            if (auditor0.isEmpty()) {
                auditor0 = "actor_";
            }
            this.auditor = auditor0;
            String action0 = column.getAction();
            String string3 = action0 = action0 != null ? action0.trim() : "";
            if (action0.isEmpty()) {
                action0 = "action_";
            }
            this.action = action0;
            String info0 = column.getInfo();
            String string4 = info0 = info0 != null ? info0.trim() : "";
            if (info0.isEmpty()) {
                info0 = "info_";
            }
            this.info = info0;
            String entry0 = column.getEntry();
            String string5 = entry0 = entry0 != null ? entry0.trim() : "";
            if (entry0.isEmpty()) {
                entry0 = "entry_";
            }
            this.entry = entry0;
        }

        public boolean isExist(String column) {
            boolean exist = false;
            if (column != null && (column.equals(this.replica) || column.equals(this.auditor) || column.equals(this.action) || column.equals(this.info) || column.equals(this.entry))) {
                exist = true;
            }
            return exist;
        }

        public boolean isEntry(String column) {
            return column != null && column.equals(this.entry);
        }

        public String getReplica() {
            return this.replica;
        }

        public String getAuditor() {
            return this.auditor;
        }

        public String getAction() {
            return this.action;
        }

        public String getInfo() {
            return this.info;
        }

        public String getEntry() {
            return this.entry;
        }
    }

    static class AGenerate {
        private final boolean table;
        private final int maxPrecision;
        private final int maxScale;

        AGenerate(DatabaseAuditProperties properties) {
            DatabaseAuditProperties.Generate generate = properties.getGenerate() != null ? properties.getGenerate() : new DatabaseAuditProperties.Generate();
            Integer maxPrecision0 = generate.getMaxPrecision();
            maxPrecision0 = maxPrecision0 != null && maxPrecision0 > 1 ? maxPrecision0 : 1000;
            Integer maxScale0 = generate.getMaxScale();
            maxScale0 = maxScale0 != null && maxScale0 > 0 ? maxScale0 : 2;
            Boolean table0 = generate.getTable();
            table0 = table0 != null ? table0 : Boolean.TRUE;
            this.maxPrecision = maxPrecision0;
            this.maxScale = maxScale0;
            this.table = table0;
        }

        public boolean isTable() {
            return this.table;
        }

        public int getMaxPrecision() {
            return this.maxPrecision;
        }

        public int getMaxScale() {
            return this.maxScale;
        }
    }

    static final class AName {
        private static final String PREFIX = "audit_";
        private static final String REPLICA = "replica_";
        private static final String ACTOR = "actor_";
        private static final String ACTION = "action_";
        private static final String INFO = "info_";
        private static final String ENTRY = "entry_";

        private AName() {
        }
    }
}

