/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.audit;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import net.ideahut.springboot.audit.AuditHelper;
import net.ideahut.springboot.audit.AuditInfo;
import net.ideahut.springboot.audit.AuditObject;
import net.ideahut.springboot.audit.AuditRequest;
import net.ideahut.springboot.crud.Condition;
import net.ideahut.springboot.crud.Filter;
import net.ideahut.springboot.entity.AttributeOverrides;
import net.ideahut.springboot.entity.EntityHelper;
import net.ideahut.springboot.entity.EntityIdType;
import net.ideahut.springboot.entity.EntityInfo;
import net.ideahut.springboot.entity.EntityIntegrator;
import net.ideahut.springboot.entity.EntityNative;
import net.ideahut.springboot.entity.FieldInfo;
import net.ideahut.springboot.entity.IdInfo;
import net.ideahut.springboot.object.Page;
import net.ideahut.springboot.util.FrameworkUtil;
import net.ideahut.springboot.util.TimeUtil;
import org.hibernate.Session;
import org.hibernate.SharedSessionContract;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Index;
import org.hibernate.mapping.Selectable;
import org.hibernate.mapping.Table;
import org.hibernate.query.Query;
import org.hibernate.type.Type;
import org.springframework.util.Assert;

final class MultiTableHelper {
    private MultiTableHelper() {
    }

    static AuditHelper.TableAccessible createTableAccessible(EntityIntegrator integrator, EntityInfo entityInfo, Table table, AuditHelper.AColumn tcolumn, AuditHelper.ALength tlength) throws Exception {
        LinkedHashMap<String, AuditHelper.ColumnAccessible> columns = new LinkedHashMap<String, AuditHelper.ColumnAccessible>();
        MetadataBuildingContext mbc = integrator.getMetadataBuildingContext();
        Column action = AuditHelper.createColumn(mbc, table, String.class, AuditHelper.STRING_TYPE, tcolumn.getAction(), tlength.getAction(), false);
        table.addColumn(action);
        columns.put("action", AuditHelper.ColumnAccessible.of(action, String.class, null, null));
        Column replica = AuditHelper.createColumn(mbc, table, Integer.class, AuditHelper.INTEGER_TYPE, tcolumn.getReplica(), true);
        table.addColumn(replica);
        columns.put("replica", AuditHelper.ColumnAccessible.of(replica, Integer.class, null, null));
        Column auditor = AuditHelper.createColumn(mbc, table, String.class, AuditHelper.STRING_TYPE, tcolumn.getAuditor(), tlength.getAuditor(), true);
        table.addColumn(auditor);
        columns.put("auditor", AuditHelper.ColumnAccessible.of(auditor, String.class, null, null));
        Column info = AuditHelper.createColumn(mbc, table, String.class, AuditHelper.STRING_TYPE, tcolumn.getInfo(), tlength.getInfo(), true);
        table.addColumn(info);
        columns.put("info", AuditHelper.ColumnAccessible.of(info, String.class, null, null));
        Column entry = AuditHelper.createColumn(mbc, table, Long.class, AuditHelper.LONG_TYPE, tcolumn.getEntry());
        columns.put("entry", AuditHelper.ColumnAccessible.of(entry, Long.class, null, null));
        table.addColumn(entry);
        EntityNative.Select select = EntityNative.Select.of(entityInfo, 0, null);
        String tblName = table.getQualifiedTableName().render();
        StringBuilder qlSelect = new StringBuilder();
        StringBuilder qlInto = new StringBuilder();
        StringBuilder qlValues = new StringBuilder();
        Object entity = entityInfo.createEntity();
        ArrayList<EntityNative.Parameter> parameters = new ArrayList<EntityNative.Parameter>();
        for (String name : entityInfo.getFieldInfoNames()) {
            FieldInfo fieldInfo = entityInfo.getFieldInfo(name);
            EntityNative.appendSelect(fieldInfo, select, qlSelect, "", 0, false);
            EntityNative.appendInsert(fieldInfo, qlInto, qlValues, parameters, entity);
        }
        qlSelect.append(action.getName()).append(",").append(replica.getName()).append(",").append(auditor.getName()).append(",").append(info.getName()).append(",").append(entry.getName()).append(",");
        qlSelect.deleteCharAt(qlSelect.length() - 1);
        qlInto.append(action.getName()).append(",").append(replica.getName()).append(",").append(auditor.getName()).append(",").append(info.getName()).append(",").append(entry.getName()).append(",");
        qlInto.deleteCharAt(qlInto.length() - 1);
        qlValues.append("?,").append("?,").append("?,").append("?,").append("?,");
        qlValues.deleteCharAt(qlValues.length() - 1);
        String sqlInsert = "insert into " + tblName + " (" + qlInto.toString() + ") values (" + qlValues.toString() + ")";
        String sqlSelect = "select " + qlSelect.toString() + " from " + tblName;
        AuditHelper.TableAccessible tableAccessible = new AuditHelper.TableAccessible();
        tableAccessible.setEntityInfo(entityInfo);
        tableAccessible.setTable(table);
        tableAccessible.setColumnAccessibles(columns);
        tableAccessible.setSqlInsert(sqlInsert);
        tableAccessible.setSqlSelect(sqlSelect);
        tableAccessible.setSelect(select);
        return tableAccessible;
    }

    static void createIdIndex(EntityInfo entityInfo, Table table) {
        LinkedHashMap<String, Column> columns = new LinkedHashMap<String, Column>();
        for (Column column : table.getColumns()) {
            columns.put(column.getName(), column);
        }
        IdInfo idInfo = entityInfo.getIdInfo();
        if (EntityIdType.EMBEDDED == idInfo.getIdType()) {
            FieldInfo fieldInfo = entityInfo.getFieldInfo(idInfo.getFields().iterator().next());
            if (fieldInfo.hasAttributeOverrides()) {
                AttributeOverrides attributeOverrides = fieldInfo.getAttributeOverrides();
                for (String name : attributeOverrides.getColums()) {
                    Column column = (Column)columns.get(name);
                    if (column == null) continue;
                    MultiTableHelper.addIndex(table, column);
                }
            } else {
                EntityInfo embeddedInfo = idInfo.getEmbeddedEntityInfo();
                for (String name : embeddedInfo.getFieldInfoNames()) {
                    FieldInfo finfo = embeddedInfo.getFieldInfo(name);
                    Column column = (Column)columns.get(finfo.getColumn().getName());
                    if (column == null) continue;
                    MultiTableHelper.addIndex(table, column);
                }
            }
        } else if (EntityIdType.COMPOSITE == idInfo.getIdType()) {
            for (String name : idInfo.getFields()) {
                FieldInfo fieldInfo = entityInfo.getFieldInfo(name);
                Column column = (Column)columns.get(fieldInfo.getColumn().getName());
                if (column == null) continue;
                MultiTableHelper.addIndex(table, column);
            }
        } else {
            FieldInfo fieldInfo;
            Column column;
            Iterator<String> iterator = idInfo.getFields().iterator();
            if (iterator.hasNext() && (column = (Column)columns.get((fieldInfo = entityInfo.getFieldInfo(iterator.next())).getColumn().getName())) != null) {
                MultiTableHelper.addIndex(table, column);
            }
        }
    }

    private static void addIndex(Table table, Column column) {
        Index index = new Index();
        index.setName("idx_" + table.getName() + "_" + column.getName());
        index.addColumn((Selectable)column);
        index.setTable(table);
        table.addIndex(index);
    }

    static void save(AuditHelper.TableAccessible tableAccessible, AuditInfo auditInfo, String action, Object object) throws Exception {
        Integer replica = auditInfo.getReplica(object.getClass());
        ArrayList<EntityNative.Parameter> parameters = new ArrayList<EntityNative.Parameter>();
        EntityInfo entityInfo = tableAccessible.getEntityInfo();
        for (String name : entityInfo.getFieldInfoNames()) {
            FieldInfo fieldInfo = entityInfo.getFieldInfo(name);
            EntityNative.appendInsert(fieldInfo, new StringBuilder(), new StringBuilder(), parameters, object);
        }
        parameters.add(EntityNative.Parameter.of(AuditHelper.STRING_TYPE, action));
        parameters.add(EntityNative.Parameter.of(AuditHelper.INTEGER_TYPE, replica));
        parameters.add(EntityNative.Parameter.of(AuditHelper.STRING_TYPE, auditInfo.getAuditor()));
        parameters.add(EntityNative.Parameter.of(AuditHelper.STRING_TYPE, auditInfo.getInfo()));
        parameters.add(EntityNative.Parameter.of(AuditHelper.LONG_TYPE, TimeUtil.currentEpochMillis()));
        SessionImplementor session = null;
        try {
            session = tableAccessible.getAuditIntegrator().getSessionFactory().openSession();
            session.beginTransaction();
            EntityNative.queryOf((SharedSessionContract)session, tableAccessible.getSqlInsert(), parameters).executeUpdate();
            EntityHelper.commit((Session)session);
        }
        catch (Exception e) {
            try {
                EntityHelper.rollback((Session)session);
                throw FrameworkUtil.exception(e);
            }
            catch (Throwable throwable) {
                EntityHelper.close(session);
                throw throwable;
            }
        }
        EntityHelper.close((Session)session);
    }

    public static Page list(AuditHelper.TableAccessible tableAccessible, AuditRequest auditRequest) {
        SessionImplementor session;
        List items;
        String orderBy;
        AuditHelper.Where where;
        EntityInfo entityInfo;
        Page page;
        block14: {
            page = Page.empty();
            Page inPage = auditRequest.getPage();
            if (inPage != null) {
                if (inPage.getIndex() != null && inPage.getIndex() > 0) {
                    page.setIndex(inPage.getIndex());
                }
                if (inPage.getSize() != null && inPage.getSize() > 0) {
                    page.setSize(inPage.getSize());
                }
                if (inPage.getCount() != null) {
                    page.setCount(inPage.getCount());
                }
            }
            entityInfo = tableAccessible.getEntityInfo();
            String table = tableAccessible.getTable().getQualifiedTableName().render();
            where = MultiTableHelper.where(tableAccessible, auditRequest);
            orderBy = MultiTableHelper.orderBy(tableAccessible, auditRequest);
            items = null;
            session = null;
            session = tableAccessible.getAuditIntegrator().getSessionFactory().openSession();
            if (!Boolean.TRUE.equals(page.getCount())) break block14;
            Query query = EntityNative.queryOf((SharedSessionContract)session, "select count(1) from " + table + " " + where.getQuery(), where.getParameters());
            Long records = Long.valueOf("" + query.getSingleResult());
            page.setRecords(records);
            if (records != 0L) break block14;
            Page page2 = page;
            EntityHelper.close((Session)session);
            return page2;
        }
        try {
            items = EntityNative.queryOf((SharedSessionContract)session, tableAccessible.getSqlSelect() + " " + where.getQuery() + " " + orderBy, where.getParameters(), (page.getIndex() - 1) * page.getSize(), page.getSize()).getResultList();
        }
        catch (Exception e) {
            try {
                throw FrameworkUtil.exception(e);
            }
            catch (Throwable throwable) {
                EntityHelper.close(session);
                throw throwable;
            }
        }
        EntityHelper.close((Session)session);
        ArrayList<AuditObject> data = new ArrayList<AuditObject>();
        if (items != null) {
            try {
                EntityNative.Select select = tableAccessible.getSelect();
                while (!items.isEmpty()) {
                    Object[] item = (Object[])items.remove(0);
                    AuditObject object = new AuditObject();
                    Object entity = entityInfo.createEntity();
                    object.setContent(entity);
                    int i = 0;
                    for (FieldInfo field : select.getFields()) {
                        i = EntityNative.valueOf(field, item, entity, i);
                    }
                    object.setAction((String)item[i++]);
                    Object v = item[i++];
                    object.setReplica(v != null ? Integer.valueOf("" + v) : null);
                    object.setAuditor((String)item[i++]);
                    object.setInfo((String)item[i++]);
                    v = item[i++];
                    object.setEntry(v != null ? Long.valueOf("" + v) : null);
                    data.add(object);
                }
                page.setData(data);
            }
            catch (Exception e) {
                throw FrameworkUtil.exception(e);
            }
        }
        return page;
    }

    private static AuditHelper.Where where(AuditHelper.TableAccessible tableAccessible, AuditRequest auditRequest) {
        StringBuilder sql = new StringBuilder("where 1=1 ");
        ArrayList<EntityNative.Parameter> params = new ArrayList<EntityNative.Parameter>();
        List filters = auditRequest.getFilters();
        if (filters != null && !filters.isEmpty()) {
            for (Filter filter : filters) {
                MultiTableHelper.filter(tableAccessible, filter, sql, params);
            }
        }
        AuditHelper.Where where = new AuditHelper.Where();
        where.setQuery(sql.toString());
        where.setParameters(params);
        return where;
    }

    private static void filter(AuditHelper.TableAccessible tableAccessible, Filter filter, StringBuilder sql, List<EntityNative.Parameter> parameters) {
        Condition.QueryParameters queryAndParameters;
        List qaParams;
        Assert.hasLength((String)filter.getField(), (String)"Filter field is required");
        EntityNative.ColumnConverter columnConverter = MultiTableHelper.getColumnConverter(tableAccessible, filter.getField());
        Assert.notNull((Object)columnConverter, (String)("Invalid filter field: " + filter.getField()));
        String logic = " " + filter.getLogical().name();
        Condition condition = filter.getCondition();
        ArrayList<Object> lvals = new ArrayList<Object>();
        if (filter.getValues() != null) {
            if (condition.isConvert()) {
                for (Object fvalue : filter.getValues()) {
                    Object value = columnConverter.getConverter().convert(fvalue);
                    lvals.add(value);
                }
            } else {
                for (Object svalue : filter.getValues()) {
                    lvals.add(svalue);
                }
            }
        }
        if ((qaParams = (queryAndParameters = condition.getBuilder().build(true, logic, parameters.size(), columnConverter.getColumn(), lvals.toArray())).getParameters()) != null) {
            Type htype = columnConverter.getConverter() != null ? columnConverter.getConverter().getHibernateType() : null;
            for (Object qap : qaParams) {
                parameters.add(EntityNative.Parameter.of(htype, qap));
            }
        }
        sql.append(queryAndParameters.getQuery());
    }

    private static String orderBy(AuditHelper.TableAccessible tableAccessible, AuditRequest auditRequest) {
        StringBuilder sortBy = new StringBuilder();
        List orders = auditRequest.getOrders();
        if (orders != null) {
            for (String order : orders) {
                boolean isAsc;
                String field = order != null ? order.trim() : "";
                if (field.isEmpty()) continue;
                boolean bl = isAsc = !field.startsWith("-");
                if (!isAsc) {
                    field = field.substring(1);
                }
                EntityNative.ColumnConverter columnConverter = MultiTableHelper.getColumnConverter(tableAccessible, field);
                Assert.notNull((Object)columnConverter, (String)("Invalid order field: " + field));
                sortBy.append(columnConverter.getColumn()).append(" ").append(isAsc ? "asc" : "desc").append(",");
            }
        }
        if (sortBy.length() > 1) {
            sortBy.deleteCharAt(sortBy.length() - 1);
            return "order by " + sortBy.toString();
        }
        return "";
    }

    private static EntityNative.ColumnConverter getColumnConverter(AuditHelper.TableAccessible tableAccessible, String field) {
        EntityNative.ColumnConverter columnConverter = null;
        EntityInfo entityInfo = tableAccessible.getEntityInfo();
        if (field.startsWith("content.") && entityInfo != null) {
            String enfld = field.substring("content".length() + 1);
            columnConverter = entityInfo.getColumnConverter(enfld);
        } else {
            AuditHelper.ColumnAccessible columnAccessible = tableAccessible.getColumnAccessibles().get(field);
            if (columnAccessible != null) {
                columnConverter = EntityNative.ColumnConverter.of(columnAccessible.getColumn().getName(), columnAccessible.getConverter());
            }
        }
        return columnConverter;
    }
}

