/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.audit;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.ideahut.springboot.audit.AuditHelper;
import net.ideahut.springboot.audit.AuditInfo;
import net.ideahut.springboot.audit.AuditObject;
import net.ideahut.springboot.audit.AuditRequest;
import net.ideahut.springboot.crud.Condition;
import net.ideahut.springboot.crud.Filter;
import net.ideahut.springboot.entity.EntityHelper;
import net.ideahut.springboot.entity.EntityIntegrator;
import net.ideahut.springboot.entity.EntityNative;
import net.ideahut.springboot.generator.OdtIdGenerator;
import net.ideahut.springboot.object.Page;
import net.ideahut.springboot.util.FrameworkUtil;
import net.ideahut.springboot.util.TimeUtil;
import org.hibernate.Session;
import org.hibernate.SharedSessionContract;
import org.hibernate.boot.model.naming.Identifier;
import org.hibernate.boot.model.relational.Database;
import org.hibernate.boot.model.relational.Namespace;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.PrimaryKey;
import org.hibernate.mapping.Table;
import org.hibernate.query.Query;
import org.hibernate.type.Type;
import org.springframework.util.Assert;

final class SingleTableHelper {
    private SingleTableHelper() {
    }

    static AuditHelper.TableAccessible createTableAccessible(EntityIntegrator auditIntegrator, String auditIdentifier, AuditHelper.ATable ttable, AuditHelper.ALength tlength) throws Exception {
        Identifier identifier;
        AuditHelper.TableAccessible tableAccessible = new AuditHelper.TableAccessible();
        String tblname = ttable.getPrefix() + auditIdentifier + ttable.getSuffix();
        Database database = auditIntegrator.getMetadata().getDatabase();
        Namespace namespace = database.getDefaultNamespace();
        if (namespace.locateTable(identifier = database.toIdentifier(tblname)) == null) {
            SingleTableHelper.createColumnAccessible(auditIntegrator, tableAccessible, namespace, identifier, tlength);
        } else {
            for (Table table : namespace.getTables()) {
                if (!table.getNameIdentifier().equals((Object)identifier)) continue;
                SingleTableHelper.createColumnAccessible(tableAccessible, table);
                break;
            }
        }
        return tableAccessible;
    }

    private static void createColumnAccessible(EntityIntegrator integrator, AuditHelper.TableAccessible tableAccessible, final Namespace namespace, Identifier identifier, AuditHelper.ALength tlength) throws Exception {
        LinkedHashMap<String, AuditHelper.ColumnAccessible> columns = new LinkedHashMap<String, AuditHelper.ColumnAccessible>();
        Table table = namespace.createTable(identifier, (Function)new Function<Identifier, Table>(){

            @Override
            public Table apply(Identifier physicalTableName) {
                return new Table("orm", namespace, physicalTableName, false);
            }
        });
        MetadataBuildingContext mbc = integrator.getMetadataBuildingContext();
        Column id = AuditHelper.createColumn(mbc, table, String.class, AuditHelper.STRING_TYPE, "id", tlength.getId(), false, true);
        table.addColumn(id);
        columns.put("id", AuditHelper.ColumnAccessible.of(id, String.class, null, null));
        Column type = AuditHelper.createColumn(mbc, table, String.class, AuditHelper.STRING_TYPE, "type", tlength.getType(), false);
        table.addColumn(type);
        columns.put("type", AuditHelper.ColumnAccessible.of(type, String.class, null, null));
        Column action = AuditHelper.createColumn(mbc, table, String.class, AuditHelper.STRING_TYPE, "action", tlength.getAction(), false);
        table.addColumn(action);
        columns.put("action", AuditHelper.ColumnAccessible.of(action, String.class, null, null));
        Column replica = AuditHelper.createColumn(mbc, table, Integer.class, AuditHelper.INTEGER_TYPE, "replica", true);
        table.addColumn(replica);
        columns.put("replica", AuditHelper.ColumnAccessible.of(replica, Integer.class, null, null));
        Column auditor = AuditHelper.createColumn(mbc, table, String.class, AuditHelper.STRING_TYPE, "auditor", tlength.getAuditor(), true);
        table.addColumn(auditor);
        columns.put("auditor", AuditHelper.ColumnAccessible.of(auditor, Integer.class, null, null));
        Column info = AuditHelper.createColumn(mbc, table, String.class, AuditHelper.STRING_TYPE, "info", tlength.getInfo(), true);
        table.addColumn(info);
        columns.put("info", AuditHelper.ColumnAccessible.of(info, String.class, null, null));
        Column content = AuditHelper.createColumn(mbc, table, String.class, AuditHelper.TEXT_TYPE, "content", true);
        table.addColumn(content);
        columns.put("content", AuditHelper.ColumnAccessible.of(content, String.class, null, null));
        Column bytes = AuditHelper.createColumn(mbc, table, byte[].class, AuditHelper.BYTES_TYPE, "bytes", true);
        table.addColumn(bytes);
        columns.put("bytes", AuditHelper.ColumnAccessible.of(bytes, byte[].class, null, null));
        Column entry = AuditHelper.createColumn(mbc, table, Long.class, AuditHelper.LONG_TYPE, "entry", false);
        table.addColumn(entry);
        columns.put("entry", AuditHelper.ColumnAccessible.of(entry, Long.class, null, null));
        PrimaryKey primaryKey = new PrimaryKey(table);
        primaryKey.addColumn(id);
        tableAccessible.setTable(table);
        tableAccessible.setColumnAccessibles(columns);
    }

    private static void createColumnAccessible(AuditHelper.TableAccessible tableAccessible, Table table) {
        Map<String, AuditHelper.ColumnAccessible> columns = tableAccessible.getColumnAccessibles();
        for (Column column : table.getColumns()) {
            columns.put(column.getName(), AuditHelper.ColumnAccessible.of(column, column.getValue().getType().getReturnedClass(), null, null));
        }
        tableAccessible.setTable(table);
    }

    static void save(AuditHelper.TableAccessible tableAccessible, AuditInfo auditInfo, String action, Object object) {
        SessionImplementor session = null;
        try {
            Integer replica = auditInfo.getReplica(object.getClass());
            String id = OdtIdGenerator.createId("AUD");
            session = tableAccessible.getAuditIntegrator().getSessionFactory().openSession();
            session.beginTransaction();
            Query query = EntityNative.queryOf((SharedSessionContract)session, "insert into " + tableAccessible.getTable().getQualifiedTableName().render() + " (id, type, action, replica, auditor, info, entry, content, bytes) values (?,?,?,?,?,?,?,?,?)").setParameter(1, (Object)id, AuditHelper.STRING_TYPE.getBindableJavaType()).setParameter(2, (Object)(auditInfo.getType() != null ? auditInfo.getType() : object.getClass().getName()), AuditHelper.STRING_TYPE.getBindableJavaType()).setParameter(3, (Object)(action != null ? action : ""), AuditHelper.STRING_TYPE.getBindableJavaType()).setParameter(4, (Object)replica, AuditHelper.INTEGER_TYPE.getBindableJavaType()).setParameter(5, (Object)auditInfo.getAuditor(), AuditHelper.STRING_TYPE.getBindableJavaType()).setParameter(6, (Object)auditInfo.getInfo(), AuditHelper.STRING_TYPE.getBindableJavaType()).setParameter(7, (Object)TimeUtil.currentEpochMillis(), AuditHelper.LONG_TYPE.getBindableJavaType());
            if (object instanceof byte[]) {
                query.setParameter(8, null, AuditHelper.TEXT_TYPE.getBindableJavaType()).setParameter(9, (Object)((byte[])object), AuditHelper.BYTES_TYPE.getBindableJavaType());
            } else {
                String content = AuditHelper.Mapper.nonull.writeAsString(object, 1);
                query.setParameter(8, (Object)content, AuditHelper.TEXT_TYPE.getBindableJavaType()).setParameter(9, null, AuditHelper.BYTES_TYPE.getBindableJavaType());
            }
            query.executeUpdate();
            EntityHelper.commit((Session)session);
        }
        catch (Exception e) {
            try {
                EntityHelper.rollback(session);
                throw FrameworkUtil.exception(e);
            }
            catch (Throwable throwable) {
                EntityHelper.close(session);
                throw throwable;
            }
        }
        EntityHelper.close((Session)session);
    }

    public static Page list(AuditHelper.TableAccessible tableAccessible, AuditRequest auditRequest) {
        SessionImplementor session;
        List items;
        String orderBy;
        AuditHelper.Where where;
        String table;
        Page page;
        block11: {
            page = Page.empty();
            Page inPage = auditRequest.getPage();
            if (inPage != null) {
                if (inPage.getIndex() != null && inPage.getIndex() > 0) {
                    page.setIndex(inPage.getIndex());
                }
                if (inPage.getSize() != null && inPage.getSize() > 0) {
                    page.setSize(inPage.getSize());
                }
                if (inPage.getCount() != null) {
                    page.setCount(inPage.getCount());
                }
            }
            table = tableAccessible.getTable().getQualifiedTableName().render();
            where = SingleTableHelper.where(tableAccessible, auditRequest);
            orderBy = SingleTableHelper.orderBy(tableAccessible, auditRequest);
            items = null;
            session = null;
            session = tableAccessible.getAuditIntegrator().getSessionFactory().openSession();
            if (!Boolean.TRUE.equals(page.getCount())) break block11;
            Query query = EntityNative.queryOf((SharedSessionContract)session, "select count(1) from " + table + " " + where.getQuery(), where.getParameters());
            Long records = Long.valueOf("" + query.getSingleResult());
            page.setRecords(records);
            if (records != 0L) break block11;
            Page page2 = page;
            EntityHelper.close((Session)session);
            return page2;
        }
        try {
            items = EntityNative.queryOf((SharedSessionContract)session, "select id, type, action, replica, auditor, info, entry, content from " + table + " " + where.getQuery() + " " + orderBy, where.getParameters(), (page.getIndex() - 1) * page.getSize(), page.getSize()).getResultList();
        }
        catch (Exception e) {
            try {
                throw FrameworkUtil.exception(e);
            }
            catch (Throwable throwable) {
                EntityHelper.close(session);
                throw throwable;
            }
        }
        EntityHelper.close((Session)session);
        if (items != null) {
            ArrayList<AuditObject> data = new ArrayList<AuditObject>();
            while (!items.isEmpty()) {
                Object[] item = (Object[])items.remove(0);
                AuditObject object = new AuditObject();
                int i = 0;
                object.setId((String)item[i++]);
                object.setType((String)item[i++]);
                object.setAction((String)item[i++]);
                Object v = item[i++];
                object.setReplica(v != null ? Integer.valueOf(Integer.parseInt("" + v)) : null);
                object.setAuditor((String)item[i++]);
                object.setInfo((String)item[i++]);
                v = item[i++];
                object.setEntry(v != null ? Long.valueOf("" + v) : null);
                v = item[i++];
                v = v != null ? AuditHelper.Mapper.nonull.read("" + v, JsonNode.class) : null;
                object.setContent(v);
                data.add(object);
            }
            page.setData(data);
        }
        return page;
    }

    private static AuditHelper.Where where(AuditHelper.TableAccessible tableAccessible, AuditRequest auditRequest) {
        StringBuilder sql = new StringBuilder("where 1=1 ");
        ArrayList<EntityNative.Parameter> params = new ArrayList<EntityNative.Parameter>();
        List filters = auditRequest.getFilters();
        if (filters != null && !filters.isEmpty()) {
            for (Filter filter : filters) {
                SingleTableHelper.filter(tableAccessible, filter, sql, params);
            }
        }
        AuditHelper.Where where = new AuditHelper.Where();
        where.setQuery(sql.toString());
        where.setParameters(params);
        return where;
    }

    private static void filter(AuditHelper.TableAccessible tableAccessible, Filter filter, StringBuilder sql, List<EntityNative.Parameter> parameters) {
        Condition.QueryParameters queryAndParameters;
        List qaParams;
        Assert.hasLength((String)filter.getField(), (String)"Filter field is required");
        AuditHelper.ColumnAccessible columnAccessible = tableAccessible.getColumnAccessibles().get(filter.getField());
        Assert.notNull((Object)columnAccessible, (String)("Invalid filter field: " + filter.getField()));
        String logic = " " + filter.getLogical().name();
        Condition condition = filter.getCondition();
        ArrayList<Object> lvals = new ArrayList<Object>();
        if (filter.getValues() != null) {
            if (condition.isConvert()) {
                for (Object fvalue : filter.getValues()) {
                    Object value = columnAccessible.getConverter().convert(fvalue != null ? fvalue : null);
                    lvals.add(value);
                }
            } else {
                for (Object svalue : filter.getValues()) {
                    lvals.add(svalue);
                }
            }
        }
        if ((qaParams = (queryAndParameters = condition.getBuilder().build(true, logic, parameters.size(), columnAccessible.getColumn().getName(), lvals.toArray())).getParameters()) != null) {
            Type htype = columnAccessible.getConverter() != null ? columnAccessible.getConverter().getHibernateType() : null;
            for (Object qap : qaParams) {
                parameters.add(EntityNative.Parameter.of(htype, qap));
            }
        }
        sql.append(queryAndParameters.getQuery());
    }

    private static String orderBy(AuditHelper.TableAccessible tableAccessible, AuditRequest auditRequest) {
        StringBuilder sortBy = new StringBuilder();
        List orders = auditRequest.getOrders();
        if (orders != null) {
            for (String order : orders) {
                boolean isAsc;
                String field = order != null ? order.trim() : "";
                if (field.isEmpty()) continue;
                boolean bl = isAsc = !field.startsWith("-");
                if (!isAsc) {
                    field = field.substring(1);
                }
                AuditHelper.ColumnAccessible columnAccessible = tableAccessible.getColumnAccessibles().get(field);
                Assert.notNull((Object)columnAccessible, (String)("Invalid order field: " + field));
                sortBy.append(columnAccessible.getColumn().getName()).append(" ").append(isAsc ? "asc" : "desc").append(",");
            }
        }
        if (sortBy.length() > 1) {
            sortBy.deleteCharAt(sortBy.length() - 1);
            return "order by " + sortBy.toString();
        }
        return "";
    }

    public static byte[] bytes(AuditHelper.TableAccessible tableAccessible, String id) {
        byte[] byArray;
        SessionImplementor session = null;
        try {
            session = tableAccessible.getAuditIntegrator().getSessionFactory().openSession();
            byArray = (byte[])EntityNative.queryOf((SharedSessionContract)session, "select bytes from " + tableAccessible.getTable().getQualifiedTableName().render() + " where id=?1", Arrays.asList(EntityNative.Parameter.of(AuditHelper.STRING_TYPE, id))).uniqueResult();
        }
        catch (Exception e) {
            try {
                throw FrameworkUtil.exception(e);
            }
            catch (Throwable throwable) {
                EntityHelper.close(session);
                throw throwable;
            }
        }
        EntityHelper.close((Session)session);
        return byArray;
    }
}

