/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.bean;

import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.Callable;
import net.ideahut.springboot.task.TaskHandler;
import net.ideahut.springboot.util.FrameworkUtil;
import org.springframework.context.ApplicationContext;
import org.springframework.util.Assert;

public interface BeanConfigure<T> {
    public Callable<T> onConfigureBean(ApplicationContext var1);

    public boolean isBeanConfigured();

    public static <T> void checkBeanConfigure(BeanConfigure<T> bean) {
        Assert.notNull(bean, (String)"bean is required");
        if (!bean.isBeanConfigured()) {
            throw FrameworkUtil.exception(bean.getClass().getName() + " not configured; call method configureBean() before using it");
        }
    }

    public static void runBeanConfigure(TaskHandler taskHandler, ApplicationContext applicationContext, Class<?> ... types) throws Exception {
        HashSet<BeanConfigure> beans = new HashSet<BeanConfigure>();
        if (types != null) {
            for (Class<?> type : types) {
                BeanConfigure bean = (BeanConfigure)applicationContext.getBean(type);
                bean.onConfigureBean(applicationContext).call();
                beans.add(bean);
            }
        }
        if (taskHandler != null) {
            Map map = applicationContext.getBeansOfType(BeanConfigure.class);
            for (Map.Entry entry : map.entrySet()) {
                if (beans.contains(entry.getValue())) continue;
                taskHandler.execute(() -> {
                    try {
                        ((BeanConfigure)entry.getValue()).onConfigureBean(applicationContext).call();
                    }
                    catch (Exception e) {
                        throw FrameworkUtil.exception(e);
                    }
                });
            }
        }
    }
}

