/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.bean;

import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

public interface BeanShutdown {
    public void onShutdownBean();

    public static class RuntimeHook {
        private static final Logger log = LoggerFactory.getLogger(RuntimeHook.class);

        private RuntimeHook() {
        }

        public static void register(ApplicationContext applicationContext) {
            final Map beans = applicationContext.getBeansOfType(BeanShutdown.class);
            Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

                @Override
                public void run() {
                    for (BeanShutdown bean : beans.values()) {
                        try {
                            log.info("Shutdown bean... " + bean.getClass().getName());
                            bean.onShutdownBean();
                        }
                        catch (Exception e) {
                            log.error(bean.getClass().getName(), (Throwable)e);
                        }
                    }
                }
            }));
        }
    }
}

