/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.converter;

import java.math.BigInteger;
import net.ideahut.springboot.converter.Converter;
import org.hibernate.type.BasicType;
import org.hibernate.type.Type;
import org.hibernate.type.descriptor.java.BigIntegerJavaType;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.jdbc.BigIntJdbcType;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.internal.BasicTypeImpl;

final class BigIntegerConverter
extends Converter {
    private static final BasicType<BigInteger> TYPE = new BasicTypeImpl((JavaType)BigIntegerJavaType.INSTANCE, (JdbcType)BigIntJdbcType.INSTANCE);

    protected BigIntegerConverter() {
    }

    private BigIntegerConverter(Class<?> type, Object ... args) {
        super(type, args);
        BigIntegerConverter.isEqual(BigInteger.class, type);
    }

    @Override
    protected Object valueOf(Object value) {
        String input = ("" + value).trim();
        return !input.isEmpty() ? new BigInteger(input) : this.nullValue();
    }

    @Override
    protected boolean isSupported(Class<?> type) {
        return BigInteger.class.isAssignableFrom(type);
    }

    @Override
    public Type getHibernateType() {
        return TYPE;
    }

    @Override
    protected Object nullValue() {
        return null;
    }

    @Override
    protected Converter newInstance(Class<?> type, Object ... args) {
        return new BigIntegerConverter(type, args);
    }
}

