/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.converter;

import net.ideahut.springboot.converter.Converter;
import org.hibernate.type.BasicType;
import org.hibernate.type.Type;
import org.hibernate.type.descriptor.java.BooleanJavaType;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.jdbc.BooleanJdbcType;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.internal.BasicTypeImpl;

final class BooleanConverter
extends Converter {
    private static final BasicType<Boolean> TYPE = new BasicTypeImpl((JavaType)BooleanJavaType.INSTANCE, (JdbcType)BooleanJdbcType.INSTANCE);

    protected BooleanConverter() {
    }

    private BooleanConverter(Class<?> type, Object ... args) {
        super(type, args);
        BooleanConverter.isEqual(Boolean.class, type);
    }

    @Override
    protected Object valueOf(Object value) {
        String input = ("" + value).trim();
        return !input.isEmpty() ? Boolean.valueOf(!"0".equals(input) && !"false".equalsIgnoreCase(input)) : this.nullValue();
    }

    @Override
    protected boolean isSupported(Class<?> type) {
        return Boolean.class.isAssignableFrom(type);
    }

    @Override
    public Type getHibernateType() {
        return TYPE;
    }

    @Override
    protected Object nullValue() {
        return null;
    }

    @Override
    protected Converter newInstance(Class<?> type, Object ... args) {
        return new BooleanConverter(type, args);
    }
}

