/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.converter;

import net.ideahut.springboot.converter.ByteArrayConverter;
import net.ideahut.springboot.converter.CollectionConverter;
import net.ideahut.springboot.converter.EntityConverter;
import net.ideahut.springboot.converter.EnumConverter;
import net.ideahut.springboot.converter.Helper;
import net.ideahut.springboot.converter.PrimitiveByteArrayConverter;
import net.ideahut.springboot.mapper.DataMapper;
import net.ideahut.springboot.mapper.DataMapperImpl;
import net.ideahut.springboot.util.FrameworkUtil;
import org.hibernate.type.Type;

public abstract class Converter {
    static final DataMapper mapper = new DataMapperImpl();
    private final Class<?> type;
    private final Object[] args;

    protected Converter() {
        this.type = null;
        this.args = new Object[0];
    }

    protected Converter(Class<?> type, Object ... args) {
        this.type = type;
        this.args = args;
    }

    public Class<?> getType() {
        return this.type;
    }

    protected Object[] getArgs() {
        return this.args;
    }

    public abstract Type getHibernateType();

    protected abstract Object valueOf(Object var1);

    protected abstract boolean isSupported(Class<?> var1);

    protected abstract Object nullValue();

    protected abstract Converter newInstance(Class<?> var1, Object ... var2);

    public Object convert(Object value) {
        if (value == null) {
            return this.nullValue();
        }
        if (this.type.getClass().equals(value.getClass())) {
            return value;
        }
        return this.valueOf(value);
    }

    public static Converter of(Class<?> type, Object ... args) {
        return Helper.getConverter(type, args);
    }

    static void isEqual(Class<?> base, Class<?> type) {
        boolean equal;
        boolean bl = equal = base != null && type != null && base.isAssignableFrom(type);
        if (!equal) {
            throw FrameworkUtil.exception("Unsupported converter for type: " + type);
        }
    }

    public static boolean isEntity(Converter converter) {
        return converter instanceof EntityConverter;
    }

    public static boolean isCollection(Converter converter) {
        return converter instanceof CollectionConverter;
    }

    public static boolean isByteArray(Converter converter) {
        return converter instanceof PrimitiveByteArrayConverter || converter instanceof ByteArrayConverter;
    }

    public static boolean isEnum(Converter converter) {
        return converter instanceof EnumConverter;
    }
}

