/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.converter;

import java.sql.Timestamp;
import java.util.Date;
import net.ideahut.springboot.converter.Converter;
import net.ideahut.springboot.converter.Helper;
import net.ideahut.springboot.util.FrameworkUtil;
import org.hibernate.type.BasicType;
import org.hibernate.type.Type;
import org.hibernate.type.descriptor.java.DateJavaType;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.TimestampJdbcType;
import org.hibernate.type.internal.BasicTypeImpl;

final class DateConverter
extends Converter {
    private static final BasicType<Date> TYPE = new BasicTypeImpl((JavaType)DateJavaType.INSTANCE, (JdbcType)TimestampJdbcType.INSTANCE);
    private String format;

    protected DateConverter() {
    }

    private DateConverter(Class<?> type, Object ... args) {
        super(type, args);
        DateConverter.isEqual(Date.class, type);
        this.format = "";
        if (args != null && args.length > 0 && args[0] instanceof String) {
            this.format = ((String)args[0]).trim();
        }
        if (this.format.isEmpty()) {
            this.format = "yyyy-MM-dd HH:mm:ss.SSSSSS";
        }
    }

    @Override
    protected Object valueOf(Object value) {
        if (value instanceof Timestamp) {
            return value;
        }
        String input = "" + value;
        if (input.isEmpty()) {
            return this.nullValue();
        }
        try {
            return Helper.Formatter.getSimpleDateFormat(this.format).parse(input);
        }
        catch (Exception e) {
            throw FrameworkUtil.exception(e);
        }
    }

    @Override
    protected boolean isSupported(Class<?> type) {
        return Date.class.isAssignableFrom(type);
    }

    @Override
    public Type getHibernateType() {
        return TYPE;
    }

    @Override
    protected Object nullValue() {
        return null;
    }

    @Override
    protected Converter newInstance(Class<?> type, Object ... args) {
        return new DateConverter(type, args);
    }
}

