/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.converter;

import net.ideahut.springboot.converter.Converter;
import org.hibernate.type.BasicType;
import org.hibernate.type.Type;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.java.LongJavaType;
import org.hibernate.type.descriptor.jdbc.BigIntJdbcType;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.internal.BasicTypeImpl;

final class LongConverter
extends Converter {
    private static final BasicType<Long> TYPE = new BasicTypeImpl((JavaType)LongJavaType.INSTANCE, (JdbcType)BigIntJdbcType.INSTANCE);

    protected LongConverter() {
    }

    private LongConverter(Class<?> type, Object ... args) {
        super(type, args);
        LongConverter.isEqual(Long.class, type);
    }

    @Override
    protected Object valueOf(Object value) {
        String input = ("" + value).trim();
        return !input.isEmpty() ? Long.valueOf(Long.parseLong(input)) : this.nullValue();
    }

    @Override
    protected boolean isSupported(Class<?> type) {
        return Long.class.isAssignableFrom(type);
    }

    @Override
    public Type getHibernateType() {
        return TYPE;
    }

    @Override
    protected Object nullValue() {
        return null;
    }

    @Override
    protected Converter newInstance(Class<?> type, Object ... args) {
        return new LongConverter(type, args);
    }
}

