/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.converter;

import net.ideahut.springboot.converter.Converter;
import org.hibernate.type.BasicType;
import org.hibernate.type.Type;
import org.hibernate.type.descriptor.java.CharacterJavaType;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.jdbc.CharJdbcType;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.internal.BasicTypeImpl;

final class PrimitiveCharacterConverter
extends Converter {
    private static final BasicType<Character> TYPE = new BasicTypeImpl((JavaType)CharacterJavaType.INSTANCE, (JdbcType)CharJdbcType.INSTANCE);

    protected PrimitiveCharacterConverter() {
    }

    private PrimitiveCharacterConverter(Class<?> type, Object ... args) {
        super(type, args);
        PrimitiveCharacterConverter.isEqual(Character.TYPE, type);
    }

    @Override
    protected Object valueOf(Object value) {
        String input = ("" + value).trim();
        return !input.isEmpty() ? Character.valueOf(input.charAt(0)) : this.nullValue();
    }

    @Override
    protected boolean isSupported(Class<?> type) {
        return Character.TYPE.isAssignableFrom(type);
    }

    @Override
    public Type getHibernateType() {
        return TYPE;
    }

    @Override
    protected Object nullValue() {
        return Character.valueOf('\u0000');
    }

    @Override
    protected Converter newInstance(Class<?> type, Object ... args) {
        return new PrimitiveCharacterConverter(type, args);
    }
}

