/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.converter;

import net.ideahut.springboot.converter.Converter;
import org.hibernate.type.BasicType;
import org.hibernate.type.Type;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.java.LongJavaType;
import org.hibernate.type.descriptor.jdbc.BigIntJdbcType;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.internal.BasicTypeImpl;

final class PrimitiveLongConverter
extends Converter {
    private static final BasicType<Long> TYPE = new BasicTypeImpl((JavaType)LongJavaType.INSTANCE, (JdbcType)BigIntJdbcType.INSTANCE);

    protected PrimitiveLongConverter() {
    }

    private PrimitiveLongConverter(Class<?> type, Object ... args) {
        super(type, args);
        PrimitiveLongConverter.isEqual(Long.TYPE, type);
    }

    @Override
    protected Object valueOf(Object value) {
        String input = ("" + value).trim();
        return !input.isEmpty() ? Long.valueOf(Long.parseLong(input)) : this.nullValue();
    }

    @Override
    protected boolean isSupported(Class<?> type) {
        return Long.TYPE.isAssignableFrom(type);
    }

    @Override
    public Type getHibernateType() {
        return TYPE;
    }

    @Override
    protected Object nullValue() {
        return 0L;
    }

    @Override
    protected Converter newInstance(Class<?> type, Object ... args) {
        return new PrimitiveLongConverter(type, args);
    }
}

