/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.converter;

import net.ideahut.springboot.converter.Converter;
import org.hibernate.type.BasicType;
import org.hibernate.type.Type;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.java.ShortJavaType;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.SmallIntJdbcType;
import org.hibernate.type.internal.BasicTypeImpl;

final class PrimitiveShortConverter
extends Converter {
    private static final BasicType<Short> TYPE = new BasicTypeImpl((JavaType)ShortJavaType.INSTANCE, (JdbcType)SmallIntJdbcType.INSTANCE);

    protected PrimitiveShortConverter() {
    }

    private PrimitiveShortConverter(Class<?> type, Object ... args) {
        super(type, args);
        PrimitiveShortConverter.isEqual(Short.TYPE, type);
    }

    @Override
    protected Object valueOf(Object value) {
        String input = ("" + value).trim();
        return !input.isEmpty() ? Short.valueOf(Short.parseShort(input)) : this.nullValue();
    }

    @Override
    protected boolean isSupported(Class<?> type) {
        return Short.TYPE.isAssignableFrom(type);
    }

    @Override
    public Type getHibernateType() {
        return TYPE;
    }

    @Override
    protected Object nullValue() {
        return 0;
    }

    @Override
    protected Converter newInstance(Class<?> type, Object ... args) {
        return new PrimitiveShortConverter(type, args);
    }
}

