/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.converter;

import net.ideahut.springboot.converter.Converter;
import org.hibernate.type.BasicType;
import org.hibernate.type.Type;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.java.ShortJavaType;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.SmallIntJdbcType;
import org.hibernate.type.internal.BasicTypeImpl;

final class ShortConverter
extends Converter {
    private static final BasicType<Short> TYPE = new BasicTypeImpl((JavaType)ShortJavaType.INSTANCE, (JdbcType)SmallIntJdbcType.INSTANCE);

    protected ShortConverter() {
    }

    private ShortConverter(Class<?> type, Object ... args) {
        super(type, args);
        ShortConverter.isEqual(Short.class, type);
    }

    @Override
    protected Object valueOf(Object value) {
        String input = ("" + value).trim();
        return !input.isEmpty() ? Short.valueOf(input) : this.nullValue();
    }

    @Override
    protected boolean isSupported(Class<?> type) {
        return Short.class.isAssignableFrom(type);
    }

    @Override
    public Type getHibernateType() {
        return TYPE;
    }

    @Override
    protected Object nullValue() {
        return null;
    }

    @Override
    protected Converter newInstance(Class<?> type, Object ... args) {
        return new ShortConverter(type, args);
    }
}

