/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.crud;

import net.ideahut.springboot.crud.CrudRequest;
import net.ideahut.springboot.crud.CrudResult;
import net.ideahut.springboot.crud.CrudSelect;
import net.ideahut.springboot.crud.CrudUpdate;

public enum CrudAction {
    UNIQUE(new Executor(){

        @Override
        public CrudResult execute(CrudRequest crudRequest) {
            CrudSelect crudSelect = CrudSelect.of(crudRequest);
            CrudResult crudResult = crudSelect.unique();
            crudSelect.destroy();
            return crudResult;
        }
    }),
    SINGLE(new Executor(){

        @Override
        public CrudResult execute(CrudRequest crudRequest) {
            CrudSelect crudSelect = CrudSelect.of(crudRequest);
            CrudResult crudResult = crudSelect.single();
            crudSelect.destroy();
            return crudResult;
        }
    }),
    PAGE(new Executor(){

        @Override
        public CrudResult execute(CrudRequest crudRequest) {
            CrudSelect crudSelect = CrudSelect.of(crudRequest);
            CrudResult crudResult = crudSelect.page();
            crudSelect.destroy();
            return crudResult;
        }
    }),
    LIST(new Executor(){

        @Override
        public CrudResult execute(CrudRequest crudRequest) {
            CrudSelect crudSelect = CrudSelect.of(crudRequest);
            CrudResult crudResult = crudSelect.list();
            crudSelect.destroy();
            return crudResult;
        }
    }),
    MAP(new Executor(){

        @Override
        public CrudResult execute(CrudRequest crudRequest) {
            CrudSelect crudSelect = CrudSelect.of(crudRequest);
            CrudResult crudResult = crudSelect.map();
            crudSelect.destroy();
            return crudResult;
        }
    }),
    CREATE(new Executor(){

        @Override
        public CrudResult execute(CrudRequest crudRequest) {
            CrudUpdate crudUpdate = CrudUpdate.of(crudRequest);
            CrudResult crudResult = crudUpdate.create();
            crudUpdate.destroy();
            return crudResult;
        }
    }),
    UPDATE(new Executor(){

        @Override
        public CrudResult execute(CrudRequest crudRequest) {
            CrudUpdate crudUpdate = CrudUpdate.of(crudRequest);
            CrudResult crudResult = crudUpdate.update();
            crudUpdate.destroy();
            return crudResult;
        }
    }),
    SAVE(new Executor(){

        @Override
        public CrudResult execute(CrudRequest crudRequest) {
            CrudUpdate crudUpdate = CrudUpdate.of(crudRequest);
            CrudResult crudResult = crudUpdate.save();
            crudUpdate.destroy();
            return crudResult;
        }
    }),
    DELETE(new Executor(){

        @Override
        public CrudResult execute(CrudRequest crudRequest) {
            CrudUpdate crudUpdate = CrudUpdate.of(crudRequest);
            CrudResult crudResult = crudUpdate.delete();
            crudUpdate.destroy();
            return crudResult;
        }
    }),
    DELETES(new Executor(){

        @Override
        public CrudResult execute(CrudRequest crudRequest) {
            CrudUpdate crudUpdate = CrudUpdate.of(crudRequest);
            CrudResult crudResult = crudUpdate.deletes();
            crudUpdate.destroy();
            return crudResult;
        }
    });

    private final Executor executor;

    private CrudAction(Executor executor) {
        this.executor = executor;
    }

    public Executor getExecutor() {
        return this.executor;
    }

    public static CrudAction of(String name) {
        try {
            return CrudAction.valueOf(name);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static interface Executor {
        public CrudResult execute(CrudRequest var1);
    }
}

