/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.crud;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.ideahut.springboot.crud.CrudAction;
import net.ideahut.springboot.crud.CrudBuilder0;
import net.ideahut.springboot.crud.CrudHandler;
import net.ideahut.springboot.crud.CrudRequest;
import net.ideahut.springboot.crud.CrudResult;
import net.ideahut.springboot.crud.Filter;
import net.ideahut.springboot.crud.Join;
import net.ideahut.springboot.crud.Stack;
import net.ideahut.springboot.entity.EntityInfo;
import net.ideahut.springboot.entity.TrxManagerInfo;
import net.ideahut.springboot.object.MapStringObject;
import net.ideahut.springboot.object.Page;
import org.springframework.util.Assert;

public class CrudBuilder {
    private final CrudRequest request;

    private CrudBuilder(CrudRequest request) {
        this.request = request;
    }

    public CrudBuilder setReplica(Integer replica) {
        CrudBuilder0.checkReplica(replica);
        this.request.setReplica(replica);
        return this;
    }

    public CrudBuilder setIds(List<Object> ids) {
        if (ids != null) {
            this.request.setIds(new ArrayList<Object>());
            for (Object id : ids) {
                CrudBuilder0.checkId(this.request.getProperties().getEntityInfo(), id);
                this.request.getIds().add(id);
            }
        }
        return this;
    }

    public CrudBuilder setId(Object id) {
        CrudBuilder0.checkId(this.request.getProperties().getEntityInfo(), id);
        this.request.setIds(Arrays.asList(id));
        return this;
    }

    public CrudBuilder setMapKeys(List<String> keys) {
        if (this.request.getMap() == null) {
            this.request.setMap(new CrudRequest.MapConfig());
        }
        this.request.getMap().setKeys(keys);
        return this;
    }

    public CrudBuilder setMapFlat(Boolean flat) {
        if (this.request.getMap() == null) {
            this.request.setMap(new CrudRequest.MapConfig());
        }
        this.request.getMap().setFlat(flat);
        return this;
    }

    public CrudBuilder setPage(Page page) {
        this.request.setPage(page);
        return this;
    }

    public CrudBuilder setStart(Integer start) {
        this.request.setStart(start);
        return this;
    }

    public CrudBuilder setLimit(Integer limit) {
        this.request.setLimit(limit);
        return this;
    }

    public CrudBuilder setFilters(List<Filter> filters) {
        this.request.setFilters(filters);
        return this;
    }

    public CrudBuilder addFilter(Filter filter) {
        if (this.request.getFilters() == null) {
            this.request.setFilters(new ArrayList<Filter>());
        }
        this.request.getFilters().add(filter);
        return this;
    }

    public CrudBuilder setOrders(List<String> orders) {
        this.request.setOrders(orders);
        return this;
    }

    public CrudBuilder addOrder(String order) {
        if (this.request.getOrders() == null) {
            this.request.setOrders(new ArrayList<String>());
        }
        this.request.getOrders().add(order);
        return this;
    }

    public CrudBuilder setFields(List<String> fields) {
        this.request.setFields(fields);
        return this;
    }

    public CrudBuilder addField(String field) {
        if (this.request.getFields() == null) {
            this.request.setFields(new ArrayList<String>());
        }
        this.request.getFields().add(field);
        return this;
    }

    public CrudBuilder setLoads(List<String> loads) {
        this.request.setLoads(loads);
        return this;
    }

    public CrudBuilder addLoad(String load) {
        if (this.request.getLoads() == null) {
            this.request.setLoads(new ArrayList<String>());
        }
        this.request.getLoads().add(load);
        return this;
    }

    public CrudBuilder setValues(List<Object> values) {
        if (values != null) {
            this.request.setValues(new ArrayList<MapStringObject>());
            for (Object value : values) {
                CrudBuilder0.checkValue(this.request.getProperties().getEntityInfo(), value);
                this.request.getValues().add(CrudBuilder0.convertValue(value));
            }
        } else {
            this.request.setValues(null);
        }
        return this;
    }

    public CrudBuilder setValue(Object value) {
        CrudBuilder0.checkValue(this.request.getProperties().getEntityInfo(), value);
        this.request.setValues(new ArrayList<MapStringObject>());
        this.request.getValues().add(CrudBuilder0.convertValue(value));
        return this;
    }

    public CrudBuilder addValue(Object value) {
        CrudBuilder0.checkValue(this.request.getProperties().getEntityInfo(), value);
        if (this.request.getValues() == null) {
            this.request.setValues(new ArrayList<MapStringObject>());
        }
        this.request.getValues().add(CrudBuilder0.convertValue(value));
        return this;
    }

    public CrudBuilder setJoins(List<Join> joins) {
        if (joins != null) {
            this.request.setJoins(new ArrayList<Join>());
            for (Join join : joins) {
                CrudBuilder0.checkJoin(this.request.getProperties().getEntityInfo(), join);
                this.request.getJoins().add(join);
            }
        } else {
            this.request.setJoins(null);
        }
        return this;
    }

    public CrudBuilder addJoin(Join join) {
        CrudBuilder0.checkJoin(this.request.getProperties().getEntityInfo(), join);
        if (this.request.getJoins() == null) {
            this.request.setJoins(new ArrayList<Join>());
        }
        this.request.getJoins().add(join);
        return this;
    }

    public CrudBuilder setStacks(List<Stack> stacks) {
        if (stacks != null) {
            this.request.setStacks(new ArrayList<Stack>());
            for (Stack stack : stacks) {
                CrudBuilder0.checkStack(this.request.getProperties().getEntityInfo(), stack);
                this.request.getStacks().add(stack);
            }
        } else {
            this.request.setStacks(null);
        }
        return this;
    }

    public CrudBuilder addStack(Stack stack) {
        CrudBuilder0.checkStack(this.request.getProperties().getEntityInfo(), stack);
        if (this.request.getStacks() == null) {
            this.request.setStacks(new ArrayList<Stack>());
        }
        this.request.getStacks().add(stack);
        return this;
    }

    public CrudBuilder setUseNative(Boolean useNative) {
        this.request.getProperties().setUseNative(useNative);
        return this;
    }

    public CrudBuilder setMaxLimit(Integer maxLimit) {
        this.request.getProperties().setMaxLimit(maxLimit);
        return this;
    }

    public CrudResult execute(CrudHandler handler, CrudAction action) {
        if (!Boolean.TRUE.equals(this.request.getProperties().getUseNative())) {
            this.request.getProperties().setUseNative(this.request.getReplica() != null && this.request.getReplica() > 0);
            if (!Boolean.TRUE.equals(this.request.getProperties().getUseNative())) {
                if (this.request.getJoins() != null) {
                    for (Join join : this.request.getJoins()) {
                        if (join.getReplica() == null || join.getReplica() <= 0) continue;
                        this.request.getProperties().setUseNative(Boolean.TRUE);
                        break;
                    }
                }
                if (!Boolean.TRUE.equals(this.request.getProperties().getUseNative()) && this.request.getStacks() != null) {
                    for (Stack stack : this.request.getStacks()) {
                        if (stack.getReplica() == null || stack.getReplica() <= 0) continue;
                        this.request.getProperties().setUseNative(Boolean.TRUE);
                        break;
                    }
                }
            }
        }
        return handler.execute(action, this.request);
    }

    public static CrudBuilder of(TrxManagerInfo trxManagerInfo, Class<?> entityType) {
        Assert.notNull((Object)trxManagerInfo, (String)"TrxManagerInfo is required");
        Assert.notNull(entityType, (String)"Entity type is required");
        EntityInfo entityInfo = trxManagerInfo.getEntityInfo(entityType);
        Assert.notNull((Object)entityInfo, (String)("Entity info is not found for: " + entityType.getName()));
        CrudRequest request = CrudRequest.of(entityInfo);
        return new CrudBuilder(request);
    }

    public static CrudBuilder of(EntityInfo entityInfo) {
        CrudRequest request = CrudRequest.of(entityInfo);
        return new CrudBuilder(request);
    }
}

