/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.crud;

import com.fasterxml.jackson.databind.JsonNode;
import net.ideahut.springboot.crud.CrudHelper0;
import net.ideahut.springboot.crud.Join;
import net.ideahut.springboot.crud.Relation;
import net.ideahut.springboot.crud.Stack;
import net.ideahut.springboot.entity.EntityInfo;
import net.ideahut.springboot.entity.FieldInfo;
import net.ideahut.springboot.entity.IdInfo;
import net.ideahut.springboot.object.MapStringObject;
import org.springframework.util.Assert;

final class CrudBuilder0 {
    private CrudBuilder0() {
    }

    static void checkReplica(Integer replica) {
        if (replica != null) {
            Assert.isTrue((replica > 0 ? 1 : 0) != 0, (String)("Invalid replica: " + replica));
        }
    }

    static void checkId(EntityInfo entityInfo, Object id) {
        IdInfo idInfo = entityInfo.getIdInfo();
        switch (idInfo.getIdType()) {
            case COMPOSITE: {
                Assert.isInstanceOf(entityInfo.getEntityClass(), (Object)id, (String)("Invalid id, required: " + entityInfo.getEntityClass().getName() + ", expected"));
                break;
            }
            case EMBEDDED: {
                Assert.isInstanceOf(idInfo.getEmbeddedEntityInfo().getEntityClass(), (Object)id, (String)("Invalid id, required: " + idInfo.getEmbeddedEntityInfo().getEntityClass().getName() + ", expected"));
                break;
            }
            case STANDARD: {
                FieldInfo fieldInfo = entityInfo.getFieldInfo(idInfo.getFields().iterator().next());
                Assert.isInstanceOf(fieldInfo.getType(), (Object)id, (String)("Invalid id, required: " + fieldInfo.getType().getName() + ", expected"));
                break;
            }
        }
    }

    static void checkValue(EntityInfo entityInfo, Object value) {
        Assert.notNull((Object)value, (String)"Value cannot be null");
        if (entityInfo != null) {
            Assert.isTrue((value != null && (entityInfo.getEntityClass().isAssignableFrom(value.getClass()) || value instanceof MapStringObject) ? 1 : 0) != 0, (String)("Invalid value, required: " + entityInfo.getEntityClass().getName() + " or " + MapStringObject.class.getName()));
        }
    }

    static void checkJoin(EntityInfo entityInfo, Join join) {
        Assert.notNull((Object)join, (String)"Join cannot be null");
        EntityInfo joinInfo = join.getEntityInfo();
        Assert.notNull((Object)joinInfo, (String)"Join EntityInfo is required");
        Assert.notNull(join.getRelations(), (String)"Join relations are required");
        for (Relation relation : join.getRelations()) {
            Assert.notNull((Object)relation, (String)"Join relation cannot be null");
            FieldInfo target = joinInfo.getFieldInfo(relation.getTarget());
            Assert.notNull((Object)target, (String)("Invalid join relation target: " + relation.getTarget() + ", relation: " + CrudHelper0.writeAsString(relation)));
            if (relation.getSource() != null) {
                FieldInfo source = entityInfo.getFieldInfo(relation.getSource());
                Assert.notNull((Object)source, (String)("Invalid join relation source: " + relation.getSource() + ", relation: " + CrudHelper0.writeAsString(relation)));
                continue;
            }
            Assert.notNull((Object)relation.getValue(), (String)("Join relation source or value required, relation: " + CrudHelper0.writeAsString(relation)));
        }
        if (join.getStore() != null) {
            FieldInfo store = entityInfo.getFieldInfo(join.getStore());
            if (store == null) {
                store = entityInfo.getFieldTransient(join.getStore());
            }
            Assert.notNull((Object)store, (String)("Invalid join store: " + join.getStore()));
        }
    }

    static void checkJoin(Join join) {
        Assert.notNull((Object)join, (String)"Join cannot be null");
        Assert.hasLength((String)join.getName(), (String)"Join name is required");
    }

    static void checkStack(EntityInfo entityInfo, Stack stack) {
        Assert.notNull((Object)stack, (String)"Stack cannot be null");
        EntityInfo stackInfo = stack.getEntityInfo();
        Assert.notNull((Object)stackInfo, (String)"Stack EntityInfo is required");
        Assert.notNull(stack.getRelations(), (String)"Stack relations are required");
        for (Relation relation : stack.getRelations()) {
            Assert.notNull((Object)relation, (String)"Stack realtion cannot be null");
            FieldInfo source = entityInfo.getFieldInfo(relation.getSource());
            Assert.notNull((Object)source, (String)("Invalid stack relation source: " + relation.getSource() + ", relation: " + CrudHelper0.writeAsString(relation)));
            FieldInfo target = stackInfo.getFieldInfo(relation.getTarget());
            Assert.notNull((Object)target, (String)("Invalid stack relation target: " + relation.getTarget() + ", relation: " + CrudHelper0.writeAsString(relation)));
        }
    }

    static void checkStack(Stack stack) {
        Assert.notNull((Object)stack, (String)"Stack cannot be null");
        Assert.hasLength((String)stack.getName(), (String)"Stack name is required");
    }

    static MapStringObject convertValue(Object value) {
        if (value instanceof MapStringObject) {
            return (MapStringObject)value;
        }
        return CrudHelper0.nodeToValue(CrudHelper0.Mapper.nonull.convert(value, JsonNode.class));
    }
}

