/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.crud;

import java.util.Arrays;
import net.ideahut.springboot.crud.Condition;
import net.ideahut.springboot.crud.CrudAction;
import net.ideahut.springboot.crud.CrudConstant;
import net.ideahut.springboot.crud.CrudHandler;
import net.ideahut.springboot.crud.CrudHelper0;
import net.ideahut.springboot.crud.CrudPermission;
import net.ideahut.springboot.crud.CrudProperties;
import net.ideahut.springboot.crud.CrudRequest;
import net.ideahut.springboot.crud.CrudResource;
import net.ideahut.springboot.crud.CrudResult;
import net.ideahut.springboot.crud.Logical;
import net.ideahut.springboot.crud.Match;
import net.ideahut.springboot.entity.EntityIdType;
import net.ideahut.springboot.entity.EntityInfo;
import net.ideahut.springboot.object.MapStringObject;
import net.ideahut.springboot.object.Message;
import net.ideahut.springboot.object.Page;
import net.ideahut.springboot.object.Result;
import org.springframework.util.Assert;

abstract class CrudControllerBase {
    CrudControllerBase() {
    }

    protected Result constant() {
        MapStringObject result = new MapStringObject();
        result.put((Object)"id", (Object)EntityIdType.values());
        result.put((Object)"logical", (Object)Logical.values());
        result.put((Object)"condition", (Object)Condition.values());
        result.put((Object)"match", (Object)Match.values());
        result.put((Object)"action", (Object)CrudAction.values());
        return Result.success((Object)result);
    }

    protected Result body(CrudAction action, byte[] data) {
        CrudRequest request = this.handler().getRequest(data);
        Result result = this.execute(action, request);
        return result.setInfo("action", (Object)action.name()).setInfo("name", (Object)request.getName());
    }

    protected Result object(String manager, String name, String id) {
        CrudProperties properties = this.getCrudProperties(manager, name);
        Object oid = CrudHelper0.idFromString(properties.getEntityInfo(), id);
        CrudRequest request = CrudRequest.of(properties).setIds(Arrays.asList(oid));
        return this.execute(CrudAction.SINGLE, request);
    }

    protected Result collection(String manager, String name, Integer index, Integer size, String count, String filters, String orders, String fields, String loads) {
        CrudProperties properties = this.getCrudProperties(manager, name);
        String scount = count != null ? count.toLowerCase() : "";
        Page page = Page.of((Integer)index, (Integer)size, (Boolean)("1".equals(scount) || "true".equals(scount) ? 1 : 0));
        CrudRequest request = CrudRequest.of(properties).setPage(page).setFilters(CrudHelper0.stringToFilters(filters)).setOrders(CrudHelper0.stringToList(orders)).setFields(CrudHelper0.stringToList(fields)).setLoads(CrudHelper0.stringToList(loads));
        return this.execute(CrudAction.PAGE, request);
    }

    protected Result create(String manager, String name, String value, byte[] data) {
        CrudProperties properties = this.getCrudProperties(manager, name);
        MapStringObject mvalue = null;
        mvalue = data != null && data.length != 0 ? CrudHelper0.byteArrayToMap(data) : CrudHelper0.stringToMap(value);
        CrudRequest request = CrudRequest.of(properties).setValues(Arrays.asList(mvalue));
        return this.execute(CrudAction.CREATE, request);
    }

    protected Result update(String manager, String name, String id, String value, byte[] data) {
        CrudProperties properties = this.getCrudProperties(manager, name);
        Object idValue = CrudHelper0.idFromString(properties.getEntityInfo(), id);
        MapStringObject mvalue = null;
        mvalue = data != null && data.length != 0 ? CrudHelper0.byteArrayToMap(data) : CrudHelper0.stringToMap(value);
        CrudRequest request = CrudRequest.of(properties).setIds(Arrays.asList(idValue)).setValues(Arrays.asList(mvalue));
        return this.execute(CrudAction.UPDATE, request);
    }

    protected Result delete(String manager, String name, String id) {
        CrudProperties properties = this.getCrudProperties(manager, name);
        Object idValue = CrudHelper0.idFromString(properties.getEntityInfo(), id);
        CrudRequest request = CrudRequest.of(properties).setIds(Arrays.asList(idValue));
        return this.execute(CrudAction.DELETE, request);
    }

    protected Result execute(CrudAction action, CrudRequest request) {
        boolean allowed;
        if (this.permission() != null && !(allowed = this.permission().isCrudAllowed(action, request))) {
            return CrudConstant.Error.NOT_ALLOWED.toResult();
        }
        CrudResult cres = this.handler().execute(action, request);
        Result result = cres.getError() != null ? Result.error((Message)cres.getError()) : Result.success((Object)cres.getValue());
        if (cres.getInfo() != null) {
            result.setInfo(cres.getInfo());
        }
        return result;
    }

    private CrudProperties getCrudProperties(String manager, String name) {
        CrudResource resource = this.handler().getCrudResource();
        Assert.notNull((Object)resource, (String)"CrudResource is required");
        CrudProperties properties = resource.getCrudProperties(manager, name);
        Assert.notNull((Object)properties, (String)"CrudProperties is not found");
        EntityInfo entityInfo = properties.getEntityInfo();
        Assert.notNull((Object)entityInfo, (String)"EntityInfo is not found");
        return properties;
    }

    protected abstract CrudHandler handler();

    protected abstract CrudPermission permission();
}

