/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.crud;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.ideahut.springboot.crud.Condition;
import net.ideahut.springboot.crud.CrudAction;
import net.ideahut.springboot.crud.CrudConstant;
import net.ideahut.springboot.crud.CrudHandler;
import net.ideahut.springboot.crud.CrudHelper0;
import net.ideahut.springboot.crud.CrudHelper1;
import net.ideahut.springboot.crud.CrudPermission;
import net.ideahut.springboot.crud.CrudProperties;
import net.ideahut.springboot.crud.CrudRequest;
import net.ideahut.springboot.crud.CrudResource;
import net.ideahut.springboot.crud.CrudResult;
import net.ideahut.springboot.crud.CrudSpecific;
import net.ideahut.springboot.crud.Filter;
import net.ideahut.springboot.entity.EntityTrxManager;
import net.ideahut.springboot.init.InitMapper;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.util.Assert;

public class CrudHandlerImpl
implements CrudHandler,
InitializingBean,
InitMapper {
    private ApplicationContext applicationContext;
    private EntityTrxManager entityTrxManager;
    private CrudResource resource;
    private CrudPermission permission;
    private Boolean alwaysUseNative;
    private Integer defaultMaxLimit;
    private Map<String, CrudSpecific> specifics = new LinkedHashMap<String, CrudSpecific>();

    public CrudHandlerImpl setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
        return this;
    }

    public CrudHandlerImpl setEntityTrxManager(EntityTrxManager entityTrxManager) {
        this.entityTrxManager = entityTrxManager;
        return this;
    }

    public CrudHandlerImpl setResource(CrudResource resource) {
        this.resource = resource;
        return this;
    }

    public CrudHandlerImpl setPermission(CrudPermission permission) {
        this.permission = permission;
        return this;
    }

    public CrudHandlerImpl setAlwaysUseNative(Boolean alwaysUseNative) {
        this.alwaysUseNative = alwaysUseNative;
        return this;
    }

    public CrudHandlerImpl setDefaultMaxLimit(Integer defaultMaxLimit) {
        this.defaultMaxLimit = defaultMaxLimit;
        return this;
    }

    public CrudHandlerImpl setSpecifics(Map<String, CrudSpecific> specifics) {
        if (specifics != null) {
            this.specifics = new LinkedHashMap<String, CrudSpecific>(specifics);
        }
        return this;
    }

    public CrudHandlerImpl putSpecific(String name, CrudSpecific specific) {
        Assert.isTrue((name != null && specific != null ? 1 : 0) != 0, (String)"CrudSpesific cannot be null");
        this.specifics.put(name, specific);
        return this;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.applicationContext, (String)"applicationContext is required");
        Assert.notNull((Object)this.entityTrxManager, (String)"entityTrxManager is required");
        if (this.alwaysUseNative == null) {
            this.alwaysUseNative = Boolean.FALSE;
        }
        if (this.defaultMaxLimit == null || this.defaultMaxLimit <= 0) {
            this.defaultMaxLimit = 100;
        }
    }

    @Override
    public void onInitMapper() throws Exception {
        CrudHelper0.Mapper.initialize(this.entityTrxManager);
    }

    @Override
    public EntityTrxManager getEntityTrxManager() {
        return this.entityTrxManager;
    }

    @Override
    public CrudResource getCrudResource() {
        return this.resource;
    }

    @Override
    public CrudResult execute(CrudAction action, CrudRequest request) {
        List<CrudProperties.SpecificFilter> filters;
        List<String> selectFields;
        boolean allowed;
        if (this.permission != null && !(allowed = this.permission.isCrudAllowed(action, request))) {
            return CrudConstant.Error.NOT_ALLOWED;
        }
        CrudProperties properties = request.getProperties();
        if (Boolean.TRUE.equals(this.alwaysUseNative)) {
            properties.setUseNative(Boolean.TRUE);
        }
        if (Boolean.FALSE.equals(properties.getEnableStack())) {
            request.setStacks(null);
        }
        if (Boolean.FALSE.equals(properties.getEnableLoad())) {
            request.setLoads(null);
        }
        if (properties.getMaxLimit() == null || properties.getMaxLimit() <= 0) {
            properties.setMaxLimit(this.defaultMaxLimit);
        }
        if ((selectFields = properties.getSelectFields()) != null && !selectFields.isEmpty()) {
            List<String> reqFields = request.getFields();
            if (reqFields != null && !reqFields.isEmpty()) {
                ArrayList<String> newFields = new ArrayList<String>();
                for (String field : reqFields) {
                    if (!selectFields.contains(field)) continue;
                    newFields.add(field);
                }
                request.setFields(newFields);
            } else {
                request.setFields(new ArrayList<String>(selectFields));
            }
        }
        if ((filters = properties.getSpecificFilters()) != null && !filters.isEmpty()) {
            List<Filter> spesifics = request.getSpesifics();
            if (spesifics == null) {
                spesifics = new ArrayList<Filter>();
                request.setSpesifics(spesifics);
            }
            for (CrudProperties.SpecificFilter filter : filters) {
                Filter specific;
                if (!Boolean.FALSE.equals(filter.getPlain())) {
                    specific = Filter.and((String)filter.getField(), (Condition)Condition.EQUAL, (Object[])new Object[]{filter.getValue()});
                } else {
                    Object value = this.getCrudSpecificValue(filter.getValue());
                    specific = Filter.and((String)filter.getField(), (Condition)Condition.EQUAL, (Object[])new Object[]{value});
                }
                spesifics.add(specific);
            }
        }
        return action.getExecutor().execute(request);
    }

    @Override
    public CrudRequest getRequest(byte[] data) {
        return CrudHelper1.getRequest(this, data);
    }

    private Object getCrudSpecificValue(String name) {
        CrudSpecific specific = this.specifics.get(name);
        Assert.notNull((Object)specific, (String)("CrudSpecific is not found: " + name));
        return specific.getCrudSpecificValue(this.applicationContext);
    }
}

