/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.crud;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import net.ideahut.springboot.crud.Condition;
import net.ideahut.springboot.crud.CrudAction;
import net.ideahut.springboot.crud.CrudHelper1;
import net.ideahut.springboot.crud.CrudProperties;
import net.ideahut.springboot.crud.CrudRequest;
import net.ideahut.springboot.crud.CrudResource;
import net.ideahut.springboot.crud.CrudRest;
import net.ideahut.springboot.crud.CrudResult;
import net.ideahut.springboot.crud.CrudSelect;
import net.ideahut.springboot.crud.CrudSelect0;
import net.ideahut.springboot.crud.CrudSelectEntity;
import net.ideahut.springboot.crud.CrudSelectEntity0;
import net.ideahut.springboot.crud.CrudSelectNative;
import net.ideahut.springboot.crud.CrudSelectNative0;
import net.ideahut.springboot.crud.CrudUpdate;
import net.ideahut.springboot.crud.CrudUpdateEntity;
import net.ideahut.springboot.crud.CrudUpdateEntity0;
import net.ideahut.springboot.crud.CrudUpdateNative;
import net.ideahut.springboot.crud.CrudUpdateNative0;
import net.ideahut.springboot.crud.Filter;
import net.ideahut.springboot.crud.Join;
import net.ideahut.springboot.crud.Logical;
import net.ideahut.springboot.crud.Match;
import net.ideahut.springboot.crud.Relation;
import net.ideahut.springboot.crud.Stack;
import net.ideahut.springboot.entity.EntityIdType;
import net.ideahut.springboot.entity.EntityInfo;
import net.ideahut.springboot.entity.EntityTrxManager;
import net.ideahut.springboot.entity.FieldInfo;
import net.ideahut.springboot.entity.IdInfo;
import net.ideahut.springboot.entity.TrxManagerInfo;
import net.ideahut.springboot.exception.ResultRuntimeException;
import net.ideahut.springboot.init.InitMapper;
import net.ideahut.springboot.mapper.DataMapper;
import net.ideahut.springboot.mapper.DataMapperImpl;
import net.ideahut.springboot.object.MapStringObject;
import net.ideahut.springboot.object.Page;
import net.ideahut.springboot.object.Result;
import net.ideahut.springboot.util.FrameworkUtil;
import org.springframework.data.util.ProxyUtils;
import org.springframework.util.Assert;

final class CrudHelper0 {
    private CrudHelper0() {
    }

    static <T> T copy(Object object, Class<T> type) {
        return Mapper.nuller.copy(object, type);
    }

    static <T> T convert(Object object, Class<T> type) {
        return Mapper.nuller.convert(object, type);
    }

    static MapStringObject nodeToMap(JsonNode node) {
        MapStringObject map = new MapStringObject();
        Iterator iter = node.fieldNames();
        while (iter.hasNext()) {
            String name = (String)iter.next();
            JsonNode item = node.get(name);
            if (item.isContainerNode()) {
                map.put((Object)name, (Object)CrudHelper0.nodeToMap(item));
                continue;
            }
            if (item.isNull()) {
                map.put((Object)name, null);
                continue;
            }
            map.put((Object)name, (Object)item.asText());
        }
        return map;
    }

    static MapStringObject nodeToValue(JsonNode node) {
        MapStringObject map = new MapStringObject();
        Iterator iter = node.fieldNames();
        while (iter.hasNext()) {
            String name = (String)iter.next();
            int idx = name.indexOf(".");
            if (idx != -1) {
                String pkey = name.substring(0, idx);
                MapStringObject pval = (MapStringObject)map.getOrDefault((Object)pkey, (Object)new MapStringObject());
                map.put((Object)pkey, (Object)pval);
                String pname = name.substring(idx + 1);
                JsonNode item = node.get(name);
                if (item.isContainerNode()) {
                    pval.put((Object)pname, (Object)CrudHelper0.nodeToMap(item));
                    continue;
                }
                if (item.isNull()) {
                    pval.put((Object)pname, null);
                    continue;
                }
                pval.put((Object)pname, (Object)item.asText());
                continue;
            }
            JsonNode item = node.get(name);
            if (item.isContainerNode()) {
                map.put((Object)name, (Object)CrudHelper0.nodeToMap(item));
                continue;
            }
            if (item.isNull()) {
                map.put((Object)name, null);
                continue;
            }
            map.put((Object)name, (Object)item.asText());
        }
        return map;
    }

    static <T> T nodeToObject(JsonNode node, Class<T> type) {
        return Mapper.nuller.convert((Object)node, type);
    }

    static List<Filter> nodeToFilter(JsonNode node) {
        ArrayList<Filter> filters = new ArrayList<Filter>();
        for (JsonNode item : node) {
            Filter filter = new Filter();
            if (item.has("filters")) {
                JsonNode children = item.get("filters");
                Assert.isTrue((boolean)children.isArray(), (String)("Invalid filter child: " + CrudHelper0.writeAsString(children)));
                List<Filter> list = CrudHelper0.nodeToFilter(children);
                filter.setFilters(list);
            } else {
                String field = CrudHelper0.getStringValue(item, "field", "");
                Assert.hasLength((String)field, (String)"Filter field is required");
                filter.setField(field);
            }
            String str = CrudHelper0.getStringValue(item, "condition", "");
            Condition condition = Condition.of((String)str, (Condition)Condition.EQUAL);
            filter.setCondition(condition);
            str = CrudHelper0.getStringValue(item, "logical", "");
            Logical logical = Logical.of((String)str, (Logical)Logical.AND);
            filter.setLogical(logical);
            if (item.has("value")) {
                String value = item.get("value").asText();
                filter.setValues(new ArrayList());
                filter.getValues().add(value);
            } else if (item.has("values")) {
                JsonNode values = item.get("values");
                Assert.isTrue((boolean)values.isArray(), (String)("Invalid values: " + CrudHelper0.writeAsString(values)));
                filter.setValues(new ArrayList());
                for (JsonNode value : values) {
                    filter.getValues().add(value.asText());
                }
            }
            filters.add(filter);
        }
        return filters;
    }

    static List<String> nodeToStringList(JsonNode node) {
        return Mapper.nuller.convert((Object)node, TypeRef.LIST_STRING);
    }

    static void mapNameValue(MapStringObject map, String name, Object value) {
        String[] names = name.split("\\.");
        MapStringObject temp = map;
        for (int i = 0; i < names.length - 1; ++i) {
            MapStringObject nmap = (MapStringObject)temp.get((Object)names[i]);
            if (nmap == null) {
                nmap = new MapStringObject();
                temp.put((Object)names[i], (Object)nmap);
            }
            temp = nmap;
        }
        temp.put((Object)names[names.length - 1], value);
    }

    static MapStringObject stringToMap(String string) {
        if (string == null) {
            return new MapStringObject();
        }
        try {
            return CrudHelper0.nodeToMap(Mapper.nuller.read(string, JsonNode.class));
        }
        catch (Exception e) {
            String[] items;
            MapStringObject map = new MapStringObject();
            for (String item : items = string.split("~~")) {
                int idx = item.indexOf(":");
                if (idx == -1) continue;
                String key = item.substring(0, idx);
                String value = item.substring(idx + 1);
                String[] names = key.split("\\.");
                MapStringObject temp = map;
                for (int i = 0; i < names.length - 1; ++i) {
                    MapStringObject nmap = (MapStringObject)temp.get((Object)names[i]);
                    if (nmap == null) {
                        nmap = new MapStringObject();
                        temp.put((Object)names[i], (Object)nmap);
                    }
                    temp = nmap;
                }
                temp.put((Object)names[names.length - 1], (Object)value);
            }
            return map;
        }
    }

    static Object idFromNode(EntityInfo entityInfo, JsonNode node) {
        Object id = null;
        IdInfo idInfo = entityInfo.getIdInfo();
        switch (idInfo.getIdType()) {
            case EMBEDDED: {
                id = Mapper.nuller.convert((Object)node, idInfo.getEmbeddedEntityInfo().getEntityClass());
                break;
            }
            case COMPOSITE: {
                id = Mapper.nuller.convert((Object)node, entityInfo.getEntityClass());
                break;
            }
            case STANDARD: {
                id = entityInfo.getFieldInfo(idInfo.getFields().iterator().next()).convert(node.asText());
                break;
            }
        }
        return id;
    }

    static Object idFromString(EntityInfo entityInfo, String value) {
        Object id = null;
        IdInfo idInfo = entityInfo.getIdInfo();
        switch (idInfo.getIdType()) {
            case EMBEDDED: {
                id = CrudHelper0.stringToObject(value, idInfo.getEmbeddedEntityInfo().getEntityClass());
                break;
            }
            case COMPOSITE: {
                MapStringObject map = CrudHelper0.stringToMap(value);
                id = CrudHelper0.mapToObject(map, entityInfo.getEntityClass());
                break;
            }
            case STANDARD: {
                id = entityInfo.getFieldInfo(idInfo.getFields().iterator().next()).convert(value);
                break;
            }
        }
        return id;
    }

    static Object idFromEntity(EntityInfo entityInfo, Object entity) {
        if (entity != null && entity.getClass().equals(entityInfo.getEntityClass())) {
            try {
                Object idValue = null;
                IdInfo idInfo = entityInfo.getIdInfo();
                if (EntityIdType.COMPOSITE.equals((Object)idInfo.getIdType())) {
                    idValue = entityInfo.createEntity();
                    for (String field : idInfo.getFields()) {
                        FieldInfo fieldInfo = entityInfo.getFieldInfo(field);
                        fieldInfo.setValue(idValue, fieldInfo.getValue(entity));
                    }
                } else {
                    idValue = entityInfo.getFieldInfo(idInfo.getFields().iterator().next()).getValue(entity);
                }
                return idValue;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    static <T> T stringToObject(String value, Class<?> type) {
        try {
            return (T)Mapper.nuller.read(value, type);
        }
        catch (Exception e) {
            MapStringObject map = CrudHelper0.stringToMap(value);
            if (map.isEmpty()) {
                return null;
            }
            return (T)Mapper.nuller.convert((Object)map, type);
        }
    }

    static List<String> stringToList(String string) {
        if (string == null) {
            return new ArrayList<String>();
        }
        try {
            return Mapper.nuller.read(string, TypeRef.LIST_STRING);
        }
        catch (Exception e) {
            String[] stringArray;
            ArrayList<String> list = new ArrayList<String>();
            for (String value : stringArray = string.split(",")) {
                if ((value = value.trim()).isEmpty()) continue;
                list.add(value);
            }
            return list;
        }
    }

    static Page stringToPage(String string) {
        try {
            return Mapper.nuller.read(string, Page.class);
        }
        catch (Exception e) {
            List<String> lpage = CrudHelper0.stringToList(string);
            if (lpage != null && !lpage.isEmpty()) {
                Page page = Page.of((Integer)Integer.valueOf(lpage.get(0)));
                if (lpage.size() > 1) {
                    page.setSize(Integer.valueOf(lpage.get(1).trim()));
                }
                if (lpage.size() > 2) {
                    String count = lpage.get(2).trim().toLowerCase();
                    page.setCount(Boolean.valueOf(!"0".equals(count) && !"false".equals(count)));
                }
                return page;
            }
            return Page.empty();
        }
    }

    static List<Filter> stringToFilters(String string) {
        ArrayList<Filter> filters;
        if (string == null) {
            return new ArrayList<Filter>();
        }
        try {
            filters = CrudHelper0.nodeToFilter(Mapper.nuller.read(string, JsonNode.class));
        }
        catch (Exception e) {
            String[] items;
            filters = new ArrayList();
            for (String item : items = string.split("~~")) {
                String[] ss;
                String[] strFilters = item.split("--");
                if (strFilters.length < 3) {
                    throw new ResultRuntimeException(Result.error((String)"20", (String)"Invalid filter length"));
                }
                Logical logical = Logical.AND;
                if (strFilters.length > 3) {
                    String slogical = strFilters[0].trim().toUpperCase();
                    if ("AND".equals(slogical) || "OR".equals(slogical)) {
                        logical = Logical.valueOf((String)slogical);
                        strFilters = Arrays.copyOfRange(strFilters, 1, strFilters.length);
                    }
                    strFilters[2] = String.join((CharSequence)"--", Arrays.copyOfRange(strFilters, 2, strFilters.length));
                }
                String field = strFilters[0];
                Condition condition = Condition.of((String)strFilters[1], (Condition)Condition.EQUAL);
                ArrayList<String> values = new ArrayList<String>();
                for (String s : ss = strFilters[2].split("--")) {
                    values.add(s);
                }
                Filter filter = Filter.of((Logical)logical, (String)field, (Condition)condition, (Object[])values.toArray());
                filters.add(filter);
            }
        }
        return filters;
    }

    static <T> T mapToObject(MapStringObject map, Class<T> type) {
        if (map == null) {
            return null;
        }
        return Mapper.nuller.convert((Object)map, type);
    }

    static <T> T byteArrayToObject(byte[] data, Class<T> type) {
        JsonNode node = CrudHelper0.readValue(data);
        return CrudHelper0.nodeToObject(node, type);
    }

    static MapStringObject byteArrayToMap(byte[] data) {
        JsonNode node = CrudHelper0.readValue(data);
        return CrudHelper0.nodeToMap(node);
    }

    static JsonNode readValue(Object value) {
        try {
            if (value instanceof byte[]) {
                return Mapper.nuller.read((byte[])value, JsonNode.class);
            }
            if (value instanceof String) {
                return Mapper.nuller.read((String)value, JsonNode.class);
            }
            throw FrameworkUtil.exception("Invalid type");
        }
        catch (Exception e) {
            throw FrameworkUtil.exception(e);
        }
    }

    static String writeAsString(Object object) {
        return Mapper.nonull.writeAsString(object, 1);
    }

    static String getStringValue(JsonNode node, String key, String defaultValue) {
        if (!node.has(key)) {
            return defaultValue;
        }
        JsonNode value = node.get(key);
        return !value.isNull() ? value.asText() : defaultValue;
    }

    static JsonNode getNodeValue(JsonNode node, String key) {
        if (!node.has(key)) {
            return null;
        }
        JsonNode value = node.get(key);
        return !value.isNull() ? value : null;
    }

    static Join getJoin(CrudResource resource, EntityInfo parentInfo, JsonNode node) {
        Integer replica;
        String sreplica;
        List<String> nfields;
        String name = CrudHelper0.getStringValue(node, "name", "");
        Assert.hasLength((String)name, (String)("Join name is required: " + CrudHelper0.writeAsString(node)));
        TrxManagerInfo trxManagerInfo = parentInfo.getTrxManagerInfo();
        CrudProperties properties = resource.getCrudProperties(trxManagerInfo.getName(), name);
        Assert.notNull((Object)properties, (String)("Join CrudProperties is not found: " + CrudHelper0.writeAsString(node)));
        EntityInfo info = properties.getEntityInfo();
        Assert.notNull((Object)info, (String)("Join EntityInfo is not found: " + CrudHelper0.writeAsString(node)));
        Join join = Join.of(info);
        join.setName(name);
        join.setFields(properties.getSelectFields());
        JsonNode items = CrudHelper0.getNodeValue(node, "relations");
        if (items != null) {
            Assert.isTrue((boolean)items.isArray(), (String)("Invalid join relations, name: " + name + ", relations: " + CrudHelper0.writeAsString(items)));
            join.setRelations(new ArrayList<Relation>());
            for (JsonNode item : items) {
                Relation relation = new Relation();
                String target = CrudHelper0.getStringValue(item, "target", "");
                int idx = target.indexOf(".");
                FieldInfo tinfo = info.getFieldInfo(idx != -1 ? target.substring(0, idx) : target);
                Assert.notNull((Object)tinfo, (String)("Invalid Join relation target, name: " + name + ", relation: " + CrudHelper0.writeAsString(item)));
                relation.setTarget(target);
                String source = CrudHelper0.getStringValue(item, "source", "");
                if (!source.isEmpty()) {
                    idx = source.indexOf(".");
                    FieldInfo sinfo = parentInfo.getFieldInfo(idx != -1 ? source.substring(0, idx) : source);
                    Assert.notNull((Object)sinfo, (String)("Invalid Join relation source, name: " + name + ", relation: " + CrudHelper0.writeAsString(item)));
                    relation.setSource(source);
                } else {
                    Assert.isTrue((boolean)item.has("value"), (String)("Join relation value/source is required, name: " + name + ", relation" + CrudHelper0.writeAsString(item)));
                    String str = item.get("value").asText();
                    Object value = tinfo.convert(str);
                    relation.setValue(value);
                }
                join.addRelation(relation);
            }
        }
        Assert.notEmpty(join.getRelations(), (String)("Join relations required, name: " + name));
        String store = CrudHelper0.getStringValue(node, "store", "");
        if (!store.isEmpty()) {
            FieldInfo fieldInfo = parentInfo.getFieldInfo(store);
            if (fieldInfo == null) {
                fieldInfo = parentInfo.getFieldTransient(store);
            }
            Assert.notNull((Object)fieldInfo, (String)("Invalid join store: " + store));
            join.setStore(store);
        }
        if (node.has("fields") && (nfields = Mapper.nonull.convert((Object)node.get("fields"), TypeRef.LIST_STRING)) != null && !nfields.isEmpty()) {
            List<String> jfields = join.getFields();
            if (jfields != null && !jfields.isEmpty()) {
                ArrayList<String> newFields = new ArrayList<String>();
                for (String jfield : jfields) {
                    if (!nfields.contains(jfield)) continue;
                    newFields.add(jfield);
                }
                join.setFields(newFields);
            } else {
                join.setFields(new ArrayList<String>(nfields));
            }
        }
        if (!(sreplica = CrudHelper0.getStringValue(node, "replica", "").trim()).isEmpty() && (replica = Integer.valueOf(sreplica)) > 0) {
            join.setReplica(replica);
        }
        String match = CrudHelper0.getStringValue(node, "match", "");
        join.setMatch(Match.of((String)match, (Match)Match.EXACT));
        String select = CrudHelper0.getStringValue(node, "select", "").toLowerCase();
        join.setSelect(!"0".equals(select) && !"false".equals(select));
        return join;
    }

    static Stack getStack(CrudResource resource, EntityInfo parentInfo, JsonNode node) {
        Integer replica;
        JsonNode items;
        String name = CrudHelper0.getStringValue(node, "name", "");
        Assert.hasLength((String)name, (String)("Stack name is required: " + CrudHelper0.writeAsString(node)));
        TrxManagerInfo trxManagerInfo = parentInfo.getTrxManagerInfo();
        CrudProperties properties = resource.getCrudProperties(trxManagerInfo.getName(), name);
        Assert.notNull((Object)properties, (String)("Stack CrudProperties is not found: " + CrudHelper0.writeAsString(node)));
        EntityInfo info = properties.getEntityInfo();
        Assert.notNull((Object)info, (String)("Stack EntityInfo is not found: " + CrudHelper0.writeAsString(node)));
        Stack stack = Stack.of(info);
        stack.setName(name);
        if (node.has("value")) {
            JsonNode item = node.get("value");
            Assert.isTrue((boolean)item.isObject(), (String)("Invalid stack value: " + CrudHelper0.writeAsString(item)));
            MapStringObject value = CrudHelper0.nodeToValue(item);
            stack.setValues(new ArrayList<Object>());
            stack.getValues().add(value);
        } else if (node.has("values")) {
            items = node.get("values");
            Assert.isTrue((boolean)items.isArray(), (String)("Invalid stack values: " + CrudHelper0.writeAsString(items)));
            stack.setValues(new ArrayList<Object>());
            for (JsonNode item : items) {
                MapStringObject value = CrudHelper0.nodeToValue(item);
                stack.getValues().add(value);
            }
        }
        if (node.has("relations")) {
            items = node.get("relations");
            Assert.isTrue((boolean)items.isArray(), (String)("Invalid stack relations: " + CrudHelper0.writeAsString(items)));
            stack.setRelations(new ArrayList<Relation>());
            for (JsonNode item : items) {
                Relation relation = new Relation();
                String target = CrudHelper0.getStringValue(item, "target", "");
                FieldInfo tinfo = info.getFieldInfo(target);
                Assert.notNull((Object)tinfo, (String)("Invalid Stack relation target, name: " + name + ", relation: " + CrudHelper0.writeAsString(item)));
                relation.setTarget(target);
                String source = CrudHelper0.getStringValue(item, "source", "");
                FieldInfo sinfo = parentInfo.getFieldInfo(source);
                Assert.notNull((Object)sinfo, (String)("Invalid Stack relation source, name: " + name + ", relation: " + CrudHelper0.writeAsString(item)));
                relation.setSource(source);
                stack.getRelations().add(relation);
            }
        }
        Assert.notEmpty(stack.getRelations(), (String)("Stack relations required, name: " + name));
        String sreplica = CrudHelper0.getStringValue(node, "replica", "").trim();
        if (!sreplica.isEmpty() && (replica = Integer.valueOf(sreplica)) > 0) {
            stack.setReplica(replica);
        }
        return stack;
    }

    static final class Mapper {
        static final DataMapper nuller = new DataMapperImpl(true);
        static final DataMapper nonull = new DataMapperImpl(false);

        private Mapper() {
        }

        static void initialize(EntityTrxManager entityTrxManager) throws Exception {
            CrudRequest crudRequest = CrudRequest.of("___");
            Mapper.loadDefault();
            Mapper.loadObject(new CrudProperties());
            Mapper.loadObject(crudRequest);
            Mapper.loadObject(new CrudRequest.MapConfig());
            Mapper.loadObject(CrudRest.of("___"));
            Mapper.loadObject(CrudResult.success((Object)"___").setInfo("___", (Object)"___"));
            Mapper.loadObject(Filter.and((String)"___", (Condition)Condition.EQUAL, (Object[])new Object[0]));
            Mapper.loadObject(Join.of("___"));
            Mapper.loadObject(new Relation());
            Mapper.loadObject(Stack.of("___"));
            Mapper.loadObject(new CrudSelect0.Ql());
            Mapper.loadObject(new CrudSelect0.SelectJoin());
            Mapper.loadObject(new CrudSelect0.StartLimit());
            Mapper.loadObject(new Condition.QueryParameters());
            for (TrxManagerInfo trxManagerInfo : entityTrxManager.getTrxManagerInfos()) {
                for (Class<?> entityClass : trxManagerInfo.getEntityClasses()) {
                    EntityInfo entityInfo = trxManagerInfo.getEntityInfo(entityClass);
                    Object object = entityInfo.createEntity();
                    Mapper.loadObject(object);
                }
            }
            ProxyUtils.getUserClass((Object)crudRequest);
            CrudAction.PAGE.name();
            CrudHelper1.getId(crudRequest);
            CrudUpdate.class.getName();
            CrudUpdateEntity.class.getName();
            CrudUpdateEntity0.class.getName();
            CrudUpdateNative.class.getName();
            CrudUpdateNative0.class.getName();
            CrudSelect.class.getName();
            CrudSelectEntity.class.getName();
            CrudSelectEntity0.class.getName();
            CrudSelectNative.class.getName();
            CrudSelectNative0.class.getName();
        }

        private static void loadDefault() throws Exception {
            InitMapper.loadDefault(nonull);
            InitMapper.loadDefault(nuller);
        }

        private static void loadObject(Object object) throws Exception {
            InitMapper.loadObject(nonull, object);
            InitMapper.loadObject(nuller, object);
        }
    }

    static final class Key {
        public static final String MANAGER = "manager";
        public static final String NAME = "name";
        public static final String REPLICA = "replica";
        public static final String MAP = "map";
        public static final String FLAT = "flat";
        public static final String KEY = "key";
        public static final String KEYS = "keys";
        public static final String ID = "id";
        public static final String IDS = "ids";
        public static final String PAGE = "page";
        public static final String START = "start";
        public static final String LIMIT = "limit";
        public static final String FILTERS = "filters";
        public static final String ORDERS = "orders";
        public static final String FIELD = "field";
        public static final String FIELDS = "fields";
        public static final String LOADS = "loads";
        public static final String VALUE = "value";
        public static final String VALUES = "values";
        public static final String CONDITION = "condition";
        public static final String LOGICAL = "logical";
        public static final String JOINS = "joins";
        public static final String STORE = "store";
        public static final String RELATIONS = "relations";
        public static final String MATCH = "match";
        public static final String SELECT = "select";
        public static final String STACKS = "stacks";
        public static final String SOURCE = "source";
        public static final String TARGET = "target";

        private Key() {
        }
    }

    private static class TypeRef {
        static TypeReference<List<String>> LIST_STRING = new TypeReference<List<String>>(){};

        private TypeRef() {
        }
    }

    static final class Split {
        public static final String ITEM = "~~";
        public static final String KEYVAL = ":";
        public static final String FILTER = "--";
        public static final String ARRAY = ",";

        private Split() {
        }
    }
}

