/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.crud;

import java.util.ArrayList;
import java.util.List;
import net.ideahut.springboot.crud.CrudHandler;
import net.ideahut.springboot.crud.CrudHelper0;
import net.ideahut.springboot.crud.CrudProperties;
import net.ideahut.springboot.crud.CrudRequest;
import net.ideahut.springboot.crud.CrudResource;
import net.ideahut.springboot.entity.EntityInfo;
import net.ideahut.springboot.entity.EntityTrxManager;
import net.ideahut.springboot.entity.TrxManagerInfo;
import net.ideahut.springboot.object.MapStringObject;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.util.Assert;
import org.springframework.util.MultiValueMap;

final class CrudHelperWebFlux {
    private CrudHelperWebFlux() {
    }

    static CrudRequest getRequest(CrudHandler handler, ServerHttpRequest request) {
        String page;
        String sid;
        Integer replica;
        String sreplica;
        Assert.notNull((Object)handler, (String)"CrudHandler is required");
        CrudResource resource = handler.getCrudResource();
        Assert.notNull((Object)resource, (String)"CrudHandler.Resource is required");
        EntityTrxManager entityTrxManager = handler.getEntityTrxManager();
        Assert.notNull((Object)entityTrxManager, (String)"EntityTrxManager is required");
        MultiValueMap params = request.getQueryParams();
        String manager = (String)params.getFirst((Object)"manager");
        TrxManagerInfo trxManagerInfo = entityTrxManager.getDefaultTrxManagerInfo();
        if (!manager.isEmpty()) {
            trxManagerInfo = entityTrxManager.getTrxManagerInfo(manager);
            Assert.notNull((Object)trxManagerInfo, (String)("Manager is not found: " + manager));
        }
        String name = (String)params.getFirst((Object)"name");
        Assert.hasLength((String)name, (String)"Name is required");
        CrudProperties properties = resource.getCrudProperties(trxManagerInfo.getName(), name);
        Assert.notNull((Object)properties, (String)("CrudProperties is not found, name: " + name + ", manager: " + manager));
        EntityInfo entityInfo = properties.getEntityInfo();
        Assert.notNull((Object)entityInfo, (String)("EntityInfo is not found, name: " + name + ", manager: " + manager));
        CrudRequest crudRequest = CrudRequest.of(properties);
        crudRequest.setManager(trxManagerInfo.getName());
        crudRequest.setName(name);
        String string = sreplica = params.getFirst((Object)"replica") != null ? ((String)params.getFirst((Object)"replica")).trim() : "";
        if (!sreplica.isEmpty() && (replica = Integer.valueOf(sreplica)) > 0) {
            crudRequest.setReplica(replica);
            crudRequest.getProperties().setUseNative(Boolean.TRUE);
        }
        if ((sid = (String)params.getFirst((Object)"id")) != null) {
            Object id = CrudHelper0.idFromString(entityInfo, sid);
            if (id != null) {
                crudRequest.setIds(new ArrayList<Object>());
                crudRequest.getIds().add(id);
            }
        } else {
            List sids = (List)params.get((Object)"ids");
            if (sids != null) {
                crudRequest.setIds(new ArrayList<Object>());
                for (String cid : sids) {
                    Object object = CrudHelper0.idFromString(entityInfo, cid);
                    if (object == null) continue;
                    crudRequest.getIds().add(object);
                }
            }
        }
        String smap = (String)params.getFirst((Object)"map");
        if (smap != null) {
            String[] ss;
            CrudRequest.MapConfig map = new CrudRequest.MapConfig();
            for (String s : ss = smap.split("~~")) {
                int idx = s.indexOf(":");
                if (idx == -1) continue;
                String key = s.substring(0, idx).trim();
                String str = s.substring(idx + 1);
                if ("key".equals(key)) {
                    map.setKeys(new ArrayList<String>());
                    map.getKeys().add(str);
                    continue;
                }
                if ("keys".equals(key)) {
                    map.setKeys(CrudHelper0.stringToList(str));
                    continue;
                }
                if (!"flat".equals(key)) continue;
                String lcase = str.trim().toLowerCase();
                map.setFlat(!"0".equals(lcase) && !"false".equals(lcase));
            }
        }
        if ((page = (String)params.getFirst((Object)"page")) != null) {
            crudRequest.setPage(CrudHelper0.stringToPage(page));
        } else {
            String string2;
            String string3;
            String start = (String)params.getFirst((Object)"start");
            if (start != null && !(start = start.trim()).isEmpty()) {
                crudRequest.setStart(Integer.valueOf(start));
            }
            if ((string3 = (String)params.getFirst((Object)"limit")) != null && !(string2 = string3.trim()).isEmpty()) {
                crudRequest.setLimit(Integer.valueOf(string2));
            }
        }
        crudRequest.setFilters(CrudHelper0.stringToFilters((String)params.getFirst((Object)"filters")));
        crudRequest.setOrders(CrudHelper0.stringToList((String)params.getFirst((Object)"orders")));
        crudRequest.setFields(CrudHelper0.stringToList((String)params.getFirst((Object)"fields")));
        if (!Boolean.FALSE.equals(crudRequest.getProperties().getEnableLoad())) {
            crudRequest.setLoads(CrudHelper0.stringToList((String)params.getFirst((Object)"loads")));
        }
        MapStringObject value = CrudHelper0.stringToMap((String)params.getFirst((Object)"value"));
        crudRequest.setValues(new ArrayList<MapStringObject>());
        crudRequest.getValues().add(value);
        return crudRequest;
    }
}

