/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.crud;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.List;
import net.ideahut.springboot.crud.CrudHelper0;
import net.ideahut.springboot.crud.CrudProperties;
import net.ideahut.springboot.crud.Filter;
import net.ideahut.springboot.crud.Join;
import net.ideahut.springboot.crud.Stack;
import net.ideahut.springboot.entity.EntityIdType;
import net.ideahut.springboot.entity.EntityInfo;
import net.ideahut.springboot.entity.FieldInfo;
import net.ideahut.springboot.entity.IdInfo;
import net.ideahut.springboot.object.MapStringObject;
import net.ideahut.springboot.object.Page;
import org.springframework.util.Assert;

public class CrudRequest {
    private String manager;
    private String name;
    private Integer replica;
    private List<Object> ids;
    private MapConfig map;
    private Page page;
    private Integer start;
    private Integer limit;
    private List<Filter> filters;
    private List<String> orders;
    private List<String> fields;
    private List<String> loads;
    private List<MapStringObject> values;
    private List<Join> joins;
    private List<Stack> stacks;
    @JsonIgnore
    private CrudProperties properties;
    @JsonIgnore
    private List<Filter> spesifics;

    private CrudRequest() {
    }

    public CrudRequest setManager(String manager) {
        this.manager = manager;
        return this;
    }

    public CrudRequest setName(String name) {
        this.name = name;
        return this;
    }

    public CrudRequest setReplica(Integer replica) {
        this.replica = replica;
        return this;
    }

    public CrudRequest setIds(List<Object> ids) {
        this.ids = ids;
        return this;
    }

    protected CrudRequest setMap(MapConfig map) {
        this.map = map;
        return this;
    }

    public CrudRequest setPage(Page page) {
        this.page = page;
        return this;
    }

    public CrudRequest setStart(Integer start) {
        this.start = start;
        return this;
    }

    public CrudRequest setLimit(Integer limit) {
        this.limit = limit;
        return this;
    }

    public CrudRequest setFilters(List<Filter> filters) {
        this.filters = filters;
        return this;
    }

    public CrudRequest setOrders(List<String> orders) {
        this.orders = orders;
        return this;
    }

    public CrudRequest setFields(List<String> fields) {
        this.fields = fields;
        return this;
    }

    public CrudRequest setLoads(List<String> loads) {
        this.loads = loads;
        return this;
    }

    public CrudRequest setValues(List<MapStringObject> values) {
        this.values = values;
        return this;
    }

    public CrudRequest setJoins(List<Join> joins) {
        this.joins = joins;
        return this;
    }

    public CrudRequest setStacks(List<Stack> stacks) {
        this.stacks = stacks;
        return this;
    }

    public CrudRequest setSpesifics(List<Filter> spesifics) {
        this.spesifics = spesifics;
        return this;
    }

    protected CrudRequest setProperties(CrudProperties properties) {
        this.properties = properties;
        return this;
    }

    public static CrudRequest of(EntityInfo entityInfo) {
        Assert.notNull((Object)entityInfo, (String)"EntityInfo is required");
        CrudProperties properties = new CrudProperties();
        properties.setEntityInfo(entityInfo);
        properties.setClassName(entityInfo.getEntityClass().getName());
        properties.setManagerName(entityInfo.getTrxManagerInfo().getName());
        return new CrudRequest().setProperties(properties);
    }

    public static CrudRequest of(CrudProperties properties) {
        Assert.notNull((Object)properties, (String)"CrudProperties is required");
        return new CrudRequest().setProperties(properties);
    }

    static CrudRequest of(String name) {
        Assert.hasLength((String)name, (String)"Name is required");
        return new CrudRequest().setName(name).setProperties(new CrudProperties());
    }

    public static CrudRequest copy(CrudRequest input) {
        CrudRequest request;
        block9: {
            request = CrudHelper0.copy(input, CrudRequest.class);
            EntityInfo entityInfo = null;
            if (input.getProperties() != null) {
                entityInfo = input.getProperties().getEntityInfo();
                CrudProperties properties = CrudHelper0.copy(input.getProperties(), CrudProperties.class);
                properties.setEntityInfo(entityInfo);
                request.setProperties(properties);
            }
            if (request.getJoins() != null) {
                for (int i = 0; i < request.getJoins().size(); ++i) {
                    request.getJoins().get(i).setEntityInfo(input.getJoins().get(i).getEntityInfo());
                }
            }
            if (request.getStacks() != null) {
                for (int i = 0; i < request.getStacks().size(); ++i) {
                    Stack stack = request.getStacks().get(i);
                    stack.setEntityInfo(input.getStacks().get(i).getEntityInfo());
                }
            }
            if (request.getIds() == null || entityInfo == null) break block9;
            IdInfo idInfo = entityInfo.getIdInfo();
            if (EntityIdType.COMPOSITE.equals((Object)idInfo.getIdType())) {
                for (int i = 0; i < request.getIds().size(); ++i) {
                    request.getIds().set(i, CrudHelper0.convert(request.getIds().get(i), entityInfo.getEntityClass()));
                }
            } else {
                FieldInfo fieldInfo = entityInfo.getFieldInfo(idInfo.getFields().iterator().next());
                for (int i = 0; i < request.getIds().size(); ++i) {
                    request.getIds().set(i, CrudHelper0.convert(request.getIds().get(i), fieldInfo.getType()));
                }
            }
        }
        return request;
    }

    public String getManager() {
        return this.manager;
    }

    public String getName() {
        return this.name;
    }

    public Integer getReplica() {
        return this.replica;
    }

    public List<Object> getIds() {
        return this.ids;
    }

    public MapConfig getMap() {
        return this.map;
    }

    public Page getPage() {
        return this.page;
    }

    public Integer getStart() {
        return this.start;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public List<Filter> getFilters() {
        return this.filters;
    }

    public List<String> getOrders() {
        return this.orders;
    }

    public List<String> getFields() {
        return this.fields;
    }

    public List<String> getLoads() {
        return this.loads;
    }

    public List<MapStringObject> getValues() {
        return this.values;
    }

    public List<Join> getJoins() {
        return this.joins;
    }

    public List<Stack> getStacks() {
        return this.stacks;
    }

    public CrudProperties getProperties() {
        return this.properties;
    }

    public List<Filter> getSpesifics() {
        return this.spesifics;
    }

    public static final class MapConfig {
        private List<String> keys;
        private Boolean flat;

        public void setKeys(List<String> keys) {
            this.keys = keys;
        }

        public void setFlat(Boolean flat) {
            this.flat = flat;
        }

        public List<String> getKeys() {
            return this.keys;
        }

        public Boolean getFlat() {
            return this.flat;
        }
    }
}

