/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.crud;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.JsonNode;
import java.util.Iterator;
import java.util.List;
import net.ideahut.springboot.crud.CrudHelper0;
import net.ideahut.springboot.crud.CrudRequest;
import net.ideahut.springboot.crud.Join;
import net.ideahut.springboot.entity.EntityIdType;
import net.ideahut.springboot.entity.EntityInfo;
import net.ideahut.springboot.entity.FieldInfo;
import net.ideahut.springboot.entity.IdInfo;
import net.ideahut.springboot.object.MapStringObject;
import net.ideahut.springboot.object.Page;
import org.springframework.util.Assert;

final class CrudSelect0 {
    private CrudSelect0() {
    }

    static MapStringObject listToMap(List<?> data, EntityInfo entityInfo, CrudRequest crudRequest) {
        MapStringObject map;
        block10: {
            map = new MapStringObject();
            if (data == null) break block10;
            CrudRequest.MapConfig cfg = crudRequest.getMap();
            cfg = cfg != null ? cfg : new CrudRequest.MapConfig();
            boolean flat = !Boolean.FALSE.equals(cfg.getFlat());
            List<String> keys = cfg.getKeys();
            if (keys != null && !keys.isEmpty()) {
                if (flat) {
                    while (!data.isEmpty()) {
                        Object entity = data.remove(0);
                        MapStringObject item = CrudSelect0.entityToMap(entityInfo, entity, keys);
                        JsonNode node = CrudHelper0.convert(item, JsonNode.class);
                        String key = CrudSelect0.nodeToKey(node);
                        CrudSelect0.addEntityToMap(map, key, entity);
                    }
                } else {
                    while (!data.isEmpty()) {
                        Object entity = data.remove(0);
                        MapStringObject key = CrudSelect0.entityToMap(entityInfo, entity, keys);
                        CrudSelect0.addEntityToMap(map, CrudHelper0.writeAsString(key), entity);
                    }
                }
            } else if (flat) {
                while (!data.isEmpty()) {
                    Object entity = data.remove(0);
                    Object id = CrudSelect0.getId(entityInfo, entity);
                    JsonNode node = CrudHelper0.convert(id, JsonNode.class);
                    String key = CrudSelect0.nodeToKey(node);
                    CrudSelect0.addEntityToMap(map, key, entity);
                }
            } else {
                while (!data.isEmpty()) {
                    Object entity = data.remove(0);
                    Object id = CrudSelect0.getId(entityInfo, entity);
                    JsonNode node = CrudHelper0.convert(id, JsonNode.class);
                    String key = node.isContainerNode() ? CrudHelper0.writeAsString(node) : node.asText();
                    CrudSelect0.addEntityToMap(map, key, entity);
                }
            }
        }
        return map;
    }

    private static void addEntityToMap(MapStringObject map, String key, Object entity) {
        if (map.containsKey((Object)key)) {
            throw new RuntimeException("Duplicate key");
        }
        map.put((Object)key, entity);
    }

    private static MapStringObject entityToMap(EntityInfo entityInfo, Object entity, List<String> keys) {
        try {
            MapStringObject map = new MapStringObject();
            for (String key : keys) {
                FieldInfo fieldInfo = entityInfo.getFieldInfo(key);
                Assert.notNull((Object)fieldInfo, (String)("Field is not found, for: " + key));
                Object value = fieldInfo.getValue(entity);
                map.put((Object)key, value);
            }
            return map;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static String nodeToKey(JsonNode node) {
        Object str = "";
        if (node.isContainerNode()) {
            Iterator iter = node.fieldNames();
            while (iter.hasNext()) {
                String fname = (String)iter.next();
                str = (String)str + "~~" + fname + ":" + CrudSelect0.nodeToKey(node.get(fname));
            }
            str = ((String)str).substring("~~".length());
        } else {
            str = node.asText();
        }
        return str;
    }

    private static Object getId(EntityInfo entityInfo, Object entity) {
        if (entity != null && entity.getClass().equals(entityInfo.getEntityClass())) {
            try {
                Object idValue = null;
                IdInfo idInfo = entityInfo.getIdInfo();
                if (EntityIdType.COMPOSITE.equals((Object)idInfo.getIdType())) {
                    MapStringObject cid = new MapStringObject();
                    for (String field : idInfo.getFields()) {
                        FieldInfo fieldInfo = entityInfo.getFieldInfo(field);
                        cid.put((Object)field, fieldInfo.getValue(entity));
                    }
                    idValue = cid;
                } else {
                    idValue = entityInfo.getFieldInfo(idInfo.getFields().iterator().next()).getValue(entity);
                }
                return idValue;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    static class StartLimit {
        private final Integer start;
        private final Integer limit;
        private final Integer index;

        protected StartLimit() {
            this(null, null, null);
        }

        private StartLimit(Integer start, Integer limit, Integer index) {
            this.start = start;
            this.limit = limit;
            this.index = index;
        }

        static StartLimit of(Integer start, Integer limit, Page page, Integer maxLimit) {
            Integer iStart;
            Integer iIndex;
            Integer iLimit;
            Integer iMax = maxLimit != null && maxLimit > 0 ? maxLimit : 100;
            Page iPage = page;
            if (iPage != null) {
                iLimit = iPage.getSize();
                Integer n = iLimit = iLimit != null && iLimit > 0 ? iLimit : Page.DEFAULT_PAGE_SIZE;
                if (iLimit > iMax) {
                    iLimit = iMax;
                }
                if ((iIndex = iPage.getIndex()) == null || iIndex < 1) {
                    iIndex = 1;
                }
                iStart = (iIndex - 1) * iLimit;
            } else {
                iStart = start != null && start >= 0 ? start : 0;
                Integer n = iLimit = limit != null && limit > 0 ? limit : Page.DEFAULT_PAGE_SIZE;
                if (iLimit > iMax) {
                    iLimit = iMax;
                }
                iIndex = iStart / iLimit + 1;
            }
            return new StartLimit(iStart, iLimit, iIndex);
        }

        static StartLimit of(Integer start, Integer limit, Integer maxLimit) {
            return StartLimit.of(start, limit, null, maxLimit);
        }

        static StartLimit of(Page page, Integer maxLimit) {
            return StartLimit.of(null, null, page, maxLimit);
        }

        static StartLimit of(CrudRequest crudRequest, Integer maxLimit) {
            return StartLimit.of(crudRequest.getStart(), crudRequest.getLimit(), crudRequest.getPage(), maxLimit);
        }

        public Integer getStart() {
            return this.start;
        }

        public Integer getLimit() {
            return this.limit;
        }

        public Integer getIndex() {
            return this.index;
        }
    }

    static class Ql {
        private String select = "";
        private String from = "";
        private String where = "";
        private String order = "";

        Ql() {
        }

        public String getSelect() {
            return this.select;
        }

        public String getFrom() {
            return this.from;
        }

        public String getWhere() {
            return this.where;
        }

        public String getOrder() {
            return this.order;
        }

        public void setSelect(String select) {
            this.select = select;
        }

        public void setFrom(String from) {
            this.from = from;
        }

        public void setWhere(String where) {
            this.where = where;
        }

        public void setOrder(String order) {
            this.order = order;
        }
    }

    static class SelectJoin {
        @JsonIgnore
        private EntityInfo entityInfo;
        private String alias;
        private Join join;

        SelectJoin() {
        }

        static SelectJoin of(EntityInfo entityInfo, String alias, Join join) {
            SelectJoin selectJoin = new SelectJoin();
            selectJoin.entityInfo = entityInfo;
            selectJoin.alias = alias;
            selectJoin.join = join;
            return selectJoin;
        }

        public EntityInfo getEntityInfo() {
            return this.entityInfo;
        }

        public String getAlias() {
            return this.alias;
        }

        public Join getJoin() {
            return this.join;
        }

        @JsonIgnore
        public void setEntityInfo(EntityInfo entityInfo) {
            this.entityInfo = entityInfo;
        }

        public void setAlias(String alias) {
            this.alias = alias;
        }

        public void setJoin(Join join) {
            this.join = join;
        }
    }
}

