/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.crud;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.ideahut.springboot.converter.Converter;
import net.ideahut.springboot.crud.Condition;
import net.ideahut.springboot.crud.CrudHelper0;
import net.ideahut.springboot.crud.CrudRequest;
import net.ideahut.springboot.crud.CrudSelect0;
import net.ideahut.springboot.crud.DepreHelper;
import net.ideahut.springboot.crud.Filter;
import net.ideahut.springboot.entity.EntityHelper;
import net.ideahut.springboot.entity.EntityIdType;
import net.ideahut.springboot.entity.EntityInfo;
import net.ideahut.springboot.entity.EntityNative;
import net.ideahut.springboot.entity.FieldInfo;
import net.ideahut.springboot.entity.IdInfo;
import net.ideahut.springboot.entity.SessionCallable;
import net.ideahut.springboot.entity.TrxManagerInfo;
import net.ideahut.springboot.util.FrameworkUtil;
import org.hibernate.Session;
import org.hibernate.query.Query;
import org.springframework.util.Assert;

final class CrudSelectEntity0 {
    private CrudSelectEntity0() {
    }

    static Object valueOf(EntityNative.Select select, Object[] data) throws Exception {
        if (select.getFields().isEmpty()) {
            return data[select.getIndex()];
        }
        Object object = select.getEntityInfo().createEntity();
        int i = select.getIndex();
        for (FieldInfo field : select.getFields()) {
            Object value = data[i];
            if (value != null) {
                if (Converter.isEntity(field.getConverter())) {
                    if (field.getType().isAssignableFrom(value.getClass())) {
                        field.setValue(object, value);
                    }
                } else {
                    Object fconv = field.convert(value);
                    field.setValue(object, fconv);
                }
            }
            ++i;
        }
        return object;
    }

    static List<Object> entitesOf(List rows, EntityInfo entityInfo, List<EntityNative.Select> selects, List<String> load) throws Exception {
        boolean isSame;
        TrxManagerInfo trxManagerInfo = entityInfo.getTrxManagerInfo();
        boolean bl = isSame = !rows.isEmpty() && rows.get(0).getClass().equals(entityInfo.getEntityClass());
        if (!isSame) {
            ArrayList<Object> entities = new ArrayList<Object>();
            while (!rows.isEmpty()) {
                Object row = rows.remove(0);
                Object[] item = row.getClass().isArray() ? (Object[])row : new Object[]{row};
                EntityNative.Select select = selects.get(0);
                Object entity = CrudSelectEntity0.valueOf(select, item);
                trxManagerInfo.loadLazy(entity, entityInfo.getEntityClass(), load);
                for (int i = 1; i < selects.size(); ++i) {
                    select = selects.get(i);
                    if (select.getStore() == null) continue;
                    Object child = CrudSelectEntity0.valueOf(select, item);
                    trxManagerInfo.loadLazy(child, select.getEntityInfo().getEntityClass());
                    select.getStore().setValue(entity, child);
                }
                entities.add(entity);
            }
            return entities;
        }
        trxManagerInfo.loadLazy(rows, entityInfo.getEntityClass(), load);
        return rows;
    }

    static void orderOf(List<String> orders, CrudSelect0.Ql hql, String alias, Map<String, CrudSelect0.SelectJoin> selectJoins) {
        if (orders != null && !orders.isEmpty()) {
            StringBuilder orderQL = new StringBuilder();
            for (String order : orders) {
                int idx;
                boolean asc = true;
                if (order.startsWith("-")) {
                    asc = false;
                    order = order.substring(1);
                }
                if ((idx = order.indexOf(".")) != -1) {
                    CrudSelect0.SelectJoin selectJoin = CrudSelectEntity0.orderJoin(selectJoins, order);
                    if (selectJoin != null) {
                        orderQL.append(selectJoin.getAlias()).append(order.substring(selectJoin.getJoin().getName().length()));
                    } else {
                        orderQL.append(EntityHelper.aliasField(alias, order));
                    }
                } else {
                    orderQL.append(EntityHelper.aliasField(alias, order));
                }
                orderQL.append(" ").append(asc ? "asc" : "desc").append(",");
            }
            if (orderQL.length() != 0) {
                orderQL.deleteCharAt(orderQL.length() - 1);
                hql.setOrder("order by " + orderQL.toString());
            }
        }
    }

    private static CrudSelect0.SelectJoin orderJoin(Map<String, CrudSelect0.SelectJoin> selectJoins, String order) {
        if (selectJoins != null && !selectJoins.isEmpty()) {
            for (Map.Entry<String, CrudSelect0.SelectJoin> entry : selectJoins.entrySet()) {
                if (!order.startsWith(entry.getKey())) continue;
                return entry.getValue();
            }
        }
        return null;
    }

    static List queryOf(final EntityInfo entityInfo, final List<EntityNative.Select> selects, final CrudSelect0.Ql hql, final List<Object> parameters, final CrudSelect0.StartLimit startLimit, final List<String> load) {
        TrxManagerInfo trxManagerInfo = entityInfo.getTrxManagerInfo();
        return trxManagerInfo.transaction(new SessionCallable<List>(){

            @Override
            public List call(Session session) throws Exception {
                Query query = DepreHelper.createQuery(session, hql.getSelect() + " " + hql.getFrom() + " " + hql.getWhere() + " " + hql.getOrder());
                for (int i = 0; i < parameters.size(); ++i) {
                    query.setParameter(i + 1, parameters.get(i));
                }
                query.setFirstResult(startLimit.getStart().intValue());
                query.setMaxResults(startLimit.getLimit().intValue());
                List rows = query.getResultList();
                return CrudSelectEntity0.entitesOf(rows, entityInfo, selects, load);
            }
        });
    }

    static String inIds(List<Object> ids, EntityInfo entityInfo, String alias, List<Object> parameters, Integer startIndex) {
        return EntityHelper.generateInIdsQuery(ids, entityInfo, alias, parameters, startIndex);
    }

    static void filter(Filter filter, EntityInfo entityInfo, String alias, CrudSelect0.Ql hql, List<Object> parameters, Map<String, CrudSelect0.SelectJoin> selectJoins) {
        String logic = " " + filter.getLogical().name().toLowerCase();
        StringBuilder query = new StringBuilder(hql.getWhere());
        if (filter.getFilters() != null && !filter.getFilters().isEmpty()) {
            query.append(" ").append(logic).append(" (1=1 ");
            for (Filter child : filter.getFilters()) {
                hql.setWhere(query.toString());
                CrudSelectEntity0.filter(child, entityInfo, alias, hql, parameters, selectJoins);
                query = new StringBuilder(hql.getWhere());
            }
            query.append(") ");
            hql.setWhere(query.toString());
            return;
        }
        Assert.notNull((Object)filter.getField(), (String)"Filter field is required");
        EntityInfo infoEntity = entityInfo;
        String idql = "";
        String field = filter.getField();
        int idx = field.indexOf(".");
        if (idx != -1) {
            String fnam = field.substring(0, idx);
            CrudSelect0.SelectJoin selectJoin = selectJoins.get(fnam);
            if (selectJoin != null) {
                infoEntity = selectJoin.getJoin().getEntityInfo();
                idql = EntityHelper.aliasField(selectJoin.getAlias(), field.substring(idx + 1));
                field = field.substring(idx + 1);
            } else {
                idql = EntityHelper.aliasField(alias, field);
            }
        } else {
            idql = EntityHelper.aliasField(alias, field);
        }
        Condition condition = filter.getCondition();
        ArrayList<Object> lvals = new ArrayList<Object>();
        if (filter.getValues() != null) {
            FieldInfo fieldInfo = EntityHelper.getFieldInfo(infoEntity, field);
            if (condition.isConvert() && fieldInfo != null && fieldInfo.getConverter() != null) {
                for (Object ivalue : filter.getValues()) {
                    Object ovalue = fieldInfo.getConverter().convert(ivalue);
                    lvals.add(ovalue);
                }
            } else {
                for (Object ivalue : filter.getValues()) {
                    lvals.add(ivalue);
                }
            }
        }
        try {
            Condition.QueryParameters queryAndParameters = condition.getBuilder().build(false, logic, parameters.size(), idql, lvals.toArray());
            query.append(queryAndParameters.getQuery());
            parameters.addAll(queryAndParameters.getParameters());
            hql.setWhere(query.toString());
        }
        catch (Exception e) {
            throw FrameworkUtil.exception("Invalid filter: " + CrudHelper0.writeAsString(filter));
        }
    }

    static Object single(EntityInfo entityInfo, String alias, CrudRequest crudRequest, List<EntityNative.Select> selects, CrudSelect0.Ql hql, List<Object> parameters, Map<String, CrudSelect0.SelectJoin> selectJoins, boolean unique) {
        Object idValue;
        Object entity = null;
        Object object = idValue = crudRequest.getIds() != null && !crudRequest.getIds().isEmpty() ? crudRequest.getIds().get(0) : null;
        if (idValue != null) {
            IdInfo idInfo = entityInfo.getIdInfo();
            if (EntityIdType.COMPOSITE == idInfo.getIdType()) {
                try {
                    for (String name : idInfo.getFields()) {
                        FieldInfo fieldInfo = entityInfo.getFieldInfo(name);
                        CrudSelectEntity0.filter(Filter.and((String)name, (Condition)Condition.EQUAL, (Object[])new Object[]{fieldInfo.getValue(idValue)}), entityInfo, alias, hql, parameters, selectJoins);
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            } else {
                CrudSelectEntity0.filter(Filter.and((String)idInfo.getFields().iterator().next(), (Condition)Condition.EQUAL, (Object[])new Object[]{idValue}), entityInfo, alias, hql, parameters, selectJoins);
            }
            List data = CrudSelectEntity0.queryOf(entityInfo, selects, hql, parameters, CrudSelect0.StartLimit.of(0, 2, 2), crudRequest.getLoads());
            if (data != null && !data.isEmpty()) {
                if (unique && data.size() > 1) {
                    throw FrameworkUtil.exception("Multiple data result");
                }
                entity = data.get(0);
            }
        } else {
            Object data;
            CrudSelectEntity0.orderOf(crudRequest.getOrders(), hql, alias, selectJoins);
            List<Filter> filters = crudRequest.getFilters();
            if (filters != null && !filters.isEmpty()) {
                data = filters.iterator();
                while (data.hasNext()) {
                    Filter filter = data.next();
                    CrudSelectEntity0.filter(filter, entityInfo, alias, hql, parameters, selectJoins);
                }
            }
            if ((data = CrudSelectEntity0.queryOf(entityInfo, selects, hql, parameters, CrudSelect0.StartLimit.of(0, 2, 2), crudRequest.getLoads())) != null && !data.isEmpty()) {
                if (unique && data.size() > 1) {
                    throw FrameworkUtil.exception("Multiple data result");
                }
                entity = data.get(0);
            }
        }
        return entity;
    }
}

