/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.crud;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.ideahut.springboot.crud.CrudHelper0;
import net.ideahut.springboot.crud.CrudRequest;
import net.ideahut.springboot.crud.CrudResult;
import net.ideahut.springboot.crud.CrudSelect;
import net.ideahut.springboot.crud.CrudSelect0;
import net.ideahut.springboot.crud.CrudSelectNative0;
import net.ideahut.springboot.crud.Filter;
import net.ideahut.springboot.crud.Join;
import net.ideahut.springboot.crud.Relation;
import net.ideahut.springboot.entity.AttributeOverrides;
import net.ideahut.springboot.entity.EntityInfo;
import net.ideahut.springboot.entity.EntityNative;
import net.ideahut.springboot.entity.EntitySoftDelete;
import net.ideahut.springboot.entity.FieldInfo;
import net.ideahut.springboot.entity.SessionCallable;
import net.ideahut.springboot.entity.TrxManagerInfo;
import net.ideahut.springboot.object.MapStringObject;
import net.ideahut.springboot.object.Page;
import org.hibernate.Session;
import org.hibernate.SharedSessionContract;
import org.hibernate.query.Query;
import org.hibernate.type.Type;
import org.springframework.util.Assert;

final class CrudSelectNative
implements CrudSelect {
    private EntityInfo entityInfo;
    private String alias;
    private List<EntityNative.Select> selects;
    private Integer maxLimit = 100;
    private CrudRequest crudRequest;
    private CrudSelect0.Ql sql;
    private List<EntityNative.Parameter> parameters;
    private Map<String, CrudSelect0.SelectJoin> selectJoins;

    protected CrudSelectNative() {
    }

    @Override
    public void destroy() {
        this.entityInfo = null;
        this.alias = null;
        this.selects = null;
        this.maxLimit = null;
        this.crudRequest = null;
        this.sql = null;
        this.parameters = null;
        this.selectJoins = null;
    }

    static CrudSelectNative of(CrudRequest crudRequest) {
        boolean isSoftDelete;
        CrudSelectNative crudSelect = new CrudSelectNative();
        crudSelect.crudRequest = crudRequest;
        crudSelect.entityInfo = crudRequest.getProperties().getEntityInfo();
        crudSelect.selects = new ArrayList<EntityNative.Select>();
        crudSelect.sql = new CrudSelect0.Ql();
        ArrayList<EntityNative.Parameter> parameters = new ArrayList<EntityNative.Parameter>();
        Integer maxLimit = crudRequest.getProperties().getMaxLimit();
        if (maxLimit != null && maxLimit > 0) {
            crudSelect.maxLimit = maxLimit;
        }
        StringBuilder fromQl = new StringBuilder("from ").append(EntityNative.tableReplica(crudSelect.entityInfo, crudRequest.getReplica())).append(" ");
        HashMap<String, CrudSelect0.SelectJoin> selectJoins = new HashMap<String, CrudSelect0.SelectJoin>();
        List<Join> cjoins = crudRequest.getJoins();
        boolean hasJoin = cjoins != null && !cjoins.isEmpty();
        crudSelect.alias = hasJoin ? "a0" : "";
        int idxSelect = 0;
        StringBuilder selectQl = new StringBuilder();
        List<String> selFields = crudRequest.getFields();
        if (selFields != null && !selFields.isEmpty()) {
            select = EntityNative.Select.of(crudSelect.entityInfo, idxSelect, null);
            for (String string : selFields) {
                fieldInfo = select.getEntityInfo().getFieldInfo(string);
                Assert.notNull((Object)fieldInfo, (String)("Unknown field: " + select.getEntityInfo().getEntityClass().getSimpleName() + "." + string));
                idxSelect = EntityNative.appendSelect(fieldInfo, select, selectQl, crudSelect.alias, idxSelect, false);
            }
            crudSelect.selects.add(select);
            selectQl = new StringBuilder("select ").append((CharSequence)selectQl.deleteCharAt(selectQl.length() - 1));
        } else {
            select = EntityNative.Select.of(crudSelect.entityInfo, idxSelect, null);
            for (String string : select.getEntityInfo().getFieldInfoNames()) {
                fieldInfo = select.getEntityInfo().getFieldInfo(string);
                idxSelect = EntityNative.appendSelect(fieldInfo, select, selectQl, crudSelect.alias, idxSelect, false);
            }
            crudSelect.selects.add(select);
            selectQl = new StringBuilder("select ").append((CharSequence)selectQl.deleteCharAt(selectQl.length() - 1));
        }
        EntityInfo sourceEntityInfo = crudSelect.entityInfo;
        if (hasJoin) {
            fromQl.append(crudSelect.alias).append(" ");
            int i = 1;
            for (Join cjoin : cjoins) {
                EntityInfo targetEntityInfo = cjoin.getEntityInfo();
                String joinAlias = "a" + i;
                fromQl.append(cjoin.getMatch().getJoin()).append(" join ").append(EntityNative.tableReplica(targetEntityInfo, cjoin.getReplica())).append(" ").append(joinAlias).append(" on ");
                List<Relation> crelations = cjoin.getRelations();
                for (Relation crelation : crelations) {
                    FieldInfo jcInfo;
                    AttributeOverrides attributeOverrides;
                    String targetColumn = null;
                    Type targetType = null;
                    boolean hasJoined = false;
                    int idx = crelation.getTarget().indexOf(".");
                    if (idx != -1) {
                        boolean found = false;
                        FieldInfo parentFieldInfo = targetEntityInfo.getFieldInfo(crelation.getTarget().substring(0, idx));
                        if (parentFieldInfo.hasAttributeOverrides()) {
                            attributeOverrides = parentFieldInfo.getAttributeOverrides();
                            for (String string : attributeOverrides.getColums()) {
                                jcInfo = attributeOverrides.getFieldInfo(string);
                                if (!crelation.getTarget().substring(idx + 1).equals(jcInfo.getName())) continue;
                                targetColumn = jcInfo.getColumn().getName();
                                targetType = jcInfo.getHibernateType();
                                found = true;
                                break;
                            }
                        }
                        if (!found) {
                            EntityInfo childEntityInfo = targetEntityInfo.getTrxManagerInfo().getEntityInfo(parentFieldInfo.getType());
                            Assert.notNull((Object)childEntityInfo, (String)("Invalid Join relation target, 1, name: " + cjoin.getName() + ", relation: " + CrudHelper0.writeAsString(crelation)));
                            FieldInfo fieldInfo = childEntityInfo.getFieldInfo(crelation.getTarget().substring(idx + 1));
                            Assert.notNull((Object)fieldInfo, (String)("Invalid Join relation target, 2, name: " + cjoin.getName() + ", relation: " + CrudHelper0.writeAsString(crelation)));
                            targetColumn = fieldInfo.getColumn().getName();
                            targetType = fieldInfo.getHibernateType();
                        }
                    } else {
                        FieldInfo targetFieldInfo = targetEntityInfo.getFieldInfo(crelation.getTarget());
                        if (targetFieldInfo.hasAttributeOverrides()) {
                            Assert.isTrue((crelation.getSource() != null ? 1 : 0) != 0, (String)("Invalid Join relation target, 3, name: " + cjoin.getName() + ", relation: " + CrudHelper0.writeAsString(crelation)));
                            String name1 = crelation.getSource();
                            Object name2 = "";
                            idx = name1.indexOf(".");
                            if (idx != -1) {
                                name2 = name1.substring(idx + 1);
                                name1 = name1.substring(0, idx);
                            }
                            if (!((String)name2).isEmpty()) {
                                Assert.isTrue((boolean)((String)name2).equals(sourceEntityInfo.getIdInfo().getFields().iterator().next()), (String)("Invalid Join relation target, 4, name: " + cjoin.getName() + ", relation: " + CrudHelper0.writeAsString(crelation)));
                            }
                            FieldInfo fieldInfo = sourceEntityInfo.getFieldInfo(name1);
                            Assert.isTrue((boolean)fieldInfo.hasJoinColumns(), (String)("Invalid Join relation target, 5, name: " + cjoin.getName() + ", relation: " + CrudHelper0.writeAsString(crelation)));
                            for (Map.Entry<String, String> entry : fieldInfo.getJoinColumns().getRelations().entrySet()) {
                                CrudSelectNative.appendJoinQl(fromQl, joinAlias, entry.getValue(), crudSelect.alias, entry.getKey());
                            }
                            hasJoined = true;
                        } else {
                            targetColumn = targetFieldInfo.getColumn().getName();
                            targetType = targetFieldInfo.getHibernateType();
                        }
                    }
                    if (hasJoined) continue;
                    if (crelation.getSource() != null) {
                        idx = crelation.getSource().indexOf(".");
                        if (idx != -1) {
                            boolean found = false;
                            FieldInfo cSrInfo = sourceEntityInfo.getFieldInfo(crelation.getSource().substring(0, idx));
                            Assert.notNull((Object)cSrInfo, (String)("Invalid Join relation source, 1, name: " + cjoin.getName() + ", relation: " + CrudHelper0.writeAsString(crelation)));
                            if (cSrInfo.hasJoinRelations()) {
                                for (Map.Entry entry : cSrInfo.getJoinColumns().getRelations().entrySet()) {
                                    FieldInfo fieldInfo = cSrInfo.getJoinColumns().getFieldInfo((String)entry.getKey());
                                    if (!crelation.getSource().substring(idx + 1).equals(fieldInfo.getName())) continue;
                                    CrudSelectNative.appendJoinQl(fromQl, joinAlias, (String)entry.getValue(), crudSelect.alias, (String)entry.getKey());
                                    found = true;
                                    break;
                                }
                            } else if (cSrInfo.hasAttributeOverrides()) {
                                attributeOverrides = cSrInfo.getAttributeOverrides();
                                for (String string : attributeOverrides.getColums()) {
                                    jcInfo = attributeOverrides.getFieldInfo(string);
                                    if (!crelation.getSource().substring(idx + 1).equals(jcInfo.getName())) continue;
                                    CrudSelectNative.appendJoinQl(fromQl, joinAlias, targetColumn, crudSelect.alias, string);
                                    found = true;
                                    break;
                                }
                            }
                            if (found) continue;
                            EntityInfo eSrInfo = sourceEntityInfo.getTrxManagerInfo().getEntityInfo(cSrInfo.getType());
                            FieldInfo fieldInfo = eSrInfo.getFieldInfo(crelation.getSource().substring(idx + 1));
                            Assert.notNull((Object)fieldInfo, (String)("Invalid Join relation source, 2, name: " + cjoin.getName() + ", relation: " + CrudHelper0.writeAsString(crelation)));
                            Assert.isTrue((fieldInfo.getColumn() != null ? 1 : 0) != 0, (String)("Invalid Join relation source, 3, name: " + cjoin.getName() + ", relation: " + CrudHelper0.writeAsString(crelation)));
                            CrudSelectNative.appendJoinQl(fromQl, joinAlias, targetColumn, crudSelect.alias, fieldInfo.getColumn().getName());
                            continue;
                        }
                        FieldInfo cSrInfo = sourceEntityInfo.getFieldInfo(crelation.getSource());
                        if (cSrInfo.hasJoinRelations()) {
                            for (Map.Entry<String, String> entry : cSrInfo.getJoinColumns().getRelations().entrySet()) {
                                CrudSelectNative.appendJoinQl(fromQl, joinAlias, entry.getValue(), crudSelect.alias, entry.getKey());
                            }
                            continue;
                        }
                        Assert.isTrue((cSrInfo.getColumn() != null ? 1 : 0) != 0, (String)("Invalid Join relation source, 4, name: " + cjoin.getName() + ", relation: " + CrudHelper0.writeAsString(crelation)));
                        CrudSelectNative.appendJoinQl(fromQl, joinAlias, targetColumn, crudSelect.alias, cSrInfo.getColumn().getName());
                        continue;
                    }
                    if (targetColumn != null && targetType != null) {
                        fromQl.append(joinAlias).append(".").append(targetColumn).append("=?").append(parameters.size() + 1).append(" and ");
                        parameters.add(EntityNative.Parameter.of(targetType, crelation.getValue()));
                        continue;
                    }
                    Assert.isTrue((boolean)false, (String)("Invalid Join relation, name: " + cjoin.getName() + ", relation: " + CrudHelper0.writeAsString(crelation)));
                }
                fromQl.delete(fromQl.length() - 4, fromQl.length());
                if (Boolean.TRUE.equals(cjoin.getSelect())) {
                    FieldInfo store = sourceEntityInfo.getFieldInfo(cjoin.getStore());
                    if (store == null) {
                        store = sourceEntityInfo.getFieldTransient(cjoin.getStore());
                    }
                    Assert.notNull((Object)store, (String)("Unknown store field " + sourceEntityInfo.getEntityClass().getSimpleName() + "." + cjoin.getStore() + ", for join: " + cjoin.getName()));
                    if (cjoin.getFields() != null && !cjoin.getFields().isEmpty()) {
                        select = EntityNative.Select.of(targetEntityInfo, idxSelect, store);
                        for (String cfield : cjoin.getFields()) {
                            FieldInfo fjInfo = select.getEntityInfo().getFieldInfo(cfield);
                            Assert.notNull((Object)fjInfo, (String)("Unknown field: " + select.getEntityInfo().getEntityClass().getSimpleName() + "." + cfield));
                            idxSelect = EntityNative.appendSelect(fjInfo, select, selectQl, joinAlias, idxSelect, true);
                        }
                        crudSelect.selects.add(select);
                    } else {
                        select = EntityNative.Select.of(targetEntityInfo, idxSelect, store);
                        for (String cfield : select.getEntityInfo().getFieldInfoNames()) {
                            FieldInfo fjInfo = select.getEntityInfo().getFieldInfo(cfield);
                            idxSelect = EntityNative.appendSelect(fjInfo, select, selectQl, joinAlias, idxSelect, true);
                        }
                        crudSelect.selects.add(select);
                    }
                }
                selectJoins.put(cjoin.getName(), CrudSelect0.SelectJoin.of(targetEntityInfo, joinAlias, cjoin));
                ++i;
            }
        }
        crudSelect.sql.setSelect(selectQl.toString());
        crudSelect.sql.setFrom(fromQl.toString().trim());
        StringBuilder whereQl = new StringBuilder("where ");
        Boolean bl = EntitySoftDelete.isIgnore();
        boolean bl2 = isSoftDelete = EntitySoftDelete.class.isAssignableFrom(sourceEntityInfo.getEntityClass()) && (bl == null || !Boolean.TRUE.equals(bl));
        if (isSoftDelete) {
            whereQl.append(EntityNative.aliasColumn(crudSelect.alias, "deleted_on")).append(" is null ");
        } else {
            whereQl.append("1=1 ");
        }
        crudSelect.sql.setWhere(whereQl.toString());
        if (crudRequest.getSpesifics() != null) {
            for (Filter filter : crudRequest.getSpesifics()) {
                CrudSelectNative0.filter(filter, sourceEntityInfo, crudSelect.alias, crudSelect.sql, parameters, selectJoins);
            }
        }
        crudSelect.parameters = Collections.unmodifiableList(parameters);
        crudSelect.selectJoins = Collections.unmodifiableMap(selectJoins);
        return crudSelect;
    }

    private static void appendJoinQl(StringBuilder fromQl, String joinAlias, String joinColumn, String mainAlias, String mainColumn) {
        fromQl.append(joinAlias).append(".").append(joinColumn).append("=").append(mainAlias).append(".").append(mainColumn).append(" and ");
    }

    @Override
    public CrudResult page() {
        String inIds;
        final CrudRequest crudRequest = CrudRequest.copy(this.crudRequest);
        final CrudSelect0.Ql sql = CrudHelper0.copy(this.sql, CrudSelect0.Ql.class);
        final ArrayList<EntityNative.Parameter> parameters = new ArrayList<EntityNative.Parameter>(this.parameters);
        final CrudSelect0.StartLimit startLimit = CrudSelect0.StartLimit.of(crudRequest, this.maxLimit);
        Page page = crudRequest.getPage();
        if (page == null) {
            page = Page.empty();
        }
        page.setIndex(startLimit.getIndex());
        page.setSize(startLimit.getLimit());
        final Boolean count = page.getCount();
        List<Filter> filters = crudRequest.getFilters();
        if (filters != null && !filters.isEmpty()) {
            for (Filter filter : filters) {
                CrudSelectNative0.filter(filter, this.entityInfo, this.alias, sql, parameters, this.selectJoins);
            }
        }
        if (!(inIds = CrudSelectNative0.inIds(crudRequest.getIds(), this.entityInfo, this.alias, parameters, 1)).isEmpty()) {
            sql.setWhere(sql.getWhere() + " and " + inIds);
        }
        CrudSelectNative0.orderOf(this.entityInfo, crudRequest.getOrders(), sql, this.alias, this.selectJoins);
        TrxManagerInfo trxManagerInfo = this.entityInfo.getTrxManagerInfo();
        Object[] data = trxManagerInfo.transaction(new SessionCallable<Object[]>(){

            @Override
            public Object[] call(Session session) throws Exception {
                Query query;
                Long records = null;
                if (Boolean.TRUE.equals(count) && (records = Long.valueOf("" + (query = EntityNative.queryOf((SharedSessionContract)session, "select count(1) " + sql.getFrom() + " " + sql.getWhere(), parameters)).getSingleResult())) == 0L) {
                    return new Object[]{records, null};
                }
                List rows = EntityNative.queryOf((SharedSessionContract)session, sql.getSelect() + " " + sql.getFrom() + " " + sql.getWhere() + " " + sql.getOrder(), parameters, startLimit.getStart(), startLimit.getLimit()).getResultList();
                List list = EntityNative.entitesOf(rows, session, CrudSelectNative.this.entityInfo, CrudSelectNative.this.selects, crudRequest.getLoads());
                return new Object[]{records, list};
            }
        });
        return CrudResult.success((Object)page.setRecords((Long)data[0]).setData((List)data[1]));
    }

    @Override
    public CrudResult list() {
        String inIds;
        final CrudRequest crudRequest = CrudRequest.copy(this.crudRequest);
        final CrudSelect0.Ql sql = CrudHelper0.copy(this.sql, CrudSelect0.Ql.class);
        final ArrayList<EntityNative.Parameter> parameters = new ArrayList<EntityNative.Parameter>(this.parameters);
        final CrudSelect0.StartLimit startLimit = CrudSelect0.StartLimit.of(crudRequest, this.maxLimit);
        List<Filter> filters = crudRequest.getFilters();
        if (filters != null && !filters.isEmpty()) {
            for (Filter filter : filters) {
                CrudSelectNative0.filter(filter, this.entityInfo, this.alias, sql, parameters, this.selectJoins);
            }
        }
        if (!(inIds = CrudSelectNative0.inIds(crudRequest.getIds(), this.entityInfo, this.alias, parameters, 1)).isEmpty()) {
            sql.setWhere(sql.getWhere() + " and " + inIds);
        }
        CrudSelectNative0.orderOf(this.entityInfo, crudRequest.getOrders(), sql, this.alias, this.selectJoins);
        TrxManagerInfo trxManagerInfo = this.entityInfo.getTrxManagerInfo();
        List data = trxManagerInfo.transaction(new SessionCallable<List>(){

            @Override
            public List call(Session session) throws Exception {
                List rows = EntityNative.queryOf((SharedSessionContract)session, sql.getSelect() + " " + sql.getFrom() + " " + sql.getWhere() + " " + sql.getOrder(), parameters, startLimit.getStart(), startLimit.getLimit()).getResultList();
                return EntityNative.entitesOf(rows, session, CrudSelectNative.this.entityInfo, CrudSelectNative.this.selects, crudRequest.getLoads());
            }
        });
        return CrudResult.success((Object)data);
    }

    @Override
    public CrudResult single() {
        CrudRequest crudRequest = CrudRequest.copy(this.crudRequest);
        CrudSelect0.Ql sql = CrudHelper0.copy(this.sql, CrudSelect0.Ql.class);
        ArrayList<EntityNative.Parameter> parameters = new ArrayList<EntityNative.Parameter>(this.parameters);
        Object entity = CrudSelectNative0.single(this.entityInfo, this.alias, crudRequest, this.selects, sql, new ArrayList<EntityNative.Parameter>(parameters), this.selectJoins, false);
        return CrudResult.success((Object)entity);
    }

    @Override
    public CrudResult unique() {
        CrudRequest crudRequest = CrudRequest.copy(this.crudRequest);
        CrudSelect0.Ql sql = CrudHelper0.copy(this.sql, CrudSelect0.Ql.class);
        ArrayList<EntityNative.Parameter> parameters = new ArrayList<EntityNative.Parameter>(this.parameters);
        Object entity = CrudSelectNative0.single(this.entityInfo, this.alias, crudRequest, this.selects, sql, new ArrayList<EntityNative.Parameter>(parameters), this.selectJoins, true);
        return CrudResult.success((Object)entity);
    }

    @Override
    public CrudResult map() {
        List data = (List)this.list().getValue();
        MapStringObject map = CrudSelect0.listToMap(data, this.entityInfo, this.crudRequest);
        return CrudResult.success((Object)map);
    }
}

