/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.crud;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.ideahut.springboot.converter.Converter;
import net.ideahut.springboot.crud.Condition;
import net.ideahut.springboot.crud.CrudHelper0;
import net.ideahut.springboot.crud.CrudRequest;
import net.ideahut.springboot.crud.CrudSelect0;
import net.ideahut.springboot.crud.Filter;
import net.ideahut.springboot.entity.AttributeOverrides;
import net.ideahut.springboot.entity.EntityIdType;
import net.ideahut.springboot.entity.EntityInfo;
import net.ideahut.springboot.entity.EntityNative;
import net.ideahut.springboot.entity.FieldInfo;
import net.ideahut.springboot.entity.IdInfo;
import net.ideahut.springboot.entity.JoinColumns;
import net.ideahut.springboot.entity.SessionCallable;
import net.ideahut.springboot.entity.TrxManagerInfo;
import net.ideahut.springboot.util.FrameworkUtil;
import org.hibernate.Session;
import org.hibernate.SharedSessionContract;
import org.springframework.util.Assert;

final class CrudSelectNative0 {
    private CrudSelectNative0() {
    }

    static void orderOf(EntityInfo entityInfo, List<String> orders, CrudSelect0.Ql sql, String alias, Map<String, CrudSelect0.SelectJoin> selectJoins) {
        if (orders != null && !orders.isEmpty()) {
            StringBuilder orderQL = new StringBuilder();
            for (String order : orders) {
                int idx;
                boolean asc = true;
                if (order.startsWith("-")) {
                    asc = false;
                    order = order.substring(1);
                }
                if ((idx = order.indexOf(".")) != -1) {
                    String fnam = order.substring(0, idx);
                    CrudSelect0.SelectJoin selectJoin = selectJoins.get(fnam);
                    if (selectJoin != null) {
                        String cfield = order.substring(idx + 1);
                        FieldInfo jfInfo = selectJoin.getEntityInfo().getFieldInfo(cfield);
                        Assert.notNull((Object)jfInfo, (String)("Unknown order: " + selectJoin.getJoin().getName() + "." + cfield));
                        orderQL.append(EntityNative.aliasColumn(selectJoin.getAlias(), jfInfo.getColumn().getName()));
                    } else {
                        FieldInfo sfInfo = entityInfo.getFieldInfo(fnam);
                        Assert.notNull((Object)sfInfo, (String)("Unknown order: " + entityInfo.getEntityClass().getSimpleName() + "." + order));
                        String cfield = order.substring(idx + 1);
                        boolean found = false;
                        if (sfInfo.hasAttributeOverrides()) {
                            AttributeOverrides attrOvers = sfInfo.getAttributeOverrides();
                            for (String column : attrOvers.getColums()) {
                                if (!cfield.equals(attrOvers.getFieldInfo(column).getName())) continue;
                                orderQL.append(EntityNative.aliasColumn(alias, column));
                                found = true;
                                break;
                            }
                        } else if (sfInfo.hasJoinColumns()) {
                            JoinColumns joinColumns = sfInfo.getJoinColumns();
                            for (String column : joinColumns.getColums()) {
                                if (!cfield.equals(joinColumns.getFieldInfo(column).getName())) continue;
                                orderQL.append(EntityNative.aliasColumn(alias, column));
                                found = true;
                                break;
                            }
                        }
                        Assert.isTrue((boolean)found, (String)("Unknown order: " + entityInfo.getEntityClass().getSimpleName() + "." + order));
                    }
                    orderQL.append(" ").append(asc ? "asc" : "desc").append(",");
                    continue;
                }
                FieldInfo sfInfo = entityInfo.getFieldInfo(order);
                Assert.notNull((Object)sfInfo, (String)("Unknown order: " + entityInfo.getEntityClass().getSimpleName() + "." + order));
                if (sfInfo.hasJoinColumns()) {
                    JoinColumns joinColumns = sfInfo.getJoinColumns();
                    for (String column : joinColumns.getColums()) {
                        orderQL.append(EntityNative.aliasColumn(alias, column)).append(" ").append(asc ? "asc" : "desc").append(",");
                    }
                    continue;
                }
                if (sfInfo.getColumn() == null) continue;
                orderQL.append(EntityNative.aliasColumn(alias, sfInfo.getColumn().getName())).append(" ").append(asc ? "asc" : "desc").append(",");
            }
            if (orderQL.length() != 0) {
                orderQL.deleteCharAt(orderQL.length() - 1);
                sql.setOrder("order by " + orderQL.toString());
            }
        }
    }

    private static List listOf(final EntityInfo entityInfo, final List<EntityNative.Select> selects, final CrudSelect0.Ql sql, final List<EntityNative.Parameter> parameters, final CrudSelect0.StartLimit startLimit, final List<String> load) {
        TrxManagerInfo trxManagerInfo = entityInfo.getTrxManagerInfo();
        return trxManagerInfo.transaction(new SessionCallable<List>(){

            @Override
            public List call(Session session) throws Exception {
                List rows = EntityNative.queryOf((SharedSessionContract)session, sql.getSelect() + " " + sql.getFrom() + " " + sql.getWhere() + " " + sql.getOrder(), parameters, startLimit.getStart(), startLimit.getLimit()).getResultList();
                return EntityNative.entitesOf(rows, session, entityInfo, selects, load);
            }
        });
    }

    static String inIds(List<Object> ids, EntityInfo entityInfo, String alias, List<EntityNative.Parameter> parameters, Integer startIndex) {
        return EntityNative.generateInIdsQuery(ids, entityInfo, alias, parameters, startIndex);
    }

    static void filter(Filter filter, EntityInfo entityInfo, String alias, CrudSelect0.Ql sql, List<EntityNative.Parameter> parameters, Map<String, CrudSelect0.SelectJoin> selectJoins) {
        String logic = " " + filter.getLogical().name().toLowerCase();
        StringBuilder query = new StringBuilder(sql.getWhere());
        if (filter.getFilters() != null && !filter.getFilters().isEmpty()) {
            query.append(" ").append(logic).append(" (1=1 ");
            for (Filter child : filter.getFilters()) {
                sql.setWhere(query.toString());
                CrudSelectNative0.filter(child, entityInfo, alias, sql, parameters, selectJoins);
                query = new StringBuilder(sql.getWhere());
            }
            query.append(") ");
            sql.setWhere(query.toString());
            return;
        }
        if (filter.getField() == null) {
            throw FrameworkUtil.exception("Filter field is required");
        }
        Condition condition = filter.getCondition();
        FieldInfo fieldInfo = null;
        String idql = "";
        String field = filter.getField();
        int idx = field.indexOf(".");
        if (idx != -1) {
            String fnam = field.substring(0, idx);
            CrudSelect0.SelectJoin selectJoin = selectJoins.get(fnam);
            if (selectJoin != null) {
                if ((idx = (field = field.substring(idx + 1)).indexOf(".")) != -1) {
                    fpInfo = selectJoin.getEntityInfo().getFieldInfo(field.substring(0, idx));
                    Assert.notNull((Object)fpInfo, (String)("Unknown filter: " + selectJoin.getEntityInfo().getEntityClass().getName() + "." + field));
                    field = field.substring(idx + 1);
                    if (fpInfo.hasAttributeOverrides()) {
                        attributeOverrides = fpInfo.getAttributeOverrides();
                        for (String column : attributeOverrides.getColums()) {
                            atrInfo = attributeOverrides.getFieldInfo(column);
                            if (!atrInfo.getName().equals(field)) continue;
                            idql = EntityNative.aliasColumn(selectJoin.getAlias(), column);
                            fieldInfo = atrInfo;
                            break;
                        }
                    } else if (fpInfo.hasJoinColumns()) {
                        JoinColumns joinColumns = fpInfo.getJoinColumns();
                        for (String column : joinColumns.getColums()) {
                            FieldInfo jcfInfo = joinColumns.getFieldInfo(column);
                            if (!jcfInfo.getName().equals(field)) continue;
                            idql = EntityNative.aliasColumn(selectJoin.getAlias(), column);
                            fieldInfo = jcfInfo;
                            break;
                        }
                    } else {
                        Assert.isTrue((boolean)false, (String)("Unknown filter: " + selectJoin.getEntityInfo().getEntityClass().getName() + "." + fpInfo.getName() + "." + field));
                    }
                } else {
                    FieldInfo fjInfo = selectJoin.getEntityInfo().getFieldInfo(field);
                    Assert.notNull((Object)fjInfo, (String)("Unknown filter: " + selectJoin.getEntityInfo().getEntityClass().getName() + "." + field));
                    idql = EntityNative.aliasColumn(selectJoin.getAlias(), fjInfo.getColumn().getName());
                }
            } else {
                fpInfo = entityInfo.getFieldInfo(field.substring(0, idx));
                Assert.notNull((Object)fpInfo, (String)("Unknown filter: " + entityInfo.getEntityClass().getName() + "." + field));
                field = field.substring(idx + 1);
                if (fpInfo.hasAttributeOverrides()) {
                    attributeOverrides = fpInfo.getAttributeOverrides();
                    for (String column : attributeOverrides.getColums()) {
                        atrInfo = attributeOverrides.getFieldInfo(column);
                        if (!atrInfo.getName().equals(field)) continue;
                        idql = EntityNative.aliasColumn(alias, column);
                        fieldInfo = atrInfo;
                        break;
                    }
                } else if (fpInfo.hasJoinColumns()) {
                    String jcname = new String(field);
                    idx = jcname.indexOf(".");
                    if (idx != -1) {
                        jcname = jcname.substring(idx + 1);
                    }
                    JoinColumns joinColumns = fpInfo.getJoinColumns();
                    for (String column : joinColumns.getColums()) {
                        FieldInfo jcfInfo = joinColumns.getFieldInfo(column);
                        if (!jcfInfo.getName().equals(jcname)) continue;
                        idql = EntityNative.aliasColumn(alias, column);
                        fieldInfo = jcfInfo;
                        break;
                    }
                } else {
                    Assert.isTrue((boolean)false, (String)("Unknown filter: " + entityInfo.getEntityClass().getName() + "." + fpInfo.getName() + "." + field));
                }
            }
        } else {
            fieldInfo = entityInfo.getFieldInfo(field);
            Assert.notNull((Object)fieldInfo, (String)("Unknown filter: " + entityInfo.getEntityClass().getName() + "." + field));
            if (fieldInfo.hasJoinColumns()) {
                JoinColumns joinColumns = fieldInfo.getJoinColumns();
                if (Condition.IS_NULL.equals((Object)condition) || Condition.NOT_NULL.equals((Object)condition)) {
                    for (String column : joinColumns.getColums()) {
                        idql = EntityNative.aliasColumn(alias, column);
                        Condition.QueryParameters queryAndParameters = condition.getBuilder().build(true, logic, parameters.size(), idql, new Object[0]);
                        List qaParams = queryAndParameters.getParameters();
                        if (qaParams != null) {
                            for (Object qap : qaParams) {
                                parameters.add(EntityNative.Parameter.of(fieldInfo.getHibernateType(), qap));
                            }
                        }
                        query.append(queryAndParameters.getQuery());
                        sql.setWhere(query.toString());
                    }
                    return;
                }
            } else {
                idql = EntityNative.aliasColumn(alias, fieldInfo.getColumn().getName());
            }
        }
        ArrayList<Object> lvals = new ArrayList<Object>();
        if (filter.getValues() != null) {
            if (condition.isConvert() && fieldInfo.getConverter() != null) {
                if (Converter.isEnum(fieldInfo.getConverter())) {
                    for (Object ivalue : filter.getValues()) {
                        ovalue = fieldInfo.getConverter().convert(ivalue);
                        ovalue = EntityNative.enumValue(fieldInfo, ovalue);
                        lvals.add(ovalue);
                    }
                } else {
                    for (Object ivalue : filter.getValues()) {
                        ovalue = fieldInfo.getConverter().convert(ivalue);
                        lvals.add(ovalue);
                    }
                }
            } else {
                for (Object ivalue : filter.getValues()) {
                    lvals.add(ivalue);
                }
            }
        }
        try {
            Condition.QueryParameters queryAndParameters = condition.getBuilder().build(true, logic, parameters.size(), idql, lvals.toArray());
            List qaParams = queryAndParameters.getParameters();
            if (qaParams != null) {
                for (Object qap : qaParams) {
                    parameters.add(EntityNative.Parameter.of(fieldInfo.getHibernateType(), qap));
                }
            }
            query.append(queryAndParameters.getQuery());
            sql.setWhere(query.toString());
        }
        catch (Exception e) {
            throw FrameworkUtil.exception("Invalid filter: " + CrudHelper0.writeAsString(filter));
        }
    }

    static Object single(EntityInfo entityInfo, String alias, CrudRequest crudRequest, List<EntityNative.Select> selects, CrudSelect0.Ql sql, List<EntityNative.Parameter> parameters, Map<String, CrudSelect0.SelectJoin> selectJoins, boolean unique) {
        Object idValue;
        Object entity = null;
        Object object = idValue = crudRequest.getIds() != null && !crudRequest.getIds().isEmpty() ? crudRequest.getIds().get(0) : null;
        if (idValue != null) {
            try {
                IdInfo idInfo = entityInfo.getIdInfo();
                if (EntityIdType.COMPOSITE == idInfo.getIdType()) {
                    for (String name : idInfo.getFields()) {
                        FieldInfo fieldInfo = entityInfo.getFieldInfo(name);
                        CrudSelectNative0.filter(Filter.and((String)fieldInfo.getName(), (Condition)Condition.EQUAL, (Object[])new Object[]{fieldInfo.getValue(idValue)}), entityInfo, alias, sql, parameters, selectJoins);
                    }
                } else {
                    FieldInfo fieldInfo = entityInfo.getFieldInfo(idInfo.getFields().iterator().next());
                    if (fieldInfo.hasAttributeOverrides()) {
                        AttributeOverrides attributeOverrides = fieldInfo.getAttributeOverrides();
                        for (String column : attributeOverrides.getColums()) {
                            FieldInfo cinfo = attributeOverrides.getFieldInfo(column);
                            CrudSelectNative0.filter(Filter.and((String)(fieldInfo.getName() + "." + cinfo.getName()), (Condition)Condition.EQUAL, (Object[])new Object[]{cinfo.getValue(idValue)}), entityInfo, alias, sql, parameters, selectJoins);
                        }
                    } else {
                        CrudSelectNative0.filter(Filter.and((String)fieldInfo.getName(), (Condition)Condition.EQUAL, (Object[])new Object[]{idValue}), entityInfo, alias, sql, parameters, selectJoins);
                    }
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            List data = CrudSelectNative0.listOf(entityInfo, selects, sql, parameters, CrudSelect0.StartLimit.of(0, 2, 2), crudRequest.getLoads());
            if (data != null && !data.isEmpty()) {
                if (unique && data.size() > 1) {
                    throw FrameworkUtil.exception("Multiple data result");
                }
                entity = data.get(0);
            }
        } else {
            List data;
            CrudSelectNative0.orderOf(entityInfo, crudRequest.getOrders(), sql, alias, selectJoins);
            List<Filter> filters = crudRequest.getFilters();
            if (filters != null && !filters.isEmpty()) {
                for (Filter filter : filters) {
                    CrudSelectNative0.filter(filter, entityInfo, alias, sql, parameters, selectJoins);
                }
            }
            if ((data = CrudSelectNative0.listOf(entityInfo, selects, sql, parameters, CrudSelect0.StartLimit.of(0, 2, 2), crudRequest.getLoads())) != null && !data.isEmpty()) {
                if (unique && data.size() > 1) {
                    throw FrameworkUtil.exception("Multiple data result");
                }
                entity = data.get(0);
            }
        }
        return entity;
    }
}

