/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.crud;

import java.util.List;
import net.ideahut.springboot.crud.CrudConstant;
import net.ideahut.springboot.crud.CrudHelper0;
import net.ideahut.springboot.crud.CrudHelper1;
import net.ideahut.springboot.crud.CrudRequest;
import net.ideahut.springboot.crud.CrudResult;
import net.ideahut.springboot.crud.CrudUpdate;
import net.ideahut.springboot.crud.CrudUpdateEntity0;
import net.ideahut.springboot.crud.DepreHelper;
import net.ideahut.springboot.crud.Stack;
import net.ideahut.springboot.entity.EntityHelper;
import net.ideahut.springboot.entity.EntityInfo;
import net.ideahut.springboot.entity.EntityIntegrator;
import net.ideahut.springboot.entity.EntityPostListener;
import net.ideahut.springboot.entity.EntityPreListener;
import net.ideahut.springboot.entity.EntitySoftDelete;
import net.ideahut.springboot.entity.SessionCallable;
import net.ideahut.springboot.entity.TrxManagerInfo;
import net.ideahut.springboot.object.MapStringObject;
import net.ideahut.springboot.util.TimeUtil;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.query.Query;

final class CrudUpdateEntity
implements CrudUpdate {
    private EntityInfo entityInfo;
    private CrudRequest crudRequest;

    private CrudUpdateEntity() {
    }

    @Override
    public void destroy() {
        this.entityInfo = null;
        this.crudRequest = null;
    }

    static CrudUpdateEntity of(CrudRequest crudRequest) {
        CrudUpdateEntity crudUpdate = new CrudUpdateEntity();
        crudUpdate.crudRequest = crudRequest;
        crudUpdate.entityInfo = crudRequest.getProperties().getEntityInfo();
        return crudUpdate;
    }

    @Override
    public CrudResult create() {
        MapStringObject value = CrudHelper1.getValue(this.crudRequest);
        if (value == null) {
            return CrudConstant.Error.REQUIRED_VALUE;
        }
        final Object entity = CrudHelper0.mapToObject(value, this.entityInfo.getEntityClass());
        CrudHelper1.setId(this.crudRequest, entity);
        EntityHelper.setAudit(entity, false);
        final TrxManagerInfo trxManagerInfo = this.entityInfo.getTrxManagerInfo();
        return trxManagerInfo.transaction(true, new SessionCallable<CrudResult>(){

            @Override
            public CrudResult call(Session session) throws Exception {
                DepreHelper.save(session, entity);
                trxManagerInfo.loadLazy(entity, CrudUpdateEntity.this.entityInfo.getEntityClass(), CrudUpdateEntity.this.crudRequest.getLoads());
                CrudResult result = CrudResult.success((Object)entity);
                List<Stack> stacks = CrudUpdateEntity0.saveStacks(session, CrudUpdateEntity.this.entityInfo, CrudUpdateEntity.this.crudRequest, entity, false);
                if (stacks != null) {
                    result.setInfo("stacks", stacks);
                }
                return result;
            }
        });
    }

    @Override
    public CrudResult update() {
        Object id = CrudHelper1.getId(this.crudRequest);
        if (id == null) {
            return CrudConstant.Error.REQUIRED_ID;
        }
        final MapStringObject value = CrudHelper1.getValue(this.crudRequest);
        if (value == null) {
            return CrudConstant.Error.REQUIRED_VALUE;
        }
        final CrudUpdateEntity0.HqlParameters hqlParameters = CrudUpdateEntity0.hqlParametersByIds(this.crudRequest, 1);
        if (hqlParameters == null) {
            return CrudConstant.Error.UNSUPPORTED_ID_TYPE;
        }
        final TrxManagerInfo trxManagerInfo = this.entityInfo.getTrxManagerInfo();
        CrudResult crudResult = trxManagerInfo.transaction(true, new SessionCallable<CrudResult>(){

            @Override
            public CrudResult call(Session session) throws Exception {
                Query query = DepreHelper.createQuery(session, hqlParameters.selectQl());
                hqlParameters.applyParameters(query);
                Object entity = query.uniqueResult();
                if (entity != null) {
                    CrudUpdateEntity.this.entityInfo.merge(value, entity, CrudUpdateEntity.this.entityInfo.getIdInfo().getFields());
                    DepreHelper.update(session, entity);
                    List<Stack> stacks = CrudUpdateEntity0.saveStacks(session, CrudUpdateEntity.this.entityInfo, CrudUpdateEntity.this.crudRequest, entity, true);
                    trxManagerInfo.loadLazy(entity, CrudUpdateEntity.this.entityInfo.getEntityClass(), CrudUpdateEntity.this.crudRequest.getLoads());
                    CrudResult result = CrudResult.success((Object)entity);
                    if (stacks != null) {
                        result.setInfo("stacks", stacks);
                    }
                    return result;
                }
                return CrudResult.success(null);
            }
        });
        if (crudResult.getValue() == null) {
            return CrudConstant.Error.NOT_FOUND;
        }
        return crudResult;
    }

    @Override
    public CrudResult save() {
        final MapStringObject value = CrudHelper1.getValue(this.crudRequest);
        if (value == null) {
            return CrudConstant.Error.REQUIRED_VALUE;
        }
        CrudUpdateEntity0.HqlParameters hqlParameters = null;
        Object id = CrudHelper1.getId(this.crudRequest);
        if (id != null) {
            hqlParameters = CrudUpdateEntity0.hqlParametersByIds(this.crudRequest, 1);
        }
        final CrudUpdateEntity0.HqlParameters fHqlParameters = hqlParameters;
        final TrxManagerInfo trxManagerInfo = this.entityInfo.getTrxManagerInfo();
        return trxManagerInfo.transaction(true, new SessionCallable<CrudResult>(){

            @Override
            public CrudResult call(Session session) throws Exception {
                Object entity = null;
                if (fHqlParameters != null) {
                    Query query = DepreHelper.createQuery(session, fHqlParameters.selectQl());
                    fHqlParameters.applyParameters(query);
                    entity = query.uniqueResult();
                }
                if (entity != null) {
                    CrudUpdateEntity.this.entityInfo.merge(value, entity, CrudUpdateEntity.this.entityInfo.getIdInfo().getFields());
                    DepreHelper.update(session, entity);
                    List<Stack> stacks = CrudUpdateEntity0.saveStacks(session, CrudUpdateEntity.this.entityInfo, CrudUpdateEntity.this.crudRequest, entity, true);
                    trxManagerInfo.loadLazy(entity, CrudUpdateEntity.this.entityInfo.getEntityClass(), CrudUpdateEntity.this.crudRequest.getLoads());
                    CrudResult result = CrudResult.success((Object)entity);
                    if (stacks != null) {
                        result.setInfo("stacks", stacks);
                    }
                    return result;
                }
                entity = CrudHelper0.mapToObject(value, CrudUpdateEntity.this.entityInfo.getEntityClass());
                CrudHelper1.setId(CrudUpdateEntity.this.crudRequest, entity);
                DepreHelper.save(session, entity);
                trxManagerInfo.loadLazy(entity, CrudUpdateEntity.this.entityInfo.getEntityClass(), CrudUpdateEntity.this.crudRequest.getLoads());
                CrudResult result = CrudResult.success((Object)entity);
                List<Stack> stacks = CrudUpdateEntity0.saveStacks(session, CrudUpdateEntity.this.entityInfo, CrudUpdateEntity.this.crudRequest, entity, false);
                if (stacks != null) {
                    result.setInfo("stacks", stacks);
                }
                return result;
            }
        });
    }

    @Override
    public CrudResult delete() {
        Object id = CrudHelper1.getId(this.crudRequest);
        if (id == null) {
            return CrudConstant.Error.REQUIRED_ID;
        }
        final CrudUpdateEntity0.HqlParameters hqlParameters = CrudUpdateEntity0.hqlParametersByIds(this.crudRequest, 1);
        if (hqlParameters == null) {
            return CrudConstant.Error.UNSUPPORTED_ID_TYPE;
        }
        final TrxManagerInfo trxManagerInfo = this.entityInfo.getTrxManagerInfo();
        Object entity = trxManagerInfo.transaction(true, new SessionCallable<Object>(){

            @Override
            public Object call(Session session) throws Exception {
                Query query = DepreHelper.createQuery(session, hqlParameters.selectQl());
                hqlParameters.applyParameters(query);
                Object entity = query.uniqueResult();
                if (entity != null) {
                    DepreHelper.delete(session, entity);
                    trxManagerInfo.loadLazy(entity, CrudUpdateEntity.this.entityInfo.getEntityClass(), CrudUpdateEntity.this.crudRequest.getLoads());
                }
                return entity;
            }
        });
        return CrudResult.success((Object)entity);
    }

    @Override
    public CrudResult deletes() {
        List entities;
        block10: {
            SessionFactoryImplementor sessionFactory;
            TrxManagerInfo trxManagerInfo;
            CrudUpdateEntity0.HqlParameters hqlParameters;
            block11: {
                List<Object> ids = this.crudRequest.getIds();
                if (ids == null || ids.isEmpty()) {
                    return CrudConstant.Error.REQUIRED_IDS;
                }
                hqlParameters = CrudUpdateEntity0.hqlParametersByIds(this.crudRequest, 1);
                if (hqlParameters == null) {
                    return CrudConstant.Error.UNSUPPORTED_ID_TYPE;
                }
                trxManagerInfo = this.entityInfo.getTrxManagerInfo();
                entities = trxManagerInfo.transaction(new SessionCallable<List>(){

                    @Override
                    public List call(Session session) throws Exception {
                        Query query = DepreHelper.createQuery(session, hqlParameters.selectQl());
                        hqlParameters.applyParameters(query);
                        List list = query.getResultList();
                        trxManagerInfo.loadLazy(list, hqlParameters.entityClass(), CrudUpdateEntity.this.crudRequest.getLoads());
                        return list;
                    }
                });
                if (entities == null || entities.isEmpty()) break block10;
                sessionFactory = trxManagerInfo.getIntegrator().getSessionFactory();
                List<EntityPreListener> preListeners = EntityIntegrator.getEntityPreListeners((SessionFactory)sessionFactory);
                if (preListeners != null) {
                    for (EntityPreListener listener : preListeners) {
                        for (Object entity : entities) {
                            listener.onPreDelete(entity);
                        }
                    }
                }
                boolean isSoftDelete = EntitySoftDelete.class.isAssignableFrom(this.entityInfo.getEntityClass());
                final Long deletedOn = TimeUtil.currentEpochMillis();
                if (!isSoftDelete) break block11;
                final CrudUpdateEntity0.HqlParameters wapUpt = CrudUpdateEntity0.hqlParametersByIds(this.crudRequest, 2);
                trxManagerInfo.transaction(true, new SessionCallable<Void>(){

                    @Override
                    public Void call(Session session) throws Exception {
                        Query query = DepreHelper.createQuery(session, "update " + wapUpt.entityClass().getSimpleName() + " set deletedOn=?1 " + wapUpt.whereQl()).setParameter(1, (Object)deletedOn);
                        wapUpt.applyParameters(query);
                        query.executeUpdate();
                        return null;
                    }
                });
                List<EntityPostListener> postListeners = EntityIntegrator.getEntityPostListeners((SessionFactory)sessionFactory);
                if (postListeners == null) break block10;
                for (EntityPostListener listener : postListeners) {
                    for (Object entity : entities) {
                        ((EntitySoftDelete)entity).setDeletedOn(deletedOn);
                        listener.onPostDelete(entity);
                    }
                }
                break block10;
            }
            trxManagerInfo.transaction(true, new SessionCallable<Void>(){

                @Override
                public Void call(Session session) throws Exception {
                    Query query = DepreHelper.createQuery(session, hqlParameters.deleteQl());
                    hqlParameters.applyParameters(query);
                    query.executeUpdate();
                    return null;
                }
            });
            List<EntityPostListener> postListeners = EntityIntegrator.getEntityPostListeners((SessionFactory)sessionFactory);
            if (postListeners != null) {
                for (EntityPostListener listener : postListeners) {
                    for (Object entity : entities) {
                        listener.onPostDelete(entity);
                    }
                }
            }
        }
        return CrudResult.success((Object)entities);
    }
}

