/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.entity;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.ideahut.springboot.entity.BasicDataType;
import net.ideahut.springboot.entity.DepreHelper;
import net.ideahut.springboot.entity.EntityHelper1;
import net.ideahut.springboot.entity.EntityIdType;
import net.ideahut.springboot.entity.EntityInIdsQuery;
import net.ideahut.springboot.entity.EntityInfo;
import net.ideahut.springboot.entity.EntityNative;
import net.ideahut.springboot.entity.FieldInfo;
import net.ideahut.springboot.entity.InIdsQuery;
import net.ideahut.springboot.entity.NativeInIdsQuery;
import net.ideahut.springboot.entity.NativeInsertIdentity;
import org.hibernate.SharedSessionContract;
import org.hibernate.dialect.DB2Dialect;
import org.hibernate.dialect.DerbyDialect;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.H2Dialect;
import org.hibernate.dialect.HSQLDialect;
import org.hibernate.dialect.MariaDBDialect;
import org.hibernate.dialect.MySQLDialect;
import org.hibernate.dialect.OracleDialect;
import org.hibernate.dialect.PostgreSQLDialect;
import org.hibernate.dialect.SQLServerDialect;
import org.hibernate.dialect.identity.H2FinalTableIdentityColumnSupport;
import org.hibernate.dialect.identity.H2IdentityColumnSupport;
import org.hibernate.dialect.identity.IdentityColumnSupport;
import org.hibernate.type.Type;

enum DatabaseType {
    H2(true, (Type)BasicDataType.BLOB_TYPE, new DialectMatcher(){

        @Override
        public boolean isMatch(Dialect dialect) {
            return dialect instanceof H2Dialect;
        }
    }, new InIdsQueryCreators().put(EntityIdType.NONE, EntityInIdsQuery.None, NativeInIdsQuery.None).put(EntityIdType.STANDARD, EntityInIdsQuery.Standard, NativeInIdsQuery.Standard).put(EntityIdType.EMBEDDED, EntityInIdsQuery.Embedded, NativeInIdsQuery.Embedded.INLINE).put(EntityIdType.COMPOSITE, EntityInIdsQuery.Composite.INLINE, NativeInIdsQuery.Composite.INLINE), new NativeInsertIdentityCreator(){

        @Override
        public NativeInsertIdentity createNativeInsertIdentity(EntityInfo info) {
            NativeInsertIdentity nativeInsertIdentity = null;
            if (NativeInsertIdentity.isSupportIdentity(info)) {
                final NativeInsertIdentity.NativeLastInsertId nativeLastInsertId = NativeInsertIdentity.createNativeLastInsertId(info);
                FieldInfo idFieldInfo = info.getFieldInfo(info.getIdInfo().getFields().iterator().next());
                final String idColumn = idFieldInfo.getColumn().getName();
                Dialect dialect = info.getTrxManagerInfo().getIntegrator().getDialect();
                final IdentityColumnSupport identityColumnSupport = dialect.getIdentityColumnSupport();
                if (identityColumnSupport instanceof H2FinalTableIdentityColumnSupport) {
                    nativeInsertIdentity = new NativeInsertIdentity(){

                        @Override
                        public void executeInsert(SharedSessionContract session, String sqlInto, Object entity, String sqlValues, List<EntityNative.Parameter> parameters) throws Exception {
                            String sql = identityColumnSupport.appendIdentitySelectToInsert(idColumn, sqlInto + " " + sqlValues);
                            Object insertedId = EntityNative.queryOf(session, sql, parameters).uniqueResult();
                            if (insertedId != null) {
                                nativeLastInsertId.setLastInsertId(entity, insertedId);
                            }
                        }
                    };
                } else if (identityColumnSupport instanceof H2IdentityColumnSupport) {
                    final String identitySelectString = identityColumnSupport.getIdentitySelectString(null, null, -1);
                    nativeInsertIdentity = new NativeInsertIdentity(){

                        @Override
                        public void executeInsert(SharedSessionContract session, String sqlInto, Object entity, String sqlValues, List<EntityNative.Parameter> parameters) throws Exception {
                            String sql = sqlInto + " " + sqlValues;
                            int num = EntityNative.queryOf(session, sql, parameters).executeUpdate();
                            if (num > 0) {
                                try {
                                    Object insertedId = DepreHelper.createNativeQuery(session, identitySelectString).uniqueResult();
                                    if (insertedId != null) {
                                        nativeLastInsertId.setLastInsertId(entity, insertedId);
                                    }
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                        }
                    };
                }
            }
            return nativeInsertIdentity;
        }
    }),
    SQLServer(false, (Type)BasicDataType.TEXT_TYPE, new DialectMatcher(){

        @Override
        public boolean isMatch(Dialect dialect) {
            return dialect instanceof SQLServerDialect;
        }
    }, new InIdsQueryCreators().put(EntityIdType.NONE, EntityInIdsQuery.None, NativeInIdsQuery.None).put(EntityIdType.STANDARD, EntityInIdsQuery.Standard, NativeInIdsQuery.Standard).put(EntityIdType.EMBEDDED, EntityInIdsQuery.Embedded, NativeInIdsQuery.Embedded.INLINE).put(EntityIdType.COMPOSITE, EntityInIdsQuery.Composite.INLINE, NativeInIdsQuery.Composite.INLINE), new NativeInsertIdentityCreator(){

        @Override
        public NativeInsertIdentity createNativeInsertIdentity(EntityInfo info) {
            if (NativeInsertIdentity.isSupportIdentity(info)) {
                final NativeInsertIdentity.NativeLastInsertId nativeLastInsertId = NativeInsertIdentity.createNativeLastInsertId(info);
                Dialect dialect = info.getTrxManagerInfo().getIntegrator().getDialect();
                final IdentityColumnSupport identityColumnSupport = dialect.getIdentityColumnSupport();
                return new NativeInsertIdentity(){

                    @Override
                    public void executeInsert(SharedSessionContract session, String sqlInto, Object entity, String sqlValues, List<EntityNative.Parameter> parameters) throws Exception {
                        String sql = identityColumnSupport.appendIdentitySelectToInsert(sqlInto + " " + sqlValues);
                        Object insertedId = EntityNative.queryOf(session, sql, parameters).uniqueResult();
                        if (insertedId != null) {
                            nativeLastInsertId.setLastInsertId(entity, insertedId);
                        }
                    }
                };
            }
            return null;
        }
    }),
    MariaDB(false, (Type)BasicDataType.BLOB_TYPE, new DialectMatcher(){

        @Override
        public boolean isMatch(Dialect dialect) {
            return dialect instanceof MariaDBDialect;
        }
    }, new InIdsQueryCreators().put(EntityIdType.NONE, EntityInIdsQuery.None, NativeInIdsQuery.None).put(EntityIdType.STANDARD, EntityInIdsQuery.Standard, NativeInIdsQuery.Standard).put(EntityIdType.EMBEDDED, EntityInIdsQuery.Embedded, NativeInIdsQuery.Embedded.BRACKET).put(EntityIdType.COMPOSITE, EntityInIdsQuery.Composite.BRACKET, NativeInIdsQuery.Composite.BRACKET), new NativeInsertIdentityCreator(){

        @Override
        public NativeInsertIdentity createNativeInsertIdentity(EntityInfo info) {
            if (NativeInsertIdentity.isSupportIdentity(info)) {
                final NativeInsertIdentity.NativeLastInsertId nativeLastInsertId = NativeInsertIdentity.createNativeLastInsertId(info);
                Dialect dialect = info.getTrxManagerInfo().getIntegrator().getDialect();
                final String identitySelectString = dialect.getIdentityColumnSupport().getIdentitySelectString(null, null, -1);
                return new NativeInsertIdentity(){

                    @Override
                    public void executeInsert(SharedSessionContract session, String sqlInto, Object entity, String sqlValues, List<EntityNative.Parameter> parameters) throws Exception {
                        String sql = sqlInto + " " + sqlValues;
                        int num = EntityNative.queryOf(session, sql, parameters).executeUpdate();
                        if (num > 0) {
                            try {
                                Object insertedId = DepreHelper.createNativeQuery(session, identitySelectString).uniqueResult();
                                if (insertedId != null) {
                                    nativeLastInsertId.setLastInsertId(entity, insertedId);
                                }
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    }
                };
            }
            return null;
        }
    }),
    MySQL(false, (Type)BasicDataType.BLOB_TYPE, new DialectMatcher(){

        @Override
        public boolean isMatch(Dialect dialect) {
            return dialect instanceof MySQLDialect;
        }
    }, new InIdsQueryCreators().put(EntityIdType.NONE, EntityInIdsQuery.None, NativeInIdsQuery.None).put(EntityIdType.STANDARD, EntityInIdsQuery.Standard, NativeInIdsQuery.Standard).put(EntityIdType.EMBEDDED, EntityInIdsQuery.Embedded, NativeInIdsQuery.Embedded.BRACKET).put(EntityIdType.COMPOSITE, EntityInIdsQuery.Composite.BRACKET, NativeInIdsQuery.Composite.BRACKET), new NativeInsertIdentityCreator(){

        @Override
        public NativeInsertIdentity createNativeInsertIdentity(EntityInfo info) {
            if (NativeInsertIdentity.isSupportIdentity(info)) {
                final NativeInsertIdentity.NativeLastInsertId nativeLastInsertId = NativeInsertIdentity.createNativeLastInsertId(info);
                Dialect dialect = info.getTrxManagerInfo().getIntegrator().getDialect();
                final String identitySelectString = dialect.getIdentityColumnSupport().getIdentitySelectString(null, null, -1);
                return new NativeInsertIdentity(){

                    @Override
                    public void executeInsert(SharedSessionContract session, String sqlInto, Object entity, String sqlValues, List<EntityNative.Parameter> parameters) throws Exception {
                        String sql = sqlInto + " " + sqlValues;
                        int num = EntityNative.queryOf(session, sql, parameters).executeUpdate();
                        if (num > 0) {
                            try {
                                Object insertedId = DepreHelper.createNativeQuery(session, identitySelectString).uniqueResult();
                                if (insertedId != null) {
                                    nativeLastInsertId.setLastInsertId(entity, insertedId);
                                }
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    }
                };
            }
            return null;
        }
    }),
    HSQL(true, (Type)BasicDataType.CLOB_TYPE, new DialectMatcher(){

        @Override
        public boolean isMatch(Dialect dialect) {
            return dialect instanceof HSQLDialect;
        }
    }, new InIdsQueryCreators().put(EntityIdType.NONE, EntityInIdsQuery.None, NativeInIdsQuery.None).put(EntityIdType.STANDARD, EntityInIdsQuery.Standard, NativeInIdsQuery.Standard).put(EntityIdType.EMBEDDED, EntityInIdsQuery.Embedded, NativeInIdsQuery.Embedded.INLINE).put(EntityIdType.COMPOSITE, EntityInIdsQuery.Composite.INLINE, NativeInIdsQuery.Composite.INLINE), new NativeInsertIdentityCreator(){

        @Override
        public NativeInsertIdentity createNativeInsertIdentity(EntityInfo info) {
            if (NativeInsertIdentity.isSupportIdentity(info)) {
                final NativeInsertIdentity.NativeLastInsertId nativeLastInsertId = NativeInsertIdentity.createNativeLastInsertId(info);
                Dialect dialect = info.getTrxManagerInfo().getIntegrator().getDialect();
                final String identitySelectString = dialect.getIdentityColumnSupport().getIdentitySelectString(null, null, -1);
                return new NativeInsertIdentity(){

                    @Override
                    public void executeInsert(SharedSessionContract session, String sqlInto, Object entity, String sqlValues, List<EntityNative.Parameter> parameters) throws Exception {
                        String sql = sqlInto + " " + sqlValues;
                        int num = EntityNative.queryOf(session, sql, parameters).executeUpdate();
                        if (num > 0) {
                            try {
                                Object insertedId = DepreHelper.createNativeQuery(session, identitySelectString).uniqueResult();
                                if (insertedId != null) {
                                    nativeLastInsertId.setLastInsertId(entity, insertedId);
                                }
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    }
                };
            }
            return null;
        }
    }),
    PostgreSQL(false, (Type)BasicDataType.BLOB_TYPE, new DialectMatcher(){

        @Override
        public boolean isMatch(Dialect dialect) {
            return dialect instanceof PostgreSQLDialect;
        }
    }, new InIdsQueryCreators().put(EntityIdType.NONE, EntityInIdsQuery.None, NativeInIdsQuery.None).put(EntityIdType.STANDARD, EntityInIdsQuery.Standard, NativeInIdsQuery.Standard).put(EntityIdType.EMBEDDED, EntityInIdsQuery.Embedded, NativeInIdsQuery.Embedded.BRACKET).put(EntityIdType.COMPOSITE, EntityInIdsQuery.Composite.BRACKET, NativeInIdsQuery.Composite.BRACKET), new NativeInsertIdentityCreator(){

        @Override
        public NativeInsertIdentity createNativeInsertIdentity(EntityInfo info) {
            if (NativeInsertIdentity.isSupportIdentity(info)) {
                final NativeInsertIdentity.NativeLastInsertId nativeLastInsertId = NativeInsertIdentity.createNativeLastInsertId(info);
                final FieldInfo idFieldInfo = info.getFieldInfo(info.getIdInfo().getFields().iterator().next());
                return new NativeInsertIdentity(){

                    @Override
                    public void executeInsert(SharedSessionContract session, String sqlInto, Object entity, String sqlValues, List<EntityNative.Parameter> parameters) throws Exception {
                        String sql = sqlInto + " " + sqlValues + " RETURNING " + idFieldInfo.getColumn().getName();
                        Object insertedId = EntityNative.queryOf(session, sql, parameters).uniqueResult();
                        if (insertedId != null) {
                            nativeLastInsertId.setLastInsertId(entity, insertedId);
                        }
                    }
                };
            }
            return null;
        }
    }),
    Oracle(true, (Type)BasicDataType.CLOB_TYPE, new DialectMatcher(){

        @Override
        public boolean isMatch(Dialect dialect) {
            return dialect instanceof OracleDialect;
        }
    }, new InIdsQueryCreators().put(EntityIdType.NONE, EntityInIdsQuery.None, NativeInIdsQuery.None).put(EntityIdType.STANDARD, EntityInIdsQuery.Standard, NativeInIdsQuery.Standard).put(EntityIdType.EMBEDDED, EntityInIdsQuery.Embedded, NativeInIdsQuery.Embedded.INLINE).put(EntityIdType.COMPOSITE, EntityInIdsQuery.Composite.INLINE, NativeInIdsQuery.Composite.INLINE), new NativeInsertIdentityCreator(){

        @Override
        public NativeInsertIdentity createNativeInsertIdentity(EntityInfo info) {
            if (NativeInsertIdentity.isSupportIdentity(info)) {
                final NativeInsertIdentity.NativeLastInsertId nativeLastInsertId = NativeInsertIdentity.createNativeLastInsertId(info);
                FieldInfo idFieldInfo = info.getFieldInfo(info.getIdInfo().getFields().iterator().next());
                String defaultColumnValue = EntityHelper1.getColumDefaultValue(info.getTrxManagerInfo().getIntegrator(), info.getTable(), idFieldInfo.getColumn(), true);
                if (defaultColumnValue.indexOf(".nextval") != -1) {
                    final String currentIdValue = defaultColumnValue.replace(".nextval", ".currval");
                    return new NativeInsertIdentity(){

                        @Override
                        public void executeInsert(SharedSessionContract session, String sqlInto, Object entity, String sqlValues, List<EntityNative.Parameter> parameters) throws Exception {
                            String sql = sqlInto + " " + sqlValues;
                            int num = EntityNative.queryOf(session, sql, parameters).executeUpdate();
                            if (num > 0) {
                                try {
                                    Object insertedId = DepreHelper.createNativeQuery(session, "select " + currentIdValue + " from dual").uniqueResult();
                                    if (insertedId != null) {
                                        nativeLastInsertId.setLastInsertId(entity, insertedId);
                                    }
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                        }
                    };
                }
            }
            return null;
        }
    }),
    Derby(true, (Type)BasicDataType.CLOB_TYPE, new DialectMatcher(){

        @Override
        public boolean isMatch(Dialect dialect) {
            return dialect instanceof DerbyDialect;
        }
    }, new InIdsQueryCreators().put(EntityIdType.NONE, EntityInIdsQuery.None, NativeInIdsQuery.None).put(EntityIdType.STANDARD, EntityInIdsQuery.Standard, NativeInIdsQuery.Standard).put(EntityIdType.EMBEDDED, EntityInIdsQuery.Embedded, NativeInIdsQuery.Embedded.INLINE).put(EntityIdType.COMPOSITE, EntityInIdsQuery.Composite.INLINE, NativeInIdsQuery.Composite.INLINE), new NativeInsertIdentityCreator(){

        @Override
        public NativeInsertIdentity createNativeInsertIdentity(EntityInfo info) {
            if (NativeInsertIdentity.isSupportIdentity(info)) {
                final NativeInsertIdentity.NativeLastInsertId nativeLastInsertId = NativeInsertIdentity.createNativeLastInsertId(info);
                Dialect dialect = info.getTrxManagerInfo().getIntegrator().getDialect();
                final String identitySelectString = dialect.getIdentityColumnSupport().getIdentitySelectString(null, null, -1);
                return new NativeInsertIdentity(){

                    @Override
                    public void executeInsert(SharedSessionContract session, String sqlInto, Object entity, String sqlValues, List<EntityNative.Parameter> parameters) throws Exception {
                        String sql = sqlInto + " " + sqlValues;
                        int num = EntityNative.queryOf(session, sql, parameters).executeUpdate();
                        if (num > 0) {
                            try {
                                Object insertedId = DepreHelper.createNativeQuery(session, identitySelectString).uniqueResult();
                                if (insertedId != null) {
                                    nativeLastInsertId.setLastInsertId(entity, insertedId);
                                }
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    }
                };
            }
            return null;
        }
    }),
    DB2(true, (Type)BasicDataType.CLOB_TYPE, new DialectMatcher(){

        @Override
        public boolean isMatch(Dialect dialect) {
            return dialect instanceof DB2Dialect;
        }
    }, new InIdsQueryCreators().put(EntityIdType.NONE, EntityInIdsQuery.None, NativeInIdsQuery.None).put(EntityIdType.STANDARD, EntityInIdsQuery.Standard, NativeInIdsQuery.Standard).put(EntityIdType.EMBEDDED, EntityInIdsQuery.Embedded, NativeInIdsQuery.Embedded.INLINE).put(EntityIdType.COMPOSITE, EntityInIdsQuery.Composite.INLINE, NativeInIdsQuery.Composite.INLINE), new NativeInsertIdentityCreator(){

        @Override
        public NativeInsertIdentity createNativeInsertIdentity(EntityInfo info) {
            if (NativeInsertIdentity.isSupportIdentity(info)) {
                final NativeInsertIdentity.NativeLastInsertId nativeLastInsertId = NativeInsertIdentity.createNativeLastInsertId(info);
                Dialect dialect = info.getTrxManagerInfo().getIntegrator().getDialect();
                final String identitySelectString = dialect.getIdentityColumnSupport().getIdentitySelectString(null, null, -1);
                return new NativeInsertIdentity(){

                    @Override
                    public void executeInsert(SharedSessionContract session, String sqlInto, Object entity, String sqlValues, List<EntityNative.Parameter> parameters) throws Exception {
                        String sql = sqlInto + " " + sqlValues;
                        int num = EntityNative.queryOf(session, sql, parameters).executeUpdate();
                        if (num > 0) {
                            try {
                                Object insertedId = DepreHelper.createNativeQuery(session, identitySelectString).uniqueResult();
                                if (insertedId != null) {
                                    nativeLastInsertId.setLastInsertId(entity, insertedId);
                                }
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    }
                };
            }
            return null;
        }
    }),
    Unknown(false, (Type)BasicDataType.BLOB_TYPE, new DialectMatcher(){

        @Override
        public boolean isMatch(Dialect dialect) {
            return false;
        }
    }, new InIdsQueryCreators().put(EntityIdType.NONE, EntityInIdsQuery.None, NativeInIdsQuery.None).put(EntityIdType.STANDARD, EntityInIdsQuery.Standard, NativeInIdsQuery.Standard).put(EntityIdType.EMBEDDED, EntityInIdsQuery.Embedded, NativeInIdsQuery.Embedded.BRACKET).put(EntityIdType.COMPOSITE, EntityInIdsQuery.Composite.BRACKET, NativeInIdsQuery.Composite.BRACKET), new NativeInsertIdentityCreator(){

        @Override
        public NativeInsertIdentity createNativeInsertIdentity(EntityInfo entityInfo) {
            return null;
        }
    });

    private final boolean upperCaseTable;
    private final Type stringLobType;
    private final DialectMatcher dialectMatcher;
    private final InIdsQueryCreators inIdsQueryCreators;
    private final NativeInsertIdentityCreator nativeInsertIdentityCreator;

    private DatabaseType(boolean upperCaseTable, Type stringLobType, DialectMatcher dialectMatcher, InIdsQueryCreators inIdsQueryCreators, NativeInsertIdentityCreator nativeInsertIdentityCreator) {
        this.upperCaseTable = upperCaseTable;
        this.stringLobType = stringLobType;
        this.dialectMatcher = dialectMatcher;
        this.inIdsQueryCreators = inIdsQueryCreators;
        this.nativeInsertIdentityCreator = nativeInsertIdentityCreator;
    }

    static DatabaseType of(Dialect dialect) {
        for (DatabaseType databaseType : DatabaseType.values()) {
            if (!databaseType.getDialectMatcher().isMatch(dialect)) continue;
            return databaseType;
        }
        return Unknown;
    }

    public boolean isUpperCaseTable() {
        return this.upperCaseTable;
    }

    public Type getStringLobType() {
        return this.stringLobType;
    }

    public DialectMatcher getDialectMatcher() {
        return this.dialectMatcher;
    }

    public InIdsQueryCreators getInIdsQueryCreators() {
        return this.inIdsQueryCreators;
    }

    public NativeInsertIdentityCreator getNativeInsertIdentityCreator() {
        return this.nativeInsertIdentityCreator;
    }

    private static interface DialectMatcher {
        public boolean isMatch(Dialect var1);
    }

    static class InIdsQueryCreators {
        private Map<EntityIdType, InIdsQueryCreator> entityCreators = new LinkedHashMap<EntityIdType, InIdsQueryCreator>();
        private Map<EntityIdType, InIdsQueryCreator> nativeCreators = new LinkedHashMap<EntityIdType, InIdsQueryCreator>();

        InIdsQueryCreators() {
        }

        private InIdsQueryCreators put(EntityIdType entityIdType, InIdsQueryCreator entityCreator, InIdsQueryCreator nativeCreator) {
            this.entityCreators.put(entityIdType, entityCreator);
            this.nativeCreators.put(entityIdType, nativeCreator);
            return this;
        }

        protected InIdsQueryCreator getEntityInIdsQueryCreator(EntityIdType entityIdType) {
            return this.entityCreators.get(entityIdType);
        }

        protected InIdsQueryCreator getNativeInIdsQueryCreator(EntityIdType entityIdType) {
            return this.nativeCreators.get(entityIdType);
        }
    }

    static interface NativeInsertIdentityCreator {
        public NativeInsertIdentity createNativeInsertIdentity(EntityInfo var1);
    }

    static interface InIdsQueryCreator {
        public InIdsQuery createInIdsQuery(EntityInfo var1);
    }
}

