/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.entity;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import net.ideahut.springboot.audit.AuditInfo;
import net.ideahut.springboot.entity.DepreHelper;
import net.ideahut.springboot.entity.EntityAudit;
import net.ideahut.springboot.entity.EntityHelper0;
import net.ideahut.springboot.entity.EntityHelper1;
import net.ideahut.springboot.entity.EntityInfo;
import net.ideahut.springboot.entity.EntityIntegrator;
import net.ideahut.springboot.entity.FieldInfo;
import net.ideahut.springboot.util.FrameworkUtil;
import net.ideahut.springboot.util.TimeUtil;
import org.hibernate.Session;
import org.hibernate.StatelessSession;
import org.hibernate.Transaction;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Table;

public final class EntityHelper {
    private EntityHelper() {
    }

    public static void loadLazy(Object entity, EntityInfo entityInfo, Collection<String> tobeLoadFields) {
        EntityHelper.loadLazy(entity, entityInfo, tobeLoadFields, null);
    }

    public static void loadLazy(Object entity, EntityInfo entityInfo, Collection<String> loadFields, Collection<String> selectedFields) {
        try {
            EntityHelper0.loadLazy(entity, entityInfo, loadFields, selectedFields);
        }
        catch (Exception e) {
            throw FrameworkUtil.exception(e);
        }
    }

    public static FieldInfo getFieldInfo(EntityInfo entityInfo, String anyFieldName) {
        return EntityHelper0.getFieldInfo(entityInfo, anyFieldName);
    }

    public static Object getFieldValue(EntityInfo entityInfo, String anyFieldName, Collection<String> value) {
        return EntityHelper0.getFieldValue(entityInfo, anyFieldName, value);
    }

    public static Object getFieldValue(EntityInfo entityInfo, String anyFieldName, String value) {
        return EntityHelper0.getFieldValue(entityInfo, anyFieldName, value);
    }

    public static void commit(Session session) {
        if (session != null) {
            EntityHelper.commit(session.getTransaction());
        }
    }

    public static void commit(StatelessSession session) {
        if (session != null) {
            EntityHelper.commit(session.getTransaction());
        }
    }

    public static void commit(Transaction transaction) {
        block3: {
            if (transaction != null) {
                try {
                    transaction.commit();
                }
                catch (Exception e) {
                    if (e instanceof IllegalStateException) break block3;
                    throw FrameworkUtil.exception(e);
                }
            }
        }
    }

    public static void rollback(Session session) {
        if (session != null) {
            EntityHelper.rollback(session.getTransaction());
        }
    }

    public static void rollback(StatelessSession session) {
        if (session != null) {
            EntityHelper.rollback(session.getTransaction());
        }
    }

    public static void rollback(Transaction transaction) {
        if (transaction != null) {
            try {
                transaction.rollback();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void close(Session session) {
        if (session != null) {
            try {
                session.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void close(StatelessSession session) {
        if (session != null) {
            try {
                session.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void close(Connection connection) {
        EntityHelper1.close(connection);
    }

    public static List<String> getCatalogs(DatabaseMetaData dbMetaData) throws SQLException {
        return EntityHelper1.getCatalogs(dbMetaData);
    }

    public static Table findTable(EntityIntegrator integrator, String name) {
        return EntityHelper1.findTable(integrator, name);
    }

    public static Column findColumn(Table table, String name) {
        return EntityHelper1.findColumn(table, name);
    }

    public static boolean createTable(EntityIntegrator integrator, Table table, boolean isIdentityPk) {
        return EntityHelper1.createTable(integrator, table, isIdentityPk);
    }

    public static String aliasField(String alias, String field) {
        return (String)(alias != null && !alias.isEmpty() ? alias + "." : "") + field;
    }

    public static void setAudit(Object object, boolean isUpdate) {
        if (object instanceof EntityAudit) {
            EntityAudit entity = (EntityAudit)object;
            AuditInfo info = AuditInfo.context();
            Long now = TimeUtil.currentEpochMillis();
            if (isUpdate) {
                entity.setUpdatedBy(info.getAuditor());
                entity.setUpdatedOn(now);
            } else {
                entity.setCreatedBy(info.getAuditor());
                entity.setCreatedOn(now);
                entity.setUpdatedBy(info.getAuditor());
                entity.setUpdatedOn(now);
            }
        }
    }

    public static String generateInIdsQuery(List<Object> ids, EntityInfo entityInfo, String alias, List<Object> parameters, Integer startIndex) {
        if (ids != null) {
            return entityInfo.getStandardDefinition().getInIdsQuery().getInIdsQuery(ids, alias, parameters, startIndex);
        }
        return "";
    }

    public static Object save(Session session, Object object) {
        return DepreHelper.save(session, object);
    }

    public static Object save(Session session, String entityName, Object object) {
        return DepreHelper.save(session, entityName, object);
    }

    public static void update(Session session, Object object) {
        DepreHelper.update(session, object);
    }

    public static void update(Session session, String entityName, Object object) {
        DepreHelper.update(session, entityName, object);
    }

    public static void saveOrUpdate(Session session, Object object) {
        DepreHelper.saveOrUpdate(session, object);
    }

    public static void saveOrUpdate(Session session, String entityName, Object object) {
        DepreHelper.saveOrUpdate(session, entityName, object);
    }

    public static void delete(Session session, Object object) {
        DepreHelper.delete(session, object);
    }

    public static void delete(Session session, String entityName, Object object) {
        DepreHelper.delete(session, entityName, object);
    }
}

