/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.entity;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import net.ideahut.springboot.converter.Converter;
import net.ideahut.springboot.entity.DepreHelper;
import net.ideahut.springboot.entity.EntityIdType;
import net.ideahut.springboot.entity.EntityInfo;
import net.ideahut.springboot.entity.FieldInfo;
import net.ideahut.springboot.entity.IdInfo;
import net.ideahut.springboot.entity.TrxManagerInfo;
import net.ideahut.springboot.util.FrameworkUtil;
import org.hibernate.Hibernate;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.id.IdentifierGenerator;
import org.springframework.data.domain.Page;

final class EntityHelper0 {
    private static final Method mtdIdGeneratorType;
    private static final Method mtdIdGeneratorStrategy;

    private EntityHelper0() {
    }

    private static boolean isLoadLazy(Object entity, EntityInfo entityInfo, Collection<String> loadFields, Collection<String> selectedFields) throws Exception {
        boolean result = false;
        if (entity instanceof Collection) {
            Iterator iter = ((Collection)entity).iterator();
            while (iter.hasNext()) {
                EntityHelper0.loadLazy(iter.next(), entityInfo, loadFields, selectedFields);
            }
            result = true;
        } else if (entity instanceof net.ideahut.springboot.object.Page) {
            EntityHelper0.loadLazy(((net.ideahut.springboot.object.Page)entity).getData(), entityInfo, loadFields, selectedFields);
            result = true;
        } else if (entity instanceof Page) {
            EntityHelper0.loadLazy(((Page)entity).getContent(), entityInfo, loadFields, selectedFields);
            result = true;
        } else if (entity instanceof Map) {
            EntityHelper0.loadLazy(((Map)entity).values(), entityInfo, loadFields, selectedFields);
            result = true;
        }
        return result;
    }

    static void loadLazy(Object entity, EntityInfo entityInfo, Collection<String> loadFields, Collection<String> selectedFields) throws Exception {
        if (entity != null) {
            FieldInfo idFieldInfo;
            Object newFieldObject;
            Iterator<FieldInfo> idInfo;
            EntityInfo entityInfo2;
            if (loadFields == null) {
                loadFields = new ArrayList<String>();
            }
            if (EntityHelper0.isLoadLazy(entity, entityInfo, loadFields, selectedFields)) {
                return;
            }
            if (entity instanceof Object[]) {
                ArrayList<String> lSelectedFields = new ArrayList<String>();
                if (selectedFields != null) {
                    lSelectedFields.addAll(selectedFields);
                }
                Object[] objects = (Object[])entity;
                for (int i = 0; i < objects.length; ++i) {
                    FieldInfo fieldInfo;
                    FieldInfo fieldInfo2 = fieldInfo = lSelectedFields.size() > i ? entityInfo.getFieldInfo((String)lSelectedFields.get(i)) : null;
                    if (fieldInfo != null && fieldInfo.isLazyObject()) {
                        entityInfo2 = entityInfo.getTrxManagerInfo().getEntityInfo(fieldInfo.getType());
                        if (loadFields.contains(fieldInfo.getName())) {
                            if (!Hibernate.isInitialized((Object)objects[i])) {
                                Hibernate.initialize((Object)objects[i]);
                            }
                        } else {
                            idInfo = entityInfo2.getIdInfo();
                            newFieldObject = entityInfo2.createEntity();
                            for (String idFieldName : ((IdInfo)((Object)idInfo)).getFields()) {
                                idFieldInfo = entityInfo2.getFieldInfo(idFieldName);
                                idFieldInfo.setValue(newFieldObject, idFieldInfo.getValue(objects[i]));
                            }
                            objects[i] = newFieldObject;
                        }
                        for (FieldInfo lazyObjectFieldInfo : entityInfo2.getLazyObjectFields().values()) {
                            lazyObjectFieldInfo.setValue(objects[i], null);
                        }
                        for (FieldInfo lazyCollectionFieldInfo : entityInfo2.getLazyCollectionFields().values()) {
                            lazyCollectionFieldInfo.setValue(objects[i], null);
                        }
                        continue;
                    }
                    if (entityInfo == null || objects[i] == null) continue;
                    entityInfo2 = entityInfo.getTrxManagerInfo().getEntityInfo(objects[i].getClass());
                    EntityHelper0.loadLazy(objects[i], entityInfo2 != null ? entityInfo2 : entityInfo, null, null);
                }
            } else if (entityInfo != null && !entityInfo.getEntityClass().isAssignableFrom(entity.getClass())) {
                FieldInfo fieldInfo;
                EntityInfo entityInfo22;
                if (selectedFields != null && selectedFields.size() == 1 && (entityInfo22 = entityInfo.getTrxManagerInfo().getEntityInfo(entity.getClass())) != null && (fieldInfo = entityInfo.getFieldInfo(selectedFields.iterator().next())) != null && fieldInfo.isLazyObject()) {
                    if (!Hibernate.isInitialized((Object)entity)) {
                        Hibernate.initialize((Object)entity);
                    }
                    for (FieldInfo lazyObjectFieldInfo : entityInfo22.getLazyObjectFields().values()) {
                        lazyObjectFieldInfo.setValue(entity, null);
                    }
                    for (FieldInfo lazyCollectionFieldInfo : entityInfo22.getLazyCollectionFields().values()) {
                        lazyCollectionFieldInfo.setValue(entity, null);
                    }
                }
                return;
            }
            if (!entity.getClass().isArray() && entityInfo != null) {
                Object fieldObject;
                TrxManagerInfo trxManagerInfo = entityInfo.getTrxManagerInfo();
                for (FieldInfo fieldInfo : entityInfo.getLazyObjectFields().values()) {
                    fieldObject = fieldInfo.fieldValue(entity);
                    if (fieldObject == null) continue;
                    entityInfo2 = trxManagerInfo.getEntityInfo(fieldInfo.getType());
                    if (loadFields.contains(fieldInfo.getName())) {
                        if (!Hibernate.isInitialized((Object)fieldObject)) {
                            Hibernate.initialize((Object)fieldObject);
                        }
                        for (FieldInfo lazyObjectFieldInfo : entityInfo2.getLazyObjectFields().values()) {
                            lazyObjectFieldInfo.setValue(fieldObject, null);
                        }
                        for (FieldInfo lazyCollectionFieldInfo : entityInfo2.getLazyCollectionFields().values()) {
                            lazyCollectionFieldInfo.setValue(fieldObject, null);
                        }
                    } else {
                        idInfo = entityInfo2.getIdInfo();
                        newFieldObject = entityInfo2.createEntity();
                        for (String idFieldName : ((IdInfo)((Object)idInfo)).getFields()) {
                            idFieldInfo = entityInfo2.getFieldInfo(idFieldName);
                            idFieldInfo.setValue(newFieldObject, idFieldInfo.getValue(fieldObject));
                        }
                        fieldInfo.setValue(entity, newFieldObject);
                        fieldObject = fieldInfo.fieldValue(entity);
                    }
                    for (FieldInfo fieldInfo2 : entityInfo2.getCollectionGenericTypes().values()) {
                        if (!entityInfo.getEntityClass().isAssignableFrom(fieldInfo2.getType())) continue;
                        fieldInfo2.setValue(fieldObject, null);
                    }
                }
                for (FieldInfo fieldInfo : entityInfo.getLazyCollectionFields().values()) {
                    fieldObject = fieldInfo.fieldValue(entity);
                    if (fieldObject == null) continue;
                    if (loadFields.contains(fieldInfo.getName())) {
                        if (!Hibernate.isInitialized((Object)fieldObject)) {
                            Hibernate.initialize((Object)fieldObject);
                        }
                        if ((entityInfo2 = trxManagerInfo.getEntityInfo(fieldInfo.getCollectionGenericType())) == null) continue;
                        Collection collections = (Collection)fieldObject;
                        for (Object object : collections) {
                            for (String fieldName2 : entityInfo2.getFieldInfoNames()) {
                                FieldInfo fieldInfo2 = entityInfo2.getFieldInfo(fieldName2);
                                if (Converter.isEntity(fieldInfo2.getConverter())) {
                                    if (!fieldInfo2.isLazyObject() && fieldInfo2.getCollectionGenericType() == null && !entityInfo.getEntityClass().isAssignableFrom(fieldInfo2.getType())) continue;
                                    fieldInfo2.setValue(object, null);
                                    continue;
                                }
                                if (!Converter.isCollection(fieldInfo2.getConverter())) continue;
                                fieldInfo2.setValue(object, null);
                            }
                        }
                        continue;
                    }
                    fieldInfo.setValue(entity, null);
                }
            }
        }
    }

    private static String toAnyFieldName(String[] fields) {
        return String.join((CharSequence)".", fields);
    }

    static FieldInfo getFieldInfo(EntityInfo entityInfo, String anyFieldName) {
        String[] fields = anyFieldName.split("\\.");
        TrxManagerInfo trxManagerInfo = entityInfo.getTrxManagerInfo();
        FieldInfo fieldInfo = entityInfo.getFieldInfo(fields[0]);
        if (fields.length > 1) {
            IdInfo idInfo;
            EntityInfo nextEntityInfo = trxManagerInfo.getEntityInfo(fieldInfo.getType());
            fieldInfo = nextEntityInfo != null ? EntityHelper0.getFieldInfo(nextEntityInfo, EntityHelper0.toAnyFieldName(Arrays.copyOfRange(fields, 1, fields.length))) : ((idInfo = entityInfo.getIdInfo()) != null && idInfo.getEmbeddedEntityInfo() != null ? EntityHelper0.getFieldInfo(idInfo.getEmbeddedEntityInfo(), EntityHelper0.toAnyFieldName(Arrays.copyOfRange(fields, 1, fields.length))) : null);
        }
        return fieldInfo;
    }

    static Object getFieldValue(EntityInfo entityInfo, String anyFieldName, String value) {
        return EntityHelper0.getFieldValue(entityInfo, anyFieldName, Arrays.asList(value));
    }

    static Object getFieldValue(EntityInfo entityInfo, String anyFieldName, Collection<String> value) {
        try {
            String idField;
            boolean isEmbeddedId;
            FieldInfo fieldInfo = null;
            IdInfo idInfo = entityInfo.getIdInfo();
            boolean bl = isEmbeddedId = EntityIdType.EMBEDDED == idInfo.getIdType();
            if (isEmbeddedId && anyFieldName.startsWith((idField = idInfo.getFields().iterator().next()) + ".")) {
                fieldInfo = idInfo.getEmbeddedEntityInfo().getFieldInfo(anyFieldName.substring((idField + ".").length()));
            }
            if (fieldInfo == null && (fieldInfo = EntityHelper0.getFieldInfo(entityInfo, anyFieldName)) == null) {
                return null;
            }
            Converter converter = fieldInfo.getConverter();
            Object object = null;
            if (converter != null) {
                object = Converter.isEntity(converter) ? (Object)fieldInfo.createEntity() : (Converter.isCollection(converter) ? null : converter.convert(value));
            }
            return object;
        }
        catch (Exception e) {
            throw FrameworkUtil.exception(e);
        }
    }

    static IdentifierGenerator getIdentifierGenerator(GenericGenerator genericGenerator) {
        IdentifierGenerator identifierGenerator = null;
        if (mtdIdGeneratorType != null) {
            try {
                Class clazz = (Class)mtdIdGeneratorType.invoke((Object)genericGenerator, new Object[0]);
                int modifiers = clazz.getModifiers();
                if (IdentifierGenerator.class.isAssignableFrom(clazz) && !Modifier.isAbstract(modifiers)) {
                    identifierGenerator = (IdentifierGenerator)FrameworkUtil.newInstance(clazz, new Object[0]);
                }
            }
            catch (Exception clazz) {
                // empty catch block
            }
        }
        if (identifierGenerator == null && mtdIdGeneratorStrategy != null) {
            try {
                String strategy = ((String)mtdIdGeneratorStrategy.invoke((Object)genericGenerator, new Object[0])).trim();
                identifierGenerator = "uuid".equalsIgnoreCase(strategy) ? DepreHelper.newUUIDGenerator() : (IdentifierGenerator)FrameworkUtil.newInstance(strategy, new Object[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return identifierGenerator;
    }

    static {
        Method mtdIdGeneratorTypeEi = null;
        try {
            mtdIdGeneratorTypeEi = GenericGenerator.class.getMethod("type", new Class[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        mtdIdGeneratorType = mtdIdGeneratorTypeEi;
        Method mtdIdGeneratorStrategyEi = null;
        try {
            mtdIdGeneratorStrategyEi = GenericGenerator.class.getMethod("strategy", new Class[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        mtdIdGeneratorStrategy = mtdIdGeneratorStrategyEi;
    }
}

