/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.entity;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import jakarta.persistence.Column;
import jakarta.persistence.EmbeddedId;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToMany;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OneToOne;
import jakarta.persistence.PrimaryKeyJoinColumn;
import jakarta.persistence.PrimaryKeyJoinColumns;
import jakarta.persistence.Transient;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.ideahut.springboot.converter.Converter;
import net.ideahut.springboot.entity.AttributeOverrides;
import net.ideahut.springboot.entity.EntityHelper0;
import net.ideahut.springboot.entity.EntityHelper1;
import net.ideahut.springboot.entity.EntityIdType;
import net.ideahut.springboot.entity.EntityInfo;
import net.ideahut.springboot.entity.EntityNative;
import net.ideahut.springboot.entity.FieldInfo;
import net.ideahut.springboot.entity.IdInfo;
import net.ideahut.springboot.entity.JoinColumns;
import net.ideahut.springboot.mapper.DataMapper;
import net.ideahut.springboot.mapper.DataMapperImpl;
import net.ideahut.springboot.object.MapStringObject;
import net.ideahut.springboot.util.FrameworkUtil;
import org.hibernate.annotations.GenericGenerator;

final class EntityInfo0 {
    private static final List<Class<?>> FIELD_ANNOTATIONS = Arrays.asList(GenericGenerator.class);
    static final DataMapper mapper = new DataMapperImpl(true);

    private EntityInfo0() {
    }

    static void prepareMapper(EntityInfo entityInfo) throws Exception {
        Object entity = entityInfo.createEntity();
        String str = ((ObjectMapper)mapper.mapper(1)).writeValueAsString(entity);
        ((ObjectMapper)mapper.mapper(1)).readValue(str, entityInfo.getEntityClass());
        str = ((XmlMapper)mapper.mapper(2)).writeValueAsString(entity);
        ((XmlMapper)mapper.mapper(2)).readValue(str, entityInfo.getEntityClass());
    }

    static EntityInfo collectField(EntityInfo entityInfo, Field field, Map<String, FieldInfo> fieldTransients, Map<String, FieldInfo> fieldInfos, Map<String, FieldInfo> columnInfos, Map<String, FieldInfo> eagerObjectFields, Map<String, FieldInfo> lazyObjectFields, Map<String, FieldInfo> lazyCollectionFields, Map<String, FieldInfo> collectionGenericTypes, Set<String> idFields, Set<String> uniqueFields, Map<Class<? extends Annotation>, Set<String>> annotationFields) throws Exception {
        field.setAccessible(true);
        Transient annotTransient = EntityInfo0.getAnnotation(Transient.class, field);
        if (annotTransient != null) {
            FieldInfo fieldInfo = new FieldInfo(entityInfo, field, null, false, false, null, false, null, null, null, null, false);
            fieldTransients.put(field.getName(), fieldInfo);
            return null;
        }
        String name = field.getName();
        Boolean nullable = null;
        Long length = null;
        Integer scale = null;
        Integer precision = null;
        boolean included = false;
        Class<?> type = field.getType();
        boolean eagerObject = false;
        boolean lazyObject = false;
        boolean lazyCollection = false;
        Class collectionGenericType = null;
        if (Collection.class.isAssignableFrom(type)) {
            OneToMany oneToMany = EntityInfo0.getAnnotation(OneToMany.class, field);
            ManyToMany manyToMany = EntityInfo0.getAnnotation(ManyToMany.class, field);
            if (oneToMany != null) {
                lazyCollection = FetchType.LAZY == oneToMany.fetch();
            } else if (manyToMany != null) {
                lazyCollection = FetchType.LAZY == manyToMany.fetch();
            }
            Type genericType = field.getGenericType();
            if (genericType instanceof ParameterizedType) {
                ParameterizedType parameterizedType = (ParameterizedType)genericType;
                collectionGenericType = (Class)parameterizedType.getActualTypeArguments()[0];
            }
        } else {
            ManyToOne manyToOne = EntityInfo0.getAnnotation(ManyToOne.class, field);
            OneToOne oneToOne = EntityInfo0.getAnnotation(OneToOne.class, field);
            if (manyToOne != null) {
                lazyObject = FetchType.LAZY == manyToOne.fetch();
                eagerObject = FetchType.EAGER == manyToOne.fetch();
            } else if (oneToOne != null) {
                lazyObject = FetchType.LAZY == oneToOne.fetch();
                eagerObject = FetchType.EAGER == oneToOne.fetch();
            }
        }
        String colname = null;
        Column annotColumn = EntityInfo0.getAnnotation(Column.class, field);
        JoinColumn annotJoinColumn = EntityInfo0.getAnnotation(JoinColumn.class, field);
        jakarta.persistence.JoinColumns annotJoinColumns = EntityInfo0.getAnnotation(jakarta.persistence.JoinColumns.class, field);
        PrimaryKeyJoinColumn annotPrimaryKeyJoinColumn = EntityInfo0.getAnnotation(PrimaryKeyJoinColumn.class, field);
        PrimaryKeyJoinColumns annotPrimaryKeyJoinColumns = EntityInfo0.getAnnotation(PrimaryKeyJoinColumns.class, field);
        if (annotColumn != null) {
            colname = !annotColumn.name().isEmpty() ? annotColumn.name() : field.getName();
            nullable = annotColumn.nullable();
            length = annotColumn.length();
            scale = annotColumn.scale();
            precision = annotColumn.precision();
            if (annotColumn.unique()) {
                uniqueFields.add(name);
            }
            included = true;
        } else if (!(annotJoinColumn == null && annotJoinColumns == null && annotPrimaryKeyJoinColumn == null && annotPrimaryKeyJoinColumns == null || Collection.class.isAssignableFrom(type))) {
            included = true;
        } else {
            colname = field.getName();
            included = true;
        }
        EmbeddedId annotEmbeddedId = EntityInfo0.getAnnotation(EmbeddedId.class, field);
        if (!included && annotEmbeddedId == null) {
            return null;
        }
        Annotation[] annotations = EntityInfo0.getAnnotations(field);
        if (annotations != null) {
            for (Annotation annotation : annotations) {
                Class<? extends Annotation> annotationType = annotation.annotationType();
                if (annotationType.getName().startsWith("jakarta.persistence.") || FIELD_ANNOTATIONS.contains(annotationType)) continue;
                Set<String> fields = annotationFields.get(annotationType);
                if (fields == null) {
                    fields = new HashSet<String>();
                    annotationFields.put(annotationType, fields);
                }
                fields.add(field.getName());
            }
        }
        org.hibernate.mapping.Column column = null;
        if (entityInfo.getTable() != null && colname != null) {
            column = EntityHelper1.findColumn(entityInfo.getTable(), colname);
        }
        if (column != null) {
            length = column.getLength();
            if (column.getNullable() != null) {
                nullable = column.getNullable().toBoolean(false);
            }
            precision = column.getPrecision();
            scale = column.getScale();
        }
        EntityInfo embeddedIdInfo = null;
        if (annotEmbeddedId != null) {
            embeddedIdInfo = new EntityInfo(entityInfo.getTrxManagerInfo(), field.getType(), entityInfo.getTable());
            embeddedIdInfo.parentInfo = entityInfo;
            idFields.add(name);
        } else {
            Id id = EntityInfo0.getAnnotation(Id.class, field);
            if (id != null) {
                idFields.add(name);
            }
        }
        FieldInfo fieldInfo = new FieldInfo(entityInfo, field, column, lazyObject, lazyCollection, collectionGenericType, eagerObject, nullable, length, scale, precision, embeddedIdInfo != null);
        fieldInfos.put(name, fieldInfo);
        if (colname != null && !columnInfos.containsKey(colname)) {
            columnInfos.put(colname, fieldInfo);
        }
        if (collectionGenericType != null) {
            collectionGenericTypes.put(name, fieldInfo);
        }
        if (fieldInfo.isLazyObject()) {
            lazyObjectFields.put(name, fieldInfo);
        } else if (fieldInfo.isLazyCollection()) {
            lazyCollectionFields.put(name, fieldInfo);
        } else if (fieldInfo.isEagerObject()) {
            eagerObjectFields.put(name, fieldInfo);
        }
        return embeddedIdInfo;
    }

    static IdInfo getIdInfo(Set<String> idFieldsEi, Set<String> uniqueFieldsEi, Map<String, FieldInfo> fieldInfosEi, EntityInfo embeddedEntityInfo) throws Exception {
        IdInfo idInfo = new IdInfo();
        idInfo.setFields(idFieldsEi);
        if (idFieldsEi.size() > 1) {
            idInfo.setIdType(EntityIdType.COMPOSITE);
        } else if (idFieldsEi.size() == 1) {
            uniqueFieldsEi.add(idFieldsEi.iterator().next());
            if (embeddedEntityInfo != null) {
                idInfo.setEmbeddedEntityInfo(embeddedEntityInfo);
                idInfo.setIdType(EntityIdType.EMBEDDED);
            } else {
                idInfo.setIdType(EntityIdType.STANDARD);
                FieldInfo field = fieldInfosEi.get(idFieldsEi.iterator().next());
                GeneratedValue generatedValue = field.getAnnotation(GeneratedValue.class);
                GenericGenerator genericGenerator = field.getAnnotation(GenericGenerator.class);
                idInfo.setGeneratedValue(generatedValue);
                idInfo.setGenericGenerator(genericGenerator);
                idInfo.setIdentifierGenerator(EntityHelper0.getIdentifierGenerator(genericGenerator));
            }
        } else {
            idInfo.setIdType(EntityIdType.NONE);
        }
        return idInfo;
    }

    static Map<String, EntityNative.ColumnConverter> getColumnConverters(EntityInfo entityInfo) {
        LinkedHashMap<String, EntityNative.ColumnConverter> columnConverters = new LinkedHashMap<String, EntityNative.ColumnConverter>();
        for (String name : entityInfo.getFieldInfoNames()) {
            FieldInfo fieldInfo = entityInfo.getFieldInfo(name);
            if (fieldInfo.hasAttributeOverrides()) {
                AttributeOverrides attributeOverrides = fieldInfo.getAttributeOverrides();
                for (String column : attributeOverrides.getColums()) {
                    FieldInfo cinfo = attributeOverrides.getFieldInfo(column);
                    EntityNative.ColumnConverter columnConverter = EntityNative.ColumnConverter.of(column, cinfo.getConverter());
                    columnConverters.put(fieldInfo.getName() + "." + cinfo.getName(), columnConverter);
                }
                continue;
            }
            if (fieldInfo.hasJoinColumns()) {
                EntityInfo childInfo = entityInfo.getTrxManagerInfo().getEntityInfo(fieldInfo.getType());
                JoinColumns joinColumns = fieldInfo.getJoinColumns();
                if (EntityIdType.EMBEDDED == childInfo.getIdInfo().getIdType()) {
                    String idName = childInfo.getIdInfo().getFields().iterator().next();
                    for (String column : joinColumns.getColums()) {
                        FieldInfo cinfo = joinColumns.getFieldInfo(column);
                        EntityNative.ColumnConverter columnConverter = EntityNative.ColumnConverter.of(column, cinfo.getConverter());
                        columnConverters.put(fieldInfo.getName() + "." + idName + "." + cinfo.getName(), columnConverter);
                    }
                    continue;
                }
                for (String column : joinColumns.getColums()) {
                    FieldInfo cinfo = joinColumns.getFieldInfo(column);
                    EntityNative.ColumnConverter columnConverter = EntityNative.ColumnConverter.of(column, cinfo.getConverter());
                    columnConverters.put(fieldInfo.getName() + "." + cinfo.getName(), columnConverter);
                }
                continue;
            }
            if (fieldInfo.getColumn() == null) continue;
            EntityNative.ColumnConverter columnConverter = EntityNative.ColumnConverter.of(fieldInfo.getColumn().getName(), fieldInfo.getConverter());
            columnConverters.put(fieldInfo.getName(), columnConverter);
        }
        return columnConverters;
    }

    static <T> boolean merge(EntityInfo entityInfo, T source, T target, boolean skipNull, Collection<String> skipFields) {
        boolean changed = false;
        if (source != null && target != null) {
            if (!source.getClass().equals(target.getClass())) {
                throw FrameworkUtil.exception("Invalid entity type: " + source.getClass().getName() + " != " + target.getClass().getName());
            }
            if (!entityInfo.getEntityClass().isAssignableFrom(source.getClass())) {
                throw FrameworkUtil.exception("Entity type must " + entityInfo.getEntityClass().getName());
            }
            HashSet<String> fieldNames = new HashSet<String>(entityInfo.getFieldInfoNames());
            fieldNames.removeAll(entityInfo.mergeIgnoredFields);
            if (skipFields != null) {
                fieldNames.removeAll(skipFields);
            }
            try {
                for (String name : fieldNames) {
                    FieldInfo fieldInfo = entityInfo.getFieldInfo(name);
                    Object value = fieldInfo.getValue(source);
                    if (value != null) {
                        if (!changed) {
                            tgtval = fieldInfo.getValue(target);
                            changed = !value.equals(tgtval);
                        }
                    } else {
                        if (skipNull || !Boolean.TRUE.equals(fieldInfo.getNullable())) continue;
                        if (!changed) {
                            tgtval = fieldInfo.getValue(target);
                            changed = tgtval != null;
                        }
                    }
                    fieldInfo.setValue(target, value);
                }
            }
            catch (Exception e) {
                throw FrameworkUtil.exception(e);
            }
        }
        return changed;
    }

    static <T> boolean merge(EntityInfo entityInfo, MapStringObject source, T target, Collection<String> skipFields) throws Exception {
        boolean changed = false;
        if (target != null && source != null) {
            if (!entityInfo.getEntityClass().isAssignableFrom(target.getClass())) {
                throw FrameworkUtil.exception("Target type must " + entityInfo.getEntityClass());
            }
            HashSet fieldNames = new HashSet(source.keySet());
            fieldNames.removeAll(entityInfo.mergeIgnoredFields);
            if (skipFields != null) {
                fieldNames.removeAll(skipFields);
            }
            for (String name : fieldNames) {
                FieldInfo fieldInfo = entityInfo.getFieldInfo(name);
                if (fieldInfo == null) continue;
                Object value = source.get((Object)name);
                if (value != null) {
                    value = Converter.isEntity(fieldInfo.getConverter()) ? mapper.convert(value, fieldInfo.getType()) : fieldInfo.convert(value);
                    if (!changed) {
                        Object fntval = fieldInfo.getValue(target);
                        changed = value != null ? !value.equals(fntval) : fntval != null;
                    }
                } else {
                    if (!fieldInfo.hasJoinRelations() && !Boolean.TRUE.equals(fieldInfo.getNullable())) continue;
                    if (!changed) {
                        Object tgtval = fieldInfo.getValue(target);
                        changed = tgtval != null;
                    }
                }
                fieldInfo.setValue(target, value);
            }
        }
        return changed;
    }

    private static Method getMethod(Field field) {
        try {
            String name = "get" + field.getName().substring(0, 1).toUpperCase() + field.getName().substring(1);
            Method method = field.getDeclaringClass().getMethod(name, new Class[0]);
            if (method.getReturnType().equals(field.getType())) {
                return method;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    static <A extends Annotation> A getAnnotation(Class<A> clazz, Field field) {
        Method method;
        A annotation = field.getAnnotation(clazz);
        if (annotation == null && (method = EntityInfo0.getMethod(field)) != null) {
            annotation = method.getAnnotation(clazz);
        }
        return annotation;
    }

    static Annotation[] getAnnotations(Field field) {
        Annotation[] annotations = field.getAnnotations();
        if (annotations != null && annotations.length != 0) {
            return annotations;
        }
        Method method = EntityInfo0.getMethod(field);
        if (method != null) {
            annotations = method.getAnnotations();
        }
        return annotations;
    }
}

