/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.entity;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.ideahut.springboot.entity.DepreHelper;
import net.ideahut.springboot.entity.EntityInfo;
import net.ideahut.springboot.entity.EntityNative;
import net.ideahut.springboot.entity.FieldInfo;
import net.ideahut.springboot.entity.NativeSelectValue;
import org.hibernate.Session;
import org.hibernate.SharedSessionContract;
import org.hibernate.query.Query;

final class EntityNative0 {
    private EntityNative0() {
    }

    static <T> T reload(Session session, EntityInfo entityInfo, Integer replica, T entity) throws Exception {
        FreshEntity freshEntity = FreshEntity.of(session, entity, entityInfo, replica, true);
        return (T)freshEntity.getObject();
    }

    static <T> Query<T> queryOf(SharedSessionContract session, String sql, List<EntityNative.Parameter> parameters, Integer start, Integer limit) {
        Query query = DepreHelper.createNativeQuery(session, sql);
        if (parameters != null) {
            for (int i = 0; i < parameters.size(); ++i) {
                EntityNative.Parameter parameter = parameters.get(i);
                query.setParameter(i + 1, parameter.getValue(), parameter.getType());
            }
        }
        if (start != null && start >= 0) {
            query.setFirstResult(start.intValue());
        }
        if (limit != null && limit >= 0) {
            query.setMaxResults(limit.intValue());
        }
        return query;
    }

    static void appendSelect(String name, StringBuilder selectQl, String alias, boolean commaAtFirst) {
        String saila = alias != null ? alias : "";
        String column = EntityNative.aliasColumn(alias, name);
        selectQl.append(commaAtFirst ? "," : "").append(column).append(" as ").append(saila).append("i_").append(name).append(commaAtFirst ? "" : ",");
    }

    static <T> T valueOf(EntityNative.Select select, Object[] data) throws Exception {
        Object entity = select.getEntityInfo().createEntity();
        int start = select.getIndex();
        boolean isnull = true;
        for (FieldInfo field : select.getFields()) {
            NativeSelectValue.Nsv nsv = field.getNativeDefinition().getSelectValue().valueOf(data, entity, start);
            start = nsv.getLast();
            if (!isnull) continue;
            isnull = !nsv.isSetted();
        }
        if (!isnull) {
            select.getEntityInfo().writeJoinColumns(entity);
            return entity;
        }
        return null;
    }

    static <T> List<T> entitesOf(List<Object[]> rows, Session session, EntityInfo entityInfo, List<EntityNative.Select> selects, List<String> load) throws Exception {
        EntityNative.LazyLoad lazyLoad = EntityNative.LazyLoad.of(entityInfo, null, load);
        ArrayList<T> entities = new ArrayList<T>();
        while (!rows.isEmpty()) {
            Object[] row = rows.remove(0);
            EntityNative.Select select = selects.get(0);
            T entity = EntityNative0.valueOf(select, row);
            lazyLoad.reload(session, entity);
            for (int i = 1; i < selects.size(); ++i) {
                select = selects.get(i);
                if (select.getStore() == null) continue;
                T child = EntityNative0.valueOf(select, row);
                select.getStore().setValue(entity, child);
            }
            entities.add(entity);
        }
        lazyLoad.destroy();
        return entities;
    }

    static class FreshEntity {
        private final EntityInfo entityInfo;
        private final Object object;
        private final Map<String, EntityNative.Parameter> idColumsValue;

        private FreshEntity(EntityInfo entityInfo, Object object, Map<String, EntityNative.Parameter> idColumsValue) {
            this.entityInfo = entityInfo;
            this.object = object;
            this.idColumsValue = idColumsValue;
        }

        EntityInfo getEntityInfo() {
            return this.entityInfo;
        }

        Object getObject() {
            return this.object;
        }

        Map<String, EntityNative.Parameter> getIdColumsValue() {
            return this.idColumsValue;
        }

        static FreshEntity of(Session session, Object entity, EntityInfo info, Integer replica, boolean isGetObject) throws Exception {
            ArrayList<EntityNative.Parameter> parameters = new ArrayList<EntityNative.Parameter>();
            StringBuilder whereQl = new StringBuilder("where 1=1 ");
            LinkedHashMap<String, EntityNative.Parameter> idColumsValueEi = new LinkedHashMap<String, EntityNative.Parameter>();
            info.getNativeDefinition().getFreshAppender().append(entity, whereQl, parameters, idColumsValueEi);
            Object objectEi = null;
            if (!idColumsValueEi.isEmpty() && isGetObject) {
                StringBuilder selectQl = new StringBuilder();
                EntityNative.Select select = EntityNative.Select.of(info, 0, null);
                for (String field : select.getEntityInfo().getFieldInfoNames()) {
                    FieldInfo fieldInfo = select.getEntityInfo().getFieldInfo(field);
                    EntityNative.appendSelect(fieldInfo, select, selectQl, null, 0, false);
                }
                String sql = "select " + selectQl.deleteCharAt(selectQl.length() - 1) + " from " + EntityNative.tableReplica(select.getEntityInfo(), replica) + " " + whereQl.toString();
                Object[] data = (Object[])EntityNative.queryOf((SharedSessionContract)session, sql, parameters).uniqueResult();
                if (data != null) {
                    objectEi = EntityNative.valueOf(select, data);
                }
            }
            parameters.clear();
            return new FreshEntity(info, objectEi, idColumsValueEi);
        }
    }
}

