/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.entity;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import net.ideahut.springboot.entity.DepreHelper;
import net.ideahut.springboot.entity.EntityHelper1;
import net.ideahut.springboot.entity.EntityInfo;
import net.ideahut.springboot.entity.EntityIntegrator;
import net.ideahut.springboot.entity.NativeInsertIdentity;
import net.ideahut.springboot.entity.SessionCallable;
import net.ideahut.springboot.entity.TrxManagerInfo;
import org.hibernate.Session;
import org.hibernate.SharedSessionContract;
import org.hibernate.mapping.ForeignKey;
import org.hibernate.mapping.Index;
import org.hibernate.mapping.Table;
import org.hibernate.mapping.UniqueKey;

public final class EntityReplica {
    private EntityReplica() {
    }

    public static List<String> getSQL(EntityInfo entityInfo, Integer total, EntityInfo ... entityInfosWithReplica) {
        HashSet<EntityInfo> refEntityInfos = new HashSet<EntityInfo>();
        if (entityInfosWithReplica != null) {
            for (EntityInfo refEntityInfo : entityInfosWithReplica) {
                refEntityInfos.add(refEntityInfo);
            }
        }
        boolean isIdentityPk = NativeInsertIdentity.isSupportIdentity(entityInfo);
        TrxManagerInfo trxManagerInfo = entityInfo.getTrxManagerInfo();
        EntityIntegrator integrator = trxManagerInfo.getIntegrator();
        ArrayList<String[]> items = new ArrayList<String[]>();
        Table table = entityInfo.getTable();
        String sqlTable = EntityHelper1.sqlCreateTable(integrator, table, isIdentityPk);
        items.add(new String[]{"", sqlTable});
        Iterator<Index> iterIndex = DepreHelper.getIndexIterator(table);
        while (iterIndex.hasNext()) {
            Index index = iterIndex.next();
            String sqlIndex = EntityHelper1.sqlCreateIndex(integrator, index);
            items.add(new String[]{index.getName(), sqlIndex});
        }
        Iterator<UniqueKey> iterUqk = DepreHelper.getUniqueKeyIterator(table);
        while (iterUqk.hasNext()) {
            UniqueKey uniqueKey = iterUqk.next();
            String sqlUniqueKey = EntityHelper1.sqlCreateUniqueKey(integrator, uniqueKey);
            items.add(new String[]{uniqueKey.getName(), sqlUniqueKey});
        }
        Iterator<ForeignKey> iterFk = DepreHelper.getForeignKeyIterator(table);
        while (iterFk.hasNext()) {
            ForeignKey foreignKey = iterFk.next();
            String sqlForeignKey = DepreHelper.sqlCreateForeignKey(integrator, foreignKey, table.getCatalog(), table.getSchema());
            Table refTable = foreignKey.getReferencedTable();
            EntityInfo refEntity = trxManagerInfo.getEntityInfo(refTable.getSchema(), refTable.getName());
            if (refEntityInfos.contains(refEntity)) {
                items.add(new String[]{foreignKey.getName(), sqlForeignKey, refTable.getName()});
                continue;
            }
            items.add(new String[]{foreignKey.getName(), sqlForeignKey});
        }
        ArrayList<String> sqls = new ArrayList<String>();
        for (int i = 1; i <= total; ++i) {
            for (String[] query : items) {
                int idx;
                String re;
                String s0 = query[0];
                Object s1 = query[1];
                String string = re = query.length > 2 ? query[2] : "";
                if (!s0.isEmpty()) {
                    if (((String)s1).toLowerCase().indexOf("alter") != -1) {
                        s1 = ((String)s1).replace(s0, s0 + "_" + i).replace(table.getName(), table.getName() + "_" + i);
                    } else {
                        idx = ((String)s1).toLowerCase().indexOf(" on ");
                        String s2 = ((String)s1).substring(0, idx).replace(s0, s0 + "_" + i);
                        s1 = ((String)s1).substring(idx);
                        idx = ((String)s1).indexOf("(");
                        String s3 = ((String)s1).substring(0, idx).replace(table.getName(), table.getName() + "_" + i);
                        s1 = ((String)s1).substring(idx);
                        s1 = s2 + s3 + (String)s1;
                    }
                } else {
                    idx = ((String)s1).indexOf("(");
                    s1 = ((String)s1).substring(0, idx).replace(table.getName(), table.getName() + "_" + i) + ((String)s1).substring(idx);
                }
                if (!re.isEmpty() && (idx = ((String)s1).toLowerCase().indexOf("references")) != -1) {
                    String t0 = ((String)s1).substring(0, idx);
                    String t1 = ((String)s1).substring(idx);
                    idx = t1.indexOf("(");
                    String t2 = "";
                    if (idx != -1) {
                        t2 = t1.substring(idx);
                        t1 = t1.substring(0, idx);
                    }
                    t1 = t1.replace(re, re + "_" + i);
                    s1 = t0 + t1 + t2;
                }
                sqls.add((String)s1);
            }
        }
        return sqls;
    }

    public static List<Creation> create(EntityInfo entityInfo, Integer total, EntityInfo ... entityInfosWithReplica) {
        ArrayList<Creation> creations = new ArrayList<Creation>();
        List<String> sqls = EntityReplica.getSQL(entityInfo, total, entityInfosWithReplica);
        TrxManagerInfo trxManagerInfo = entityInfo.getTrxManagerInfo();
        for (final String sql : sqls) {
            Creation creation = new Creation();
            creation.setSql(sql);
            try {
                trxManagerInfo.transaction(true, new SessionCallable<Void>(){

                    @Override
                    public Void call(Session session) throws Exception {
                        DepreHelper.createNativeQuery((SharedSessionContract)session, sql).executeUpdate();
                        return null;
                    }
                });
                creation.setSuccess("OK");
            }
            catch (Exception e) {
                creation.setError("NOK: " + e);
            }
            creations.add(creation);
        }
        return creations;
    }

    public static class Creation {
        private String sql;
        private String success;
        private String error;

        public void setSql(String sql) {
            this.sql = sql;
        }

        public void setSuccess(String success) {
            this.success = success;
        }

        public void setError(String error) {
            this.error = error;
        }

        public String getSql() {
            return this.sql;
        }

        public String getSuccess() {
            return this.success;
        }

        public String getError() {
            return this.error;
        }
    }
}

