/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.entity;

import jakarta.persistence.EntityManagerFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import net.ideahut.springboot.bean.BeanConfigure;
import net.ideahut.springboot.entity.EntityIntegrator;
import net.ideahut.springboot.entity.EntityNative0;
import net.ideahut.springboot.entity.EntityNative1;
import net.ideahut.springboot.entity.EntityPostListener;
import net.ideahut.springboot.entity.EntityPreListener;
import net.ideahut.springboot.entity.EntityReplica;
import net.ideahut.springboot.entity.EntityTrxManager;
import net.ideahut.springboot.entity.InternalHelper;
import net.ideahut.springboot.entity.NativeSelectValue;
import net.ideahut.springboot.entity.TrxManagerInfo;
import net.ideahut.springboot.init.InitMapper;
import org.hibernate.SessionFactory;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.grammars.hql.HqlParser;
import org.springframework.context.ApplicationContext;
import org.springframework.data.repository.support.DomainClassConverter;
import org.springframework.transaction.PlatformTransactionManager;

public class EntityTrxManagerImpl
implements EntityTrxManager,
InitMapper,
BeanConfigure<EntityTrxManager> {
    private boolean configured = false;
    private Map<String, TrxManagerInfo> trxManagerInfoNames = new HashMap<String, TrxManagerInfo>();
    private Map<PlatformTransactionManager, TrxManagerInfo> trxManagerInfoManagers = new HashMap<PlatformTransactionManager, TrxManagerInfo>();
    private TrxManagerInfo defaultTrxManagerInfo;
    private Boolean autoDetectEntityListeners;
    private List<EntityPreListener> entityPreListeners;
    private List<EntityPostListener> entityPostListeners;

    public EntityTrxManagerImpl setAutoDetectEntityListeners(Boolean autoDetectEntityListeners) {
        this.autoDetectEntityListeners = autoDetectEntityListeners;
        return this;
    }

    public EntityTrxManagerImpl setEntityPreListeners(List<EntityPreListener> entityPreListeners) {
        this.entityPreListeners = entityPreListeners;
        return this;
    }

    public EntityTrxManagerImpl setEntityPostListeners(List<EntityPostListener> entityPostListeners) {
        this.entityPostListeners = entityPostListeners;
        return this;
    }

    @Override
    public void onInitMapper() throws Exception {
        EntityNative0.class.getName();
        EntityNative0.FreshEntity.class.getName();
        EntityNative1.class.getName();
        EntityReplica.class.getName();
        EntityReplica.Creation.class.getName();
        NativeSelectValue.Nsv.class.getName();
        DomainClassConverter.class.getName();
        HqlParser.class.getName();
    }

    @Override
    public Callable<EntityTrxManager> onConfigureBean(final ApplicationContext applicationContext) {
        final EntityTrxManagerImpl self = this;
        return new Callable<EntityTrxManager>(){

            @Override
            public EntityTrxManager call() throws Exception {
                EntityTrxManagerImpl.this.trxManagerInfoNames.clear();
                EntityTrxManagerImpl.this.trxManagerInfoManagers.clear();
                if (!Boolean.FALSE.equals(EntityTrxManagerImpl.this.autoDetectEntityListeners)) {
                    Map mapEntityPostListeners;
                    Map mapEntityPreListeners = applicationContext.getBeansOfType(EntityPreListener.class);
                    if (mapEntityPreListeners != null) {
                        EntityTrxManagerImpl.this.entityPreListeners = new ArrayList(mapEntityPreListeners.values());
                    }
                    if ((mapEntityPostListeners = applicationContext.getBeansOfType(EntityPostListener.class)) != null) {
                        EntityTrxManagerImpl.this.entityPostListeners = new ArrayList(mapEntityPostListeners.values());
                    }
                }
                List<EntityPreListener> entityPreListenersEi = EntityTrxManagerImpl.this.entityPreListeners != null ? Collections.unmodifiableList(EntityTrxManagerImpl.this.entityPreListeners) : null;
                List<EntityPostListener> entityPostListenersEi = EntityTrxManagerImpl.this.entityPostListeners != null ? Collections.unmodifiableList(EntityTrxManagerImpl.this.entityPostListeners) : null;
                Map mapContextTrxManager = applicationContext.getBeansOfType(PlatformTransactionManager.class);
                for (Map.Entry entry : mapContextTrxManager.entrySet()) {
                    String auditBeanName;
                    TrxManagerInfo trxManagerInfo = new TrxManagerInfo((String)entry.getKey(), self, (PlatformTransactionManager)entry.getValue());
                    EntityManagerFactory platformEmf = EntityIntegrator.entityManagerFactory((PlatformTransactionManager)entry.getValue());
                    if (platformEmf == null) {
                        platformEmf = EntityIntegrator.sessionFactory((PlatformTransactionManager)entry.getValue());
                        if (platformEmf instanceof SessionFactoryImplementor) {
                            InternalHelper.registerListeners((SessionFactoryImplementor)platformEmf);
                        }
                    } else {
                        InternalHelper.registerListeners(platformEmf);
                    }
                    if (platformEmf != null) {
                        EntityIntegrator.setEntityPreListeners(platformEmf, entityPreListenersEi);
                        EntityIntegrator.setEntityPostListeners(platformEmf, entityPostListenersEi);
                    }
                    SessionFactoryImplementor trxSessionFactory = trxManagerInfo.getIntegrator().getSessionFactory();
                    SessionFactory auditSessionFactory = EntityIntegrator.getAuditSessionFactory((SessionFactory)trxSessionFactory);
                    String auditId = EntityIntegrator.getAuditIdentifier((SessionFactory)trxSessionFactory);
                    if (auditSessionFactory == null && auditId != null && !auditId.isEmpty() && (auditBeanName = EntityIntegrator.getAuditBeanName((SessionFactory)trxSessionFactory)) != null && !auditBeanName.isEmpty()) {
                        auditSessionFactory = (SessionFactory)applicationContext.getBean(auditBeanName);
                        EntityIntegrator.setAuditSessionFactory(auditId, (EntityManagerFactory)trxSessionFactory, auditSessionFactory);
                        if (platformEmf != null) {
                            EntityIntegrator.setAuditSessionFactory(auditId, platformEmf, auditSessionFactory);
                        }
                    }
                    EntityIntegrator.setEntityPreListeners((EntityManagerFactory)trxSessionFactory, entityPreListenersEi);
                    EntityIntegrator.setEntityPostListeners((EntityManagerFactory)trxSessionFactory, entityPostListenersEi);
                    InternalHelper.registerListeners((EntityManagerFactory)trxSessionFactory);
                    EntityTrxManagerImpl.this.trxManagerInfoNames.put((String)entry.getKey(), trxManagerInfo);
                    EntityTrxManagerImpl.this.trxManagerInfoManagers.put((PlatformTransactionManager)entry.getValue(), trxManagerInfo);
                }
                PlatformTransactionManager defaultTransactionManager = (PlatformTransactionManager)applicationContext.getBean(PlatformTransactionManager.class);
                EntityTrxManagerImpl.this.defaultTrxManagerInfo = EntityTrxManagerImpl.this.trxManagerInfoManagers.get(defaultTransactionManager);
                EntityTrxManagerImpl.this.configured = true;
                return self;
            }
        };
    }

    @Override
    public boolean isBeanConfigured() {
        return this.configured;
    }

    @Override
    public TrxManagerInfo getTrxManagerInfo(String name) {
        BeanConfigure.checkBeanConfigure(this);
        return this.trxManagerInfoNames.get(name);
    }

    @Override
    public TrxManagerInfo getTrxManagerInfo(PlatformTransactionManager transactionManager) {
        BeanConfigure.checkBeanConfigure(this);
        return this.trxManagerInfoManagers.get(transactionManager);
    }

    @Override
    public TrxManagerInfo getDefaultTrxManagerInfo() {
        BeanConfigure.checkBeanConfigure(this);
        return this.defaultTrxManagerInfo;
    }

    @Override
    public Collection<TrxManagerInfo> getTrxManagerInfos() {
        BeanConfigure.checkBeanConfigure(this);
        return this.trxManagerInfoManagers.values();
    }
}

