/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.entity;

import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Selection;
import java.lang.reflect.Field;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.ideahut.springboot.context.RequestContext;
import net.ideahut.springboot.entity.DepreHelper;
import net.ideahut.springboot.entity.EntityAudit;
import net.ideahut.springboot.entity.EntityIntegrator;
import net.ideahut.springboot.entity.EntityPostListener;
import net.ideahut.springboot.entity.EntityPreListener;
import net.ideahut.springboot.entity.EntitySoftDelete;
import net.ideahut.springboot.entity.InternalPostDeleteListener;
import net.ideahut.springboot.entity.InternalPostInsertListener;
import net.ideahut.springboot.entity.InternalPostUpdateListener;
import net.ideahut.springboot.entity.InternalPreDeleteListener;
import net.ideahut.springboot.entity.InternalPreInsertListener;
import net.ideahut.springboot.entity.InternalPreUpdateListener;
import net.ideahut.springboot.util.FrameworkUtil;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.SharedSessionContract;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.event.service.spi.EventListenerGroup;
import org.hibernate.event.service.spi.EventListenerRegistry;
import org.hibernate.event.spi.EventType;
import org.hibernate.internal.SessionFactoryImpl;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.query.Query;
import org.hibernate.query.QueryProducer;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.service.spi.ServiceRegistryImplementor;

final class InternalHelper {
    private InternalHelper() {
    }

    static Map<String, Integer> getStateIndexes(Object entity, EntityPersister persister) {
        return DepreHelper.getStateIndexes(entity, persister);
    }

    static void setStateValue(Map<String, Integer> indexes, Object[] state, String name, Object value) {
        Integer index = indexes.get(name);
        if (index != null) {
            state[index.intValue()] = value;
        }
    }

    static void registerListeners(EntityManagerFactory entityManagerFactory) {
        SessionFactoryImpl sessionFactory = (SessionFactoryImpl)entityManagerFactory.unwrap(SessionFactoryImpl.class);
        InternalHelper.registerListeners((SessionFactoryImplementor)sessionFactory);
    }

    static void registerListeners(SessionFactoryImplementor sessionFactory) {
        ServiceRegistryImplementor serviceRegistry = sessionFactory.getServiceRegistry();
        InternalHelper.registerListener((ServiceRegistry)serviceRegistry, EventType.PRE_INSERT, new InternalPreInsertListener());
        InternalHelper.registerListener((ServiceRegistry)serviceRegistry, EventType.PRE_UPDATE, new InternalPreUpdateListener());
        InternalHelper.registerListener((ServiceRegistry)serviceRegistry, EventType.PRE_DELETE, new InternalPreDeleteListener());
        InternalHelper.registerListener((ServiceRegistry)serviceRegistry, EventType.POST_INSERT, new InternalPostInsertListener());
        InternalHelper.registerListener((ServiceRegistry)serviceRegistry, EventType.POST_UPDATE, new InternalPostUpdateListener());
        InternalHelper.registerListener((ServiceRegistry)serviceRegistry, EventType.POST_DELETE, new InternalPostDeleteListener());
    }

    private static void registerListener(ServiceRegistry serviceRegistry, EventType eventType, Object listener) {
        EventListenerGroup group;
        EventListenerRegistry registry = (EventListenerRegistry)serviceRegistry.getService(EventListenerRegistry.class);
        if (registry != null && (group = registry.getEventListenerGroup(eventType)) != null) {
            boolean found = false;
            for (Object object : DepreHelper.getListeners(group)) {
                if (!object.getClass().equals(listener.getClass())) continue;
                found = true;
                break;
            }
            if (!found) {
                try {
                    registry.appendListeners(eventType, new Object[]{listener});
                }
                catch (Exception e) {
                    throw FrameworkUtil.exception(e);
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static Object[] getEntityWithoutGenerator(QueryProducer session, Object entity, Object id, EntityPersister persister) throws Exception {
        CriteriaBuilder criteriaBuilder = ((EntityManager)session).getCriteriaBuilder();
        CriteriaQuery criteriaQuery = criteriaBuilder.createQuery(entity.getClass());
        Root root = criteriaQuery.from(entity.getClass());
        ArrayList<String> ignoredFields = new ArrayList<String>();
        if (entity instanceof EntitySoftDelete) {
            ignoredFields.add("deletedOn");
        }
        if (entity instanceof EntityAudit) {
            ignoredFields.addAll(EntityAudit.Name.Field.list());
        }
        List<Field> compositeIds = EntityIntegrator.getCompositeIds(entity.getClass());
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        StringBuilder key = new StringBuilder();
        if (compositeIds != null) {
            for (Field field : compositeIds) {
                ignoredFields.add(field.getName());
                predicates.add(criteriaBuilder.equal((Expression)root.get(field.getName()), field.get(entity)));
                key.append(field.getName()).append(",");
            }
            if (key.length() == 0) throw new SQLException("id is required");
            key.deleteCharAt(key.length() - 1);
        } else {
            if (id == null) {
                throw new SQLException("id is required");
            }
            ignoredFields.add(persister.getIdentifierPropertyName());
            key.append(persister.getIdentifierPropertyName());
            predicates.add(criteriaBuilder.equal((Expression)root.get(persister.getIdentifierPropertyName()), id));
        }
        criteriaQuery.select((Selection)root).where(predicates.toArray(new Predicate[0]));
        Query query = ((Session)session).createQuery(criteriaQuery);
        Object dbEntity = query.uniqueResult();
        return new Object[]{dbEntity, ignoredFields, key};
    }

    static final class Stage {
        private Boolean skip;
        private Boolean insert;
        private Boolean delete;

        private Stage() {
        }

        static void setSkip(SharedSessionContract session) {
            Stage.get((SharedSessionContract)session).skip = Boolean.TRUE;
        }

        static boolean isSkip(SharedSessionContract session) {
            return Boolean.TRUE.equals(Stage.get((SharedSessionContract)session).skip);
        }

        static void setInsert(SharedSessionContract session) {
            Stage.get((SharedSessionContract)session).insert = Boolean.TRUE;
        }

        static boolean isInsert(SharedSessionContract session) {
            return Boolean.TRUE.equals(Stage.get((SharedSessionContract)session).insert);
        }

        static void setDelete(SharedSessionContract session) {
            Stage.get((SharedSessionContract)session).delete = Boolean.TRUE;
        }

        static boolean isDelete(SharedSessionContract session) {
            return Boolean.TRUE.equals(Stage.get((SharedSessionContract)session).delete);
        }

        static void destroy(SharedSessionContract session) {
            Stage.del(session);
        }

        private static Stage get(SharedSessionContract session) {
            Stage stage;
            if (session == null) {
                return new Stage();
            }
            HashMap<SharedSessionContract, Stage> stages = (HashMap<SharedSessionContract, Stage>)RequestContext.currentContext().getAttribute(Stage.class.getName());
            if (stages == null) {
                stages = new HashMap<SharedSessionContract, Stage>();
                RequestContext.currentContext().setAttribute(Stage.class.getName(), stages);
            }
            if ((stage = (Stage)stages.get(session)) == null) {
                stage = new Stage();
                stages.put(session, stage);
            }
            return stage;
        }

        private static void del(SharedSessionContract session) {
            Map stages = (Map)RequestContext.currentContext().getAttribute(Stage.class.getName());
            if (stages != null) {
                stages.remove(session);
            }
        }

        static void onPreInsert(SessionFactory sessionFactory, Object entity) {
            List<EntityPreListener> listeners = EntityIntegrator.getEntityPreListeners(sessionFactory);
            if (listeners != null) {
                for (EntityPreListener listener : listeners) {
                    listener.onPreInsert(entity);
                }
            }
        }

        static void onPostInsert(SessionFactory sessionFactory, Object entity) {
            List<EntityPostListener> listeners = EntityIntegrator.getEntityPostListeners(sessionFactory);
            if (listeners != null) {
                for (EntityPostListener listener : listeners) {
                    listener.onPostInsert(entity);
                }
            }
        }

        static void onPreUpdate(SessionFactory sessionFactory, Object entity) {
            List<EntityPreListener> listeners = EntityIntegrator.getEntityPreListeners(sessionFactory);
            if (listeners != null) {
                for (EntityPreListener listener : listeners) {
                    listener.onPreUpdate(entity);
                }
            }
        }

        static void onPostUpdate(SessionFactory sessionFactory, Object entity) {
            List<EntityPostListener> listeners = EntityIntegrator.getEntityPostListeners(sessionFactory);
            if (listeners != null) {
                for (EntityPostListener listener : listeners) {
                    listener.onPostUpdate(entity);
                }
            }
        }

        static void onPreDelete(SessionFactory sessionFactory, Object entity) {
            List<EntityPreListener> listeners = EntityIntegrator.getEntityPreListeners(sessionFactory);
            if (listeners != null) {
                for (EntityPreListener listener : listeners) {
                    listener.onPreDelete(entity);
                }
            }
        }

        static void onPostDelete(SessionFactory sessionFactory, Object entity) {
            List<EntityPostListener> listeners = EntityIntegrator.getEntityPostListeners(sessionFactory);
            if (listeners != null) {
                for (EntityPostListener listener : listeners) {
                    listener.onPostDelete(entity);
                }
            }
        }
    }
}

