/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.entity;

import java.util.LinkedHashMap;
import java.util.Map;
import net.ideahut.springboot.entity.EntityInfo;
import net.ideahut.springboot.entity.EntityNative;
import net.ideahut.springboot.entity.InIdsQuery;
import net.ideahut.springboot.entity.NativeAutoGeneratedId;
import net.ideahut.springboot.entity.NativeFreshAppender;
import net.ideahut.springboot.entity.NativeInIdsQuery;
import net.ideahut.springboot.entity.NativeInsertIdentity;

final class NativeEntityDefinition {
    private InIdsQuery inIdsQuery;
    private NativeInsertIdentity insertIdentity;
    private NativeAutoGeneratedId autoGeneratedId;
    private NativeFreshAppender freshAppender;
    private Map<String, EntityNative.ColumnConverter> columnConverters;

    private NativeEntityDefinition() {
    }

    NativeEntityDefinition setColumnConverters(Map<String, EntityNative.ColumnConverter> columnConverters) {
        this.columnConverters = columnConverters;
        return this;
    }

    static NativeEntityDefinition of(EntityInfo entityInfo) {
        NativeEntityDefinition definition = new NativeEntityDefinition();
        definition.inIdsQuery = NativeInIdsQuery.of(entityInfo);
        definition.insertIdentity = NativeInsertIdentity.of(entityInfo);
        definition.autoGeneratedId = NativeAutoGeneratedId.of(entityInfo);
        definition.freshAppender = NativeFreshAppender.of(entityInfo);
        definition.columnConverters = new LinkedHashMap<String, EntityNative.ColumnConverter>();
        return definition;
    }

    public InIdsQuery getInIdsQuery() {
        return this.inIdsQuery;
    }

    public NativeInsertIdentity getInsertIdentity() {
        return this.insertIdentity;
    }

    public NativeAutoGeneratedId getAutoGeneratedId() {
        return this.autoGeneratedId;
    }

    public NativeFreshAppender getFreshAppender() {
        return this.freshAppender;
    }

    public Map<String, EntityNative.ColumnConverter> getColumnConverters() {
        return this.columnConverters;
    }
}

