/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.entity;

import java.util.Iterator;
import java.util.List;
import net.ideahut.springboot.entity.AttributeOverrides;
import net.ideahut.springboot.entity.DatabaseType;
import net.ideahut.springboot.entity.EntityInfo;
import net.ideahut.springboot.entity.EntityNative;
import net.ideahut.springboot.entity.FieldInfo;
import net.ideahut.springboot.entity.IdInfo;
import net.ideahut.springboot.entity.InIdsQuery;
import net.ideahut.springboot.util.FrameworkUtil;

final class NativeInIdsQuery {
    static DatabaseType.InIdsQueryCreator None = new DatabaseType.InIdsQueryCreator(){

        @Override
        public InIdsQuery createInIdsQuery(EntityInfo entityInfo) {
            return new InIdsQuery(){

                @Override
                public String getInIdsQuery(List<Object> ids, String alias, List parameters, Integer startIndex) {
                    return "";
                }
            };
        }
    };
    static DatabaseType.InIdsQueryCreator Standard = new DatabaseType.InIdsQueryCreator(){

        @Override
        public InIdsQuery createInIdsQuery(EntityInfo entityInfo) {
            IdInfo idInfo = entityInfo.getIdInfo();
            final FieldInfo idField = entityInfo.getFieldInfo(idInfo.getFields().iterator().next());
            return new InIdsQuery(){

                @Override
                public String getInIdsQuery(List<Object> ids, String alias, List parameters, Integer startIndex) {
                    Object query = "(" + EntityNative.aliasColumn(alias, idField.getColumn().getName()) + " in (";
                    for (Object id : ids) {
                        query = (String)query + "?" + (parameters.size() + startIndex) + ",";
                        parameters.add(EntityNative.Parameter.of(idField.getHibernateType(), id));
                    }
                    query = ((String)query).substring(0, ((String)query).length() - 1);
                    query = (String)query + "))";
                    return query;
                }
            };
        }
    };

    private NativeInIdsQuery() {
    }

    static InIdsQuery of(EntityInfo entityInfo) {
        DatabaseType databaseType = entityInfo.getTrxManagerInfo().getIntegrator().getDatabaseType();
        return databaseType.getInIdsQueryCreators().getNativeInIdsQueryCreator(entityInfo.getIdInfo().getIdType()).createInIdsQuery(entityInfo);
    }

    static class Composite {
        static DatabaseType.InIdsQueryCreator INLINE = new DatabaseType.InIdsQueryCreator(){

            @Override
            public InIdsQuery createInIdsQuery(final EntityInfo entityInfo) {
                final IdInfo idInfo = entityInfo.getIdInfo();
                return new InIdsQuery(){

                    @Override
                    public String getInIdsQuery(List<Object> ids, String alias, List parameters, Integer startIndex) {
                        try {
                            Object query = "(";
                            for (Object id : ids) {
                                for (String name : idInfo.getFields()) {
                                    FieldInfo feInfo = entityInfo.getFieldInfo(name);
                                    query = (String)query + EntityNative.aliasColumn(alias, feInfo.getColumn().getName()) + "=?" + (parameters.size() + startIndex) + " and ";
                                    parameters.add(EntityNative.Parameter.of(feInfo.getHibernateType(), feInfo.getValue(id)));
                                }
                                query = ((String)query).substring(0, ((String)query).length() - 5);
                                query = (String)query + " or ";
                            }
                            query = ((String)query).substring(0, ((String)query).length() - 4);
                            query = (String)query + ")";
                            return query;
                        }
                        catch (Exception e) {
                            throw FrameworkUtil.exception(e);
                        }
                    }
                };
            }
        };
        static DatabaseType.InIdsQueryCreator BRACKET = new DatabaseType.InIdsQueryCreator(){

            @Override
            public InIdsQuery createInIdsQuery(final EntityInfo entityInfo) {
                final IdInfo idInfo = entityInfo.getIdInfo();
                return new InIdsQuery(){

                    @Override
                    public String getInIdsQuery(List<Object> ids, String alias, List parameters, Integer startIndex) {
                        try {
                            Object fieldQl = "(";
                            Iterator<String> iter = idInfo.getFields().iterator();
                            while (iter.hasNext()) {
                                FieldInfo cfInfo = entityInfo.getFieldInfo(iter.next());
                                fieldQl = (String)fieldQl + EntityNative.aliasColumn(alias, cfInfo.getColumn().getName()) + ",";
                            }
                            fieldQl = ((String)fieldQl).substring(0, ((String)fieldQl).length() - 1);
                            fieldQl = (String)fieldQl + ")";
                            Object valueQl = "(";
                            for (Object id : ids) {
                                Object paramQl = "(";
                                iter = idInfo.getFields().iterator();
                                while (iter.hasNext()) {
                                    FieldInfo cfInfo = entityInfo.getFieldInfo(iter.next());
                                    paramQl = (String)paramQl + "?" + (parameters.size() + startIndex) + ",";
                                    parameters.add(EntityNative.Parameter.of(cfInfo.getHibernateType(), cfInfo.getValue(id)));
                                }
                                paramQl = ((String)paramQl).substring(0, ((String)paramQl).length() - 1);
                                paramQl = (String)paramQl + ")";
                                valueQl = (String)valueQl + (String)paramQl + ",";
                            }
                            valueQl = ((String)valueQl).substring(0, ((String)valueQl).length() - 1) + ")";
                            return "(" + (String)fieldQl + " in " + (String)valueQl + ")";
                        }
                        catch (Exception e) {
                            throw FrameworkUtil.exception(e);
                        }
                    }
                };
            }
        };

        private Composite() {
        }
    }

    static class Embedded {
        static DatabaseType.InIdsQueryCreator INLINE = new DatabaseType.InIdsQueryCreator(){

            @Override
            public InIdsQuery createInIdsQuery(EntityInfo entityInfo) {
                InIdsQuery inIdsQuery = null;
                IdInfo idInfo = entityInfo.getIdInfo();
                FieldInfo idField = entityInfo.getFieldInfo(idInfo.getFields().iterator().next());
                if (idField.hasAttributeOverrides()) {
                    final AttributeOverrides attributeOverrides = idField.getAttributeOverrides();
                    inIdsQuery = new InIdsQuery(){

                        @Override
                        public String getInIdsQuery(List<Object> ids, String alias, List parameters, Integer startIndex) {
                            try {
                                Object query = "(";
                                for (Object id : ids) {
                                    for (String column : attributeOverrides.getColums()) {
                                        FieldInfo attrFieldInfo = attributeOverrides.getFieldInfo(column);
                                        query = (String)query + EntityNative.aliasColumn(alias, column) + "=?" + (parameters.size() + startIndex) + " and ";
                                        parameters.add(EntityNative.Parameter.of(attrFieldInfo.getHibernateType(), attrFieldInfo.getValue(id)));
                                    }
                                    query = ((String)query).substring(0, ((String)query).length() - 5);
                                    query = (String)query + " or ";
                                }
                                query = ((String)query).substring(0, ((String)query).length() - 4);
                                query = (String)query + ")";
                                return query;
                            }
                            catch (Exception e) {
                                throw FrameworkUtil.exception(e);
                            }
                        }
                    };
                } else {
                    final EntityInfo embeddedInfo = idInfo.getEmbeddedEntityInfo();
                    inIdsQuery = new InIdsQuery(){

                        @Override
                        public String getInIdsQuery(List<Object> ids, String alias, List parameters, Integer startIndex) {
                            try {
                                Object query = "(";
                                for (Object id : ids) {
                                    for (String name : embeddedInfo.getFieldInfoNames()) {
                                        FieldInfo feInfo = embeddedInfo.getFieldInfo(name);
                                        query = (String)query + EntityNative.aliasColumn(alias, feInfo.getColumn().getName()) + "=?" + (parameters.size() + startIndex) + " and ";
                                        parameters.add(EntityNative.Parameter.of(feInfo.getHibernateType(), feInfo.getValue(id)));
                                    }
                                    query = ((String)query).substring(0, ((String)query).length() - 5);
                                    query = (String)query + " or ";
                                }
                                query = ((String)query).substring(0, ((String)query).length() - 4);
                                query = (String)query + ")";
                                return query;
                            }
                            catch (Exception e) {
                                throw FrameworkUtil.exception(e);
                            }
                        }
                    };
                }
                return inIdsQuery;
            }
        };
        static DatabaseType.InIdsQueryCreator BRACKET = new DatabaseType.InIdsQueryCreator(){

            @Override
            public InIdsQuery createInIdsQuery(EntityInfo entityInfo) {
                InIdsQuery inIdsQuery = null;
                IdInfo idInfo = entityInfo.getIdInfo();
                FieldInfo idField = entityInfo.getFieldInfo(idInfo.getFields().iterator().next());
                if (idField.hasAttributeOverrides()) {
                    final AttributeOverrides attributeOverrides = idField.getAttributeOverrides();
                    inIdsQuery = new InIdsQuery(){

                        @Override
                        public String getInIdsQuery(List<Object> ids, String alias, List parameters, Integer startIndex) {
                            try {
                                Object fieldQl = "(";
                                for (String column : attributeOverrides.getColums()) {
                                    fieldQl = (String)fieldQl + EntityNative.aliasColumn(alias, column) + ",";
                                }
                                fieldQl = ((String)fieldQl).substring(0, ((String)fieldQl).length() - 1);
                                fieldQl = (String)fieldQl + ")";
                                Object valueQl = "(";
                                for (Object id : ids) {
                                    Object paramQl = "(";
                                    for (String column : attributeOverrides.getColums()) {
                                        FieldInfo attrFieldInfo = attributeOverrides.getFieldInfo(column);
                                        paramQl = (String)paramQl + "?" + (parameters.size() + startIndex) + ",";
                                        parameters.add(EntityNative.Parameter.of(attrFieldInfo.getHibernateType(), attrFieldInfo.getValue(id)));
                                    }
                                    paramQl = ((String)paramQl).substring(0, ((String)paramQl).length() - 1);
                                    paramQl = (String)paramQl + ")";
                                    valueQl = (String)valueQl + (String)paramQl + ",";
                                }
                                valueQl = ((String)valueQl).substring(0, ((String)valueQl).length() - 1) + ")";
                                return "(" + (String)fieldQl + " in " + (String)valueQl + ")";
                            }
                            catch (Exception e) {
                                throw FrameworkUtil.exception(e);
                            }
                        }
                    };
                } else {
                    final EntityInfo embeddedInfo = idInfo.getEmbeddedEntityInfo();
                    inIdsQuery = new InIdsQuery(){

                        @Override
                        public String getInIdsQuery(List<Object> ids, String alias, List parameters, Integer startIndex) {
                            try {
                                Object fieldQl = "(";
                                for (String name : embeddedInfo.getFieldInfoNames()) {
                                    FieldInfo feInfo = embeddedInfo.getFieldInfo(name);
                                    fieldQl = (String)fieldQl + EntityNative.aliasColumn(alias, feInfo.getColumn().getName()) + ",";
                                }
                                fieldQl = ((String)fieldQl).substring(0, ((String)fieldQl).length() - 1);
                                fieldQl = (String)fieldQl + ")";
                                Object valueQl = "(";
                                for (Object id : ids) {
                                    Object paramQl = "(";
                                    for (String name : embeddedInfo.getFieldInfoNames()) {
                                        FieldInfo feInfo = embeddedInfo.getFieldInfo(name);
                                        paramQl = (String)paramQl + "?" + (parameters.size() + startIndex) + ",";
                                        parameters.add(EntityNative.Parameter.of(feInfo.getHibernateType(), feInfo.getValue(id)));
                                    }
                                    paramQl = ((String)paramQl).substring(0, ((String)paramQl).length() - 1);
                                    paramQl = (String)paramQl + ")";
                                    valueQl = (String)valueQl + (String)paramQl + ",";
                                }
                                valueQl = ((String)valueQl).substring(0, ((String)valueQl).length() - 1) + ")";
                                return "(" + (String)fieldQl + " in " + (String)valueQl + ")";
                            }
                            catch (Exception e) {
                                throw FrameworkUtil.exception(e);
                            }
                        }
                    };
                }
                return inIdsQuery;
            }
        };

        private Embedded() {
        }
    }
}

