/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.entity;

import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import java.lang.reflect.Method;
import java.util.List;
import net.ideahut.springboot.entity.DatabaseType;
import net.ideahut.springboot.entity.EntityIdType;
import net.ideahut.springboot.entity.EntityInfo;
import net.ideahut.springboot.entity.EntityNative;
import net.ideahut.springboot.entity.FieldInfo;
import net.ideahut.springboot.entity.IdInfo;
import net.ideahut.springboot.util.FrameworkUtil;
import org.hibernate.SharedSessionContract;

interface NativeInsertIdentity {
    public void executeInsert(SharedSessionContract var1, String var2, Object var3, String var4, List<EntityNative.Parameter> var5) throws Exception;

    public static NativeInsertIdentity of(EntityInfo info) {
        DatabaseType databaseType = info.getTrxManagerInfo().getIntegrator().getDatabaseType();
        return databaseType.getNativeInsertIdentityCreator().createNativeInsertIdentity(info);
    }

    public static boolean isSupportIdentity(EntityInfo info) {
        IdInfo idInfo = info.getIdInfo();
        if (EntityIdType.STANDARD == idInfo.getIdType()) {
            FieldInfo idFieldInfo = info.getFieldInfo(idInfo.getFields().iterator().next());
            GeneratedValue generatedValue = idInfo.getGeneratedValue();
            return !(generatedValue == null || !GenerationType.SEQUENCE.equals((Object)generatedValue.strategy()) && !GenerationType.IDENTITY.equals((Object)generatedValue.strategy()) && !"native".equals(generatedValue.generator().toLowerCase()) || !Number.class.isAssignableFrom(idFieldInfo.getType()) && Long.TYPE != idFieldInfo.getType() && Integer.TYPE != idFieldInfo.getType());
        }
        return false;
    }

    public static NativeLastInsertId createNativeLastInsertId(EntityInfo info) {
        NativeLastInsertId nativeLastInsertId = null;
        if (NativeInsertIdentity.isSupportIdentity(info)) {
            IdInfo idInfo = info.getIdInfo();
            final FieldInfo idFieldInfo = info.getFieldInfo(idInfo.getFields().iterator().next());
            if (Number.class.isAssignableFrom(idFieldInfo.getType())) {
                Method method;
                try {
                    method = idFieldInfo.getType().getMethod("valueOf", String.class);
                }
                catch (Exception e) {
                    throw FrameworkUtil.exception(e);
                }
                nativeLastInsertId = new NativeLastInsertId(){

                    @Override
                    public void setLastInsertId(Object entity, Object insertedId) throws Exception {
                        Object value = method.invoke(null, "" + insertedId);
                        idFieldInfo.setValue(entity, value);
                    }
                };
            } else if (Long.TYPE == idFieldInfo.getType()) {
                nativeLastInsertId = new NativeLastInsertId(){

                    @Override
                    public void setLastInsertId(Object entity, Object insertedId) throws Exception {
                        long value = Long.valueOf("" + insertedId);
                        idFieldInfo.setValue(entity, value);
                    }
                };
            } else if (Integer.TYPE == idFieldInfo.getType()) {
                nativeLastInsertId = new NativeLastInsertId(){

                    @Override
                    public void setLastInsertId(Object entity, Object insertedId) throws Exception {
                        int value = Integer.valueOf("" + insertedId);
                        idFieldInfo.setValue(entity, value);
                    }
                };
            }
        }
        if (nativeLastInsertId == null) {
            nativeLastInsertId = new NativeLastInsertId(){

                @Override
                public void setLastInsertId(Object entity, Object insertedId) throws Exception {
                }
            };
        }
        return nativeLastInsertId;
    }

    public static interface NativeLastInsertId {
        public void setLastInsertId(Object var1, Object var2) throws Exception;
    }
}

